/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.entity;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Highlight;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.record.ModelComponent;
import gaiasky.util.Bits;
import gaiasky.util.CatalogInfo;
import gaiasky.util.ModelCache;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3D;
import java.util.Map;
import java.util.TreeMap;

public class ParticleUtils {
    private final Vector3D D31 = new Vector3D();
    protected final Color c = new Color();
    protected final float[] hsv = new float[3];

    public float getDatasetSizeFactor(Entity entity, Highlight hl, DatasetDescription dd) {
        return (hl != null && hl.highlighted && dd != null && dd.catalogInfo != null ? dd.catalogInfo.hlSizeFactor : 1.0f) * this.getPointScaling(hl, (GraphNode)Mapper.graph.get(entity));
    }

    public float getPointScaling(Highlight hl, GraphNode graph) {
        if (hl != null && graph.parent != null) {
            if (Mapper.octree.has(graph.parent)) {
                Highlight hlParent = (Highlight)Mapper.highlight.get(graph.parent);
                return hl.pointscaling * hlParent.pointscaling;
            }
            return hl.pointscaling;
        }
        return 1.0f;
    }

    public double getVariableSizeScaling(StarSet set, int idx) {
        IParticleRecord ipr = (IParticleRecord)set.pointData.get(idx);
        if (ipr.isVariable()) {
            double[] times = ipr.variTimes();
            float[] sizes = ipr.variMags();
            int n = ipr.nVari();
            double t = AstroUtils.getDaysSince(GaiaSky.instance.time.getTime(), set.variabilityEpochJd);
            double t0 = times[0];
            double t1 = times[n - 1];
            double period = t1 - t0;
            t %= period;
            for (int i = 0; i < n - 1; ++i) {
                double x0 = times[i] - t0;
                double x1 = times[i + 1] - t0;
                if (!(t >= x0) || !(t <= x1)) continue;
                return MathUtilsDouble.lint(t, x0, x1, (double)sizes[i], (double)sizes[i + 1]) / (double)ipr.size();
            }
        }
        return 1.0;
    }

    public float saturateColor(int index, ParticleSet set, Highlight highlight) {
        float saturate = Settings.settings.scene.star.saturate;
        float colorPacked = this.getColor(index, set, highlight);
        if (!highlight.highlighted && saturate != 0.0f) {
            Color.abgr8888ToColor((Color)this.c, (float)colorPacked);
            this.c.toHsv(this.hsv);
            this.hsv[1] = MathUtils.clamp((float)(this.hsv[1] + saturate), (float)0.0f, (float)1.0f);
            this.c.fromHsv(this.hsv);
            colorPacked = this.c.toFloatBits();
        }
        return colorPacked;
    }

    public float getColor(int index, ParticleSet set, Highlight highlight) {
        return highlight.highlighted ? Color.toFloatBits((float)highlight.hlc[0], (float)highlight.hlc[1], (float)highlight.hlc[2], (float)highlight.hlc[3]) : set.pointData.get(index).color();
    }

    public float[] getColor(Body body, Highlight highlight) {
        return highlight.highlighted ? highlight.hlc : body.color;
    }

    public boolean filter(int index, ParticleSet particleSet, DatasetDescription datasetDescription) {
        CatalogInfo catalogInfo = datasetDescription.catalogInfo;
        if (catalogInfo != null && catalogInfo.filter != null) {
            return catalogInfo.filter.evaluate(particleSet.get(index));
        }
        return true;
    }

    public void updateFocusDataPos(ParticleSet particleSet) {
        if (particleSet.focusIndex < 0) {
            particleSet.focus = null;
        } else {
            particleSet.focus = particleSet.pointData.get(particleSet.focusIndex);
            particleSet.focusPosition.set(particleSet.focus.x(), particleSet.focus.y(), particleSet.focus.z());
            Vector3D posSph = Coordinates.cartesianToSpherical(particleSet.focusPosition, this.D31);
            particleSet.focusPositionSph.set((float)(57.29577951308232 * posSph.x), (float)(57.29577951308232 * posSph.y));
            particleSet.updateFocus(GaiaSky.instance.getICamera());
        }
    }

    public void initModel(AssetManager manager, Model model) {
        if (model == null) {
            throw new RuntimeException("The incoming star model component can't be null!");
        }
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put("quality", 120L);
        params.put("diameter", 1.0);
        params.put("flip", false);
        Pair<IntModel, Map<String, Material>> pair = ModelCache.cache.getModel("sphere", params, Bits.indices(1, 8, 16), 4);
        IntModel intModel = pair.getFirst();
        Material mat = pair.getSecond().get("base");
        mat.clear();
        mat.set((Attribute)new ColorAttribute(ColorAttribute.Specular));
        mat.set((Attribute)new BlendingAttribute(770, 771));
        Matrix4 modelTransform = new Matrix4();
        model.model = new ModelComponent(false);
        model.model.initialize(null);
        model.model.env = new Environment();
        model.model.env.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 1.0f, 1.0f, 1.0f, 1.0f));
        model.model.env.set((Attribute)new FloatAttribute(FloatAttribute.Time, 0.0f));
        model.model.instance = new IntModelInstance(intModel, modelTransform);
        if (Settings.settings.runtime.relativisticAberration) {
            model.model.rec.setUpRelativisticEffectsMaterial(model.model.instance.materials);
        }
        model.model.setModelInitialized(true);
    }
}

