/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.entity;

import com.badlogic.ashley.core.Entity;
import gaiasky.GaiaSky;
import gaiasky.data.group.DatasetOptions;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Archetype;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Fade;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Highlight;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.system.initialize.BaseInitializer;
import gaiasky.scene.system.initialize.ParticleSetInitializer;
import gaiasky.util.Constants;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;

public class SetUtils {
    public static Entity createStarSet(Scene scene, String name, List<IParticleRecord> data, BaseInitializer baseInitializer, ParticleSetInitializer starSetInitializer, boolean fullInit) {
        Archetype archetype = scene.archetypes().get("StarGroup");
        Entity entity = archetype.createEntity();
        Base base = (Base)Mapper.base.get(entity);
        base.id = ParticleSet.getNextSequence();
        base.setName(name.replace("%%SGID%%", Long.toString(base.id)));
        base.ct = new ComponentTypes(ComponentTypes.ComponentType.Stars);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        graph.setParent("Universe");
        Body body = (Body)Mapper.body.get(entity);
        body.setLabelColor(new double[]{1.0, 1.0, 1.0, 1.0});
        body.setColor(new double[]{1.0, 1.0, 1.0, 0.25});
        body.setSize(6.0 * Constants.DISTANCE_SCALE_FACTOR);
        Label label = (Label)Mapper.label.get(entity);
        label.setLabelPosition(new double[]{0.0, -5.0E7, -4.0E8});
        StarSet set = (StarSet)Mapper.starSet.get(entity);
        set.setData(data, true);
        baseInitializer.initializeEntity(entity);
        starSetInitializer.initializeEntity(entity);
        if (fullInit) {
            baseInitializer.setUpEntity(entity);
            starSetInitializer.setUpEntity(entity);
        }
        return entity;
    }

    public static Entity createStarSet(Scene scene, String name, String file, List<IParticleRecord> data, List<ColumnInfo> columnInfoList, DatasetOptions datasetOptions, boolean addToCatalogManager) {
        double[] dArray;
        double[] fadeOut;
        double[] fadeIn = datasetOptions == null || datasetOptions.fadeIn == null ? null : datasetOptions.fadeIn;
        double[] dArray2 = fadeOut = datasetOptions == null || datasetOptions.fadeOut == null ? null : datasetOptions.fadeOut;
        if (datasetOptions == null || datasetOptions.labelColor == null) {
            double[] dArray3 = new double[4];
            dArray3[0] = 1.0;
            dArray3[1] = 1.0;
            dArray3[2] = 1.0;
            dArray = dArray3;
            dArray3[3] = 1.0;
        } else {
            dArray = datasetOptions.labelColor;
        }
        double[] labelColor = dArray;
        boolean renderSetLabel = datasetOptions == null || datasetOptions.renderSetLabel;
        Archetype archetype = scene.archetypes().get("StarGroup");
        Entity entity = archetype.createEntity();
        Base base = (Base)Mapper.base.get(entity);
        base.id = ParticleSet.getNextSequence();
        base.setName(name.replace("%%SGID%%", Long.toString(base.id)));
        base.setComponentType(ComponentTypes.ComponentType.Stars);
        Body body = (Body)Mapper.body.get(entity);
        body.setColor(new double[]{1.0, 1.0, 1.0, 0.25});
        body.setLabelColor(labelColor);
        body.setSize(6.0);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        graph.setParent("Universe");
        Fade fade = (Fade)Mapper.fade.get(entity);
        fade.setFadeIn(fadeIn);
        fade.setFadeOut(fadeOut);
        Label label = (Label)Mapper.label.get(entity);
        label.setLabelPosition(new double[]{0.0, -5.0E7, -4.0E8});
        StarSet set = (StarSet)Mapper.starSet.get(entity);
        set.setGenerateIndex(true);
        set.setData(data);
        set.setDatafile(file);
        set.setColumnInfoList(columnInfoList);
        set.setRenderSetLabel(renderSetLabel);
        scene.initializeEntity(entity);
        if (addToCatalogManager) {
            scene.setUpEntity(entity);
        }
        return entity;
    }

    public static Entity createParticleSet(Scene scene, String name, String file, List<IParticleRecord> data, List<ColumnInfo> columnInfoList, DatasetOptions datasetOptions, boolean addToCatalogManager) {
        double[] dArray;
        double particleSize;
        double[] dArray2;
        double colorNoise;
        double[] dArray3;
        double[] fadeOut;
        double[] fadeIn = datasetOptions == null || datasetOptions.fadeIn == null ? null : datasetOptions.fadeIn;
        double[] dArray4 = fadeOut = datasetOptions == null || datasetOptions.fadeOut == null ? null : datasetOptions.fadeOut;
        if (datasetOptions == null || datasetOptions.particleColor == null) {
            double[] dArray5 = new double[4];
            dArray5[0] = 1.0;
            dArray5[1] = 1.0;
            dArray5[2] = 1.0;
            dArray3 = dArray5;
            dArray5[3] = 1.0;
        } else {
            dArray3 = datasetOptions.particleColor;
        }
        double[] particleColor = dArray3;
        double d = colorNoise = datasetOptions == null ? 0.0 : datasetOptions.particleColorNoise;
        if (datasetOptions == null || datasetOptions.labelColor == null) {
            double[] dArray6 = new double[4];
            dArray6[0] = 1.0;
            dArray6[1] = 1.0;
            dArray6[2] = 1.0;
            dArray2 = dArray6;
            dArray6[3] = 1.0;
        } else {
            dArray2 = datasetOptions.labelColor;
        }
        double[] labelColor = dArray2;
        double d2 = particleSize = datasetOptions == null ? 0.0 : datasetOptions.particleSize;
        if (datasetOptions == null || datasetOptions.particleSizeLimits == null) {
            double[] dArray7 = new double[2];
            dArray7[0] = 0.00474;
            dArray = dArray7;
            dArray7[1] = 0.2047;
        } else {
            dArray = datasetOptions.particleSizeLimits;
        }
        double[] particleSizeLimits = dArray;
        double profileDecay = datasetOptions == null ? 1.0 : datasetOptions.profileDecay;
        String modelType = datasetOptions == null ? "quad" : datasetOptions.modelType;
        String modelPrimitive = datasetOptions == null ? "GL_TRIANGLES" : datasetOptions.modelPrimitive;
        String ct = datasetOptions == null || datasetOptions.ct == null ? ComponentTypes.ComponentType.Galaxies.toString() : datasetOptions.ct.toString();
        boolean renderSetLabel = datasetOptions == null || datasetOptions.renderSetLabel;
        int numLabels = datasetOptions == null ? -1 : datasetOptions.numLabels;
        Archetype archetype = scene.archetypes().get("ParticleGroup");
        Entity entity = archetype.createEntity();
        Base base = (Base)Mapper.base.get(entity);
        base.id = ParticleSet.getNextSequence();
        base.setName(name.replace("%%PGID%%", Long.toString(base.id)));
        base.setCt(ct);
        Highlight hl = (Highlight)Mapper.highlight.get(entity);
        hl.pointscaling = (float)particleSize;
        Body body = (Body)Mapper.body.get(entity);
        body.setColor(particleColor);
        body.setLabelColor(labelColor);
        body.setSize(particleSize);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        graph.setParent("Universe");
        Fade fade = (Fade)Mapper.fade.get(entity);
        fade.setFadeIn(fadeIn);
        fade.setFadeOut(fadeOut);
        ParticleSet set = (ParticleSet)Mapper.particleSet.get(entity);
        set.setExtended(datasetOptions != null && datasetOptions.type == DatasetOptions.DatasetLoadType.PARTICLES_EXT);
        set.setData(data);
        set.setDatafile(file);
        set.setColumnInfoList(columnInfoList);
        set.setProfileDecay(profileDecay);
        set.setColorNoise(colorNoise);
        set.setParticleSizeLimits(particleSizeLimits);
        set.setModelType(modelType);
        set.setModelPrimitive(modelPrimitive);
        set.setRenderSetLabel(renderSetLabel);
        set.setNumLabels(Long.valueOf(numLabels));
        scene.initializeEntity(entity);
        if (addToCatalogManager) {
            scene.setUpEntity(entity);
        }
        return entity;
    }

    public static void dispose(Entity entity, StarSet set) {
        set.disposed = true;
        if (GaiaSky.instance.scene != null) {
            GaiaSky.instance.scene.remove(entity, true);
        }
        EventManager.instance.removeRadioSubscriptions(entity);
        set.pointData = null;
        CameraManager cam = GaiaSky.instance.getCameraManager();
        if (cam != null && cam.hasFocus() && cam.isFocus(entity)) {
            set.setFocusIndex(-1);
            EventManager.publish(Event.CAMERA_MODE_CMD, set, new Object[]{CameraManager.CameraMode.FREE_MODE});
        }
    }
}

