/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.entity;

import com.badlogic.ashley.core.Entity;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.component.MotorEngine;
import gaiasky.scene.entity.EntityRadio;
import gaiasky.scene.record.MachineDefinition;
import gaiasky.scene.view.SpacecraftView;
import gaiasky.util.math.MathUtilsDouble;

public class SpacecraftRadio
extends EntityRadio {
    private final SpacecraftView view = new SpacecraftView();

    public SpacecraftRadio(Entity entity) {
        super(entity);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        this.view.setEntity(this.entity);
        switch (event) {
            case CAMERA_MODE_CMD: {
                CameraManager.CameraMode mode = (CameraManager.CameraMode)((Object)data[0]);
                this.view.engine.render = mode == CameraManager.CameraMode.SPACECRAFT_MODE;
                break;
            }
            case SPACECRAFT_STABILISE_CMD: {
                this.view.engine.leveling = (Boolean)data[0];
                break;
            }
            case SPACECRAFT_STOP_CMD: {
                this.view.engine.stopping = (Boolean)data[0];
                break;
            }
            case SPACECRAFT_THRUST_DECREASE_CMD: {
                this.view.decreaseThrustFactorIndex(true);
                break;
            }
            case SPACECRAFT_THRUST_INCREASE_CMD: {
                this.view.increaseThrustFactorIndex(true);
                break;
            }
            case SPACECRAFT_THRUST_SET_CMD: {
                this.view.setThrustFactorIndex((Integer)data[0], false);
                break;
            }
            case SPACECRAFT_MACHINE_SELECTION_CMD: {
                int newMachineIndex = (Integer)data[0];
                GaiaSky.postRunnable(() -> {
                    this.setToMachine((Body)this.entity.getComponent(Body.class), (Model)this.entity.getComponent(Model.class), (ModelScaffolding)this.entity.getComponent(ModelScaffolding.class), this.view.engine, this.view.engine.machines[newMachineIndex], true);
                    this.view.engine.currentMachine = newMachineIndex;
                    EventManager.publish(Event.SPACECRAFT_MACHINE_SELECTION_INFO, this, this.view.engine.machines[newMachineIndex]);
                });
                break;
            }
        }
    }

    private void setToMachine(Body body, Model model, ModelScaffolding scaffolding, MotorEngine engine, MachineDefinition machine, boolean initialize) {
        model.model = machine.getModel();
        engine.thrustMagnitude = machine.getPower() * 1.0E12;
        engine.fullPowerTime = machine.getFullpowertime();
        engine.mass = machine.getMass();
        scaffolding.selfShadow = machine.isSelfShadow();
        engine.drag = machine.getDrag();
        engine.responsiveness = MathUtilsDouble.lint(machine.getResponsiveness(), 0.0, 1.0, 500000.0, 5000000.0);
        engine.machineName = machine.getName();
        body.setSizeKm(machine.getSize());
        if (initialize && !model.model.isModelLoading() && !model.model.isModelInitialised()) {
            model.model.initialize(null);
        }
    }
}

