/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.entity;

import com.badlogic.ashley.core.Entity;
import gaiasky.GaiaSky;
import gaiasky.data.OrbitRefresher;
import gaiasky.data.orbit.OrbitBodyDataProvider;
import gaiasky.data.orbit.OrbitFileDataProvider;
import gaiasky.data.util.PointCloudData;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Coordinates;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.util.math.IntersectorDouble;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;
import java.util.Date;

public class TrajectoryUtils {
    public static OrbitRefresher orbitRefresher;
    private final Vector3Q B31 = new Vector3Q();
    private final Vector3Q B32 = new Vector3Q();
    private final Vector3D D31 = new Vector3D();
    private final Vector3D D32 = new Vector3D();
    private final Vector3D D33 = new Vector3D();

    public static void initRefresher(TrajectoryUtils utils) {
        if (orbitRefresher == null) {
            orbitRefresher = new OrbitRefresher("gaiasky-worker-trajectoryupdate", utils);
        }
    }

    public void initOrbitMetadata(Body body, Trajectory trajectory, Verts verts) {
        PointCloudData pointCloudData = verts.pointCloudData;
        if (pointCloudData != null && pointCloudData.hasTime()) {
            trajectory.orbitStartMs = pointCloudData.getDate(0).toEpochMilli();
            trajectory.orbitEndMs = pointCloudData.getDate(pointCloudData.getNumPoints() - 1).toEpochMilli();
        }
        this.updateSize(body, trajectory, verts);
        trajectory.mustRefresh = trajectory.providerClass != null && (trajectory.providerClass.equals(OrbitBodyDataProvider.class) || trajectory.providerClass.equals(OrbitFileDataProvider.class)) && trajectory.body != null && Mapper.atmosphere.has(trajectory.body) && trajectory.oc.period > 0.0;
    }

    public void updateSize(Body body, Trajectory trajectory, Verts verts) {
        PointCloudData pointCloudData = verts.pointCloudData;
        if (pointCloudData != null && !trajectory.isOnlyBody() && pointCloudData.getNumPoints() > 0) {
            pointCloudData.loadPoint(this.D31, 0);
            int n = pointCloudData.getNumPoints();
            double len = 0.0;
            for (int i = 1; i < n; ++i) {
                pointCloudData.loadPoint(this.D32, i);
                double newLen = this.D32.sub(this.D31).len();
                if (!(newLen > len)) continue;
                len = newLen;
            }
            body.size = (float)(len * 2.5);
        }
    }

    public void initializeTransformMatrix(Trajectory trajectory, GraphNode graph, RefSysTransform transform) {
        if (trajectory.model == Trajectory.OrbitOrientationModel.EXTRASOLAR_SYSTEM && transform.matrix == null && graph.parent != null) {
            this.computeExtrasolarSystemTransformMatrix(graph, transform);
        }
    }

    public void computeExtrasolarSystemTransformMatrix(GraphNode graph, RefSysTransform transform) {
        Entity parent = graph.parent;
        if (parent == null) {
            return;
        }
        Coordinates coord = (Coordinates)Mapper.coordinates.get(parent);
        Vector3Q barycenter = this.B31;
        if (coord != null && coord.coordinates != null) {
            coord.coordinates.getEquatorialCartesianCoordinates(GaiaSky.instance.time.getTime(), barycenter);
        } else {
            EntityUtils.getAbsolutePosition(parent, barycenter);
        }
        Vector3Q y = this.B32.set(barycenter).nor();
        Vector3D yd = y.put(this.D31);
        Vector3D zd = this.D32;
        IntersectorDouble.lineIntersection(barycenter.put(new Vector3D()), new Vector3D(yd), new Vector3D(0.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0), zd);
        zd.sub(barycenter).nor();
        Vector3D xd = this.D33.set(yd).crs(zd);
        transform.matrix = Matrix4D.changeOfBasis(zd, yd, xd);
    }

    public void refreshOrbit(Trajectory trajectory, Verts verts, boolean force) {
        if (force && trajectory.params != null || trajectory.mustRefresh && !EntityUtils.isCoordinatesTimeOverflow(trajectory.body)) {
            Instant currentTime = GaiaSky.instance.time.getTime();
            long currentMs = currentTime.toEpochMilli();
            if (force || verts.pointCloudData == null || currentMs < trajectory.orbitStartMs || currentMs > trajectory.orbitEndMs) {
                Date iniTime = GaiaSky.instance.time.getWarpFactor() < 0.0 ? Date.from(Instant.from(currentTime).minusMillis((long)(trajectory.oc.period * 8.0E7))) : Date.from(currentTime);
                trajectory.params.setIni(iniTime);
                trajectory.params.setForce(force);
                if (!trajectory.refreshing) {
                    orbitRefresher.queue(trajectory.params);
                }
            }
        }
    }
}

