/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IUpdatable;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.record.NamedComponent;
import gaiasky.scene.record.RotationComponent;
import gaiasky.util.Bits;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.ModelCache;
import gaiasky.util.Pair;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.AtmosphereAttribute;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.Vector3Attribute;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.jafama.FastMath;

public final class AtmosphereComponent
extends NamedComponent
implements IUpdatable<AtmosphereComponent> {
    public int quality;
    public float size;
    public float planetSize;
    public ModelComponent mc;
    public Matrix4 localTransform = new Matrix4();
    public double[] wavelengths;
    public float m_fInnerRadius;
    public float m_fOuterRadius;
    public float m_fAtmosphereHeight;
    public float m_Kr;
    public float m_Km;
    public float fogDensity = 0.3f;
    public Vector3 fogColor;
    public float m_eSun = 10.0f;
    public int samples = 11;
    public Map<String, Object> params;
    Vector3 aux;
    Vector3D aux3;
    Vector3D aux1;

    public AtmosphereComponent() {
        this.mc = new ModelComponent(false);
        this.mc.initialize(null);
        this.aux = new Vector3();
        this.aux3 = new Vector3D();
        this.aux1 = new Vector3D();
        this.fogColor = new Vector3();
    }

    public void doneLoading(Material planetMat, float planetSize) {
        this.planetSize = planetSize;
        this.setUpAtmosphericScatteringMaterial(planetMat);
        if (this.mc.instance == null) {
            Pair<IntModel, Map<String, Material>> pair = ModelCache.cache.getModel("sphere", this.params, Bits.indices(1, 8), 4);
            IntModel atmosphereModel = pair.getFirst();
            Material atmMat = pair.getSecond().get("base");
            this.setUpAtmosphericScatteringMaterial(atmMat);
            atmMat.set((Attribute)new BlendingAttribute(770, 771));
            this.mc.instance = new IntModelInstance(atmosphereModel, this.localTransform);
        } else {
            Material atmMat = (Material)this.mc.instance.materials.get(0);
            this.setUpAtmosphericScatteringMaterial(atmMat);
        }
    }

    public void update(Vector3Q transform) {
        transform.setToTranslation(this.localTransform).scl(this.size);
    }

    public void setUpAtmosphericScatteringMaterial(Material mat) {
        float camHeight = 1.0f;
        float m_Kr4PI = this.m_Kr * 4.0f * (float)Math.PI;
        float m_Km4PI = this.m_Km * 4.0f * (float)Math.PI;
        float m_ESun = this.m_eSun;
        float m_g = 0.97f;
        this.m_fInnerRadius = this.planetSize / 2.0f;
        this.m_fOuterRadius = this.size;
        this.m_fAtmosphereHeight = this.m_fOuterRadius - this.m_fInnerRadius;
        float m_fScaleDepth = 0.2f;
        float m_fScale = 1.0f / this.m_fAtmosphereHeight;
        float m_fScaleOverScaleDepth = m_fScale / m_fScaleDepth;
        double[] m_fWavelength = this.wavelengths;
        float[] m_fWavelength4 = new float[]{(float)FastMath.pow((double)m_fWavelength[0], (double)4.0), (float)FastMath.pow((double)m_fWavelength[1], (double)4.0), (float)FastMath.pow((double)m_fWavelength[2], (double)4.0)};
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.Alpha, 1.0f));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.ColorOpacity, 1.0f));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.CameraHeight, camHeight));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.OuterRadius, this.m_fOuterRadius));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.InnerRadius, this.m_fInnerRadius));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.KrESun, this.m_Kr * m_ESun));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.KmESun, this.m_Km * m_ESun));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.Kr4PI, m_Kr4PI));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.Km4PI, m_Km4PI));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.Scale, m_fScale));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.ScaleDepth, m_fScaleDepth));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.ScaleOverScaleDepth, m_fScaleOverScaleDepth));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.nSamples, this.samples));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.FogDensity, this.fogDensity));
        mat.set((Attribute)new Vector3Attribute(Vector3Attribute.FogColor, this.fogColor));
        mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.G, m_g));
        mat.set((Attribute)new Vector3Attribute(Vector3Attribute.PlanetPos, new Vector3()));
        mat.set((Attribute)new Vector3Attribute(Vector3Attribute.CameraPos, new Vector3()));
        mat.set((Attribute)new Vector3Attribute(Vector3Attribute.LightPos, new Vector3()));
        mat.set((Attribute)new Vector3Attribute(Vector3Attribute.InvWavelength, new Vector3(1.0f / m_fWavelength4[0], 1.0f / m_fWavelength4[1], 1.0f / m_fWavelength4[2])));
    }

    public void removeAtmosphericScattering(Material mat) {
        mat.remove(AtmosphereAttribute.CameraHeight);
    }

    public void updateAtmosphericScatteringParams(Material mat, float alpha, boolean ground, GraphNode graph, RotationComponent rigidRotation, ModelScaffolding scaffolding, Vector3D vrOffset) {
        Vector3Q parentTranslation = null;
        Entity parent = graph.parent;
        if (parent != null) {
            parentTranslation = ((GraphNode)Mapper.graph.get((Entity)parent)).translation;
        }
        this.updateAtmosphericScatteringParams(mat, alpha, ground, graph.translation, rigidRotation, scaffolding.inverseRefPlaneTransform, parentTranslation, vrOffset);
    }

    public void updateAtmosphericScatteringParams(Material mat, float alpha, boolean ground, Vector3Q translation, RotationComponent rc, String inverseRefPlaneTransform, Vector3Q parentTranslation, Vector3D vrOffset) {
        translation.put(this.aux3);
        if (vrOffset != null) {
            this.aux1.set(vrOffset).scl(1.0 / Constants.M_TO_U);
            this.aux3.sub(this.aux1);
        }
        float camHeight = (float)this.aux3.len();
        float m_ESun = this.m_eSun;
        float camHeightGr = camHeight - this.m_fInnerRadius;
        float atmFactor = (this.m_fAtmosphereHeight - camHeightGr) / this.m_fAtmosphereHeight;
        if (!ground && camHeightGr < this.m_fAtmosphereHeight) {
            m_ESun += atmFactor * 100.0f;
        }
        if (mat.has(AtmosphereAttribute.KrESun)) {
            ((AtmosphereAttribute)Objects.requireNonNull(mat.get((int)AtmosphereAttribute.KrESun))).value = this.m_Kr * m_ESun;
        } else {
            mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.KrESun, this.m_Kr * m_ESun));
        }
        if (mat.has(AtmosphereAttribute.KmESun)) {
            ((AtmosphereAttribute)Objects.requireNonNull(mat.get((int)AtmosphereAttribute.KmESun))).value = this.m_Km * m_ESun;
        } else {
            mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.KmESun, this.m_Km * m_ESun));
        }
        if (mat.has(AtmosphereAttribute.CameraHeight)) {
            ((AtmosphereAttribute)Objects.requireNonNull(mat.get((int)AtmosphereAttribute.CameraHeight))).value = camHeight;
        } else {
            mat.set((Attribute)new AtmosphereAttribute(AtmosphereAttribute.CameraHeight, camHeight));
        }
        if (ground && rc != null) {
            this.aux3.rotate(-rc.ascendingNode, 0.0, 1.0, 0.0).mul(Coordinates.getTransformD(inverseRefPlaneTransform)).rotate(-rc.inclination - rc.axialTilt, 0.0, 0.0, 1.0).rotate(-rc.angle, 0.0, 1.0, 0.0);
        }
        ((Vector3Attribute)Objects.requireNonNull(mat.get((int)Vector3Attribute.PlanetPos))).value.set(this.aux3.put(this.aux));
        this.aux3.scl(-1.0);
        ((Vector3Attribute)Objects.requireNonNull(mat.get((int)Vector3Attribute.CameraPos))).value.set(this.aux3.put(this.aux));
        if (parentTranslation != null) {
            this.aux3.add(parentTranslation);
        }
        this.aux3.nor();
        if (ground && rc != null) {
            this.aux3.rotate(-rc.ascendingNode, 0.0, 1.0, 0.0).mul(Coordinates.getTransformD(inverseRefPlaneTransform)).rotate(-rc.inclination - rc.axialTilt, 0.0, 0.0, 1.0).rotate(-rc.angle, 0.0, 1.0, 0.0);
        }
        ((Vector3Attribute)Objects.requireNonNull(mat.get((int)Vector3Attribute.LightPos))).value.set(this.aux3.put(this.aux));
        ((AtmosphereAttribute)Objects.requireNonNull(mat.get((int)AtmosphereAttribute.Alpha))).value = alpha;
        ((AtmosphereAttribute)Objects.requireNonNull(mat.get((int)AtmosphereAttribute.nSamples))).value = this.samples;
    }

    public void setQuality(Long quality) {
        this.quality = quality.intValue();
    }

    public void setSize(Double size) {
        this.size = (float)(size * Constants.KM_TO_U);
    }

    public void setMc(ModelComponent mc) {
        this.mc = mc;
    }

    public void setLocalTransform(Matrix4 localTransform) {
        this.localTransform = localTransform;
    }

    public void setFogColor(double[] fogColor) {
        this.fogColor.set((float)fogColor[0], (float)fogColor[1], (float)fogColor[2]);
    }

    public void setFogcolor(double[] fogColor) {
        this.setFogColor(fogColor);
    }

    public void setSamples(Long samples) {
        this.samples = samples.intValue();
    }

    public void setNumSamples(Long samples) {
        this.samples = samples.intValue();
    }

    public void setFogDensity(Double fogDensity) {
        this.fogDensity = MathUtils.clamp((float)fogDensity.floatValue(), (float)0.01f, (float)3.5f);
    }

    public void setFogdensity(Double fogDensity) {
        this.setFogDensity(fogDensity);
    }

    public void setM_Kr(Double m_Kr) {
        this.m_Kr = m_Kr.floatValue();
    }

    public void setM_Km(Double m_Km) {
        this.m_Km = m_Km.floatValue();
    }

    public void setM_eSun(Double m_eSun) {
        this.m_eSun = m_eSun.floatValue();
    }

    public double[] getWavelengths() {
        return this.wavelengths;
    }

    public void setWavelengths(double[] wavelengths) {
        this.wavelengths = wavelengths;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void randomizeAll(long seed, double bodyRadius) {
        Random rand = new Random(seed);
        double bodyRadiusKm = bodyRadius * Constants.U_TO_KM;
        this.setSize(bodyRadiusKm + bodyRadiusKm * 0.029);
        this.setWavelengths(new double[]{this.gaussian(rand, 0.6, 0.1), this.gaussian(rand, 0.54, 0.1), this.gaussian(rand, 0.45, 0.1)});
        this.setM_Kr(rand.nextDouble(0.002f, 0.0069f));
        this.setM_Km(rand.nextDouble(0.001f, 0.0079f));
        this.setM_eSun(this.gaussian(rand, 7.0, 4.0, 3.0));
        this.setFogdensity(this.gaussian(rand, 0.6, 0.3, 0.01));
        this.setFogcolor(new double[]{0.5 + rand.nextDouble() * 0.5, 0.5 + rand.nextDouble() * 0.5, 0.5 + rand.nextDouble() * 0.5});
        this.setSamples(Long.valueOf(rand.nextInt(10, 20)));
        this.setParams(this.createModelParameters(600L, 2.0, true));
    }

    public void copyFrom(AtmosphereComponent other) {
        this.params = other.params;
        this.size = other.size;
        this.wavelengths = Arrays.copyOf(other.wavelengths, other.wavelengths.length);
        this.m_Km = other.m_Km;
        this.m_Kr = other.m_Kr;
        this.m_eSun = other.m_eSun;
        this.fogDensity = other.fogDensity;
        this.fogColor = new Vector3(other.fogColor);
        this.samples = other.samples;
    }

    public void print(Logger.Log log) {
        log.debug("Size: " + this.size);
        log.debug("Wavelengths: " + Arrays.toString(this.wavelengths));
        log.debug("eSun: " + this.m_eSun);
        log.debug("Fog density: " + this.fogDensity);
        log.debug("Fog color: " + String.valueOf(this.fogColor));
        log.debug("Samples: " + this.samples);
    }

    public void dispose() {
    }

    @Override
    public void updateWith(AtmosphereComponent object) {
        this.copyFrom(object);
    }
}

