/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import net.jafama.FastMath;

public class BilinearInterpolator {
    public static double interpolate(double u, double v, GridModel model, boolean wrapX, boolean wrapY) {
        int W = model.getWidth();
        int H = model.getHeight();
        v = 1.0 - v;
        double dx = 1.0 / (double)W;
        double dy = 1.0 / (double)H;
        double dx2 = dx / 2.0;
        double dy2 = dy / 2.0;
        v -= dy2;
        int i1 = (int)FastMath.floor((double)((double)W * (u -= dx2)));
        if (i1 < 0) {
            i1 = wrapX ? W - 1 : 0;
        }
        int i2 = (i1 + 1) % W;
        int j1 = (int)FastMath.floor((double)((double)H * v));
        if (j1 < 0) {
            j1 = wrapY ? H - 1 : 0;
        }
        int j2 = (j1 + 1) % H;
        double x = u < 0.0 && wrapX ? 1.0 + u + dx2 : u + dx2;
        double y = v + dx2;
        double x1 = (double)i1 / (double)W + dx2;
        double x2 = x1 + dx;
        double y1 = (double)j1 / (double)H + dy2;
        double y2 = y1 + dy;
        double q11 = model.getValue(i1, j1);
        double q21 = model.getValue(i2, j1);
        double q12 = model.getValue(i1, j2);
        double q22 = model.getValue(i2, j2);
        double r1 = (x2 - x) / (x2 - x1) * q11 + (x - x1) / (x2 - x1) * q21;
        double r2 = (x2 - x) / (x2 - x1) * q12 + (x - x1) / (x2 - x1) * q22;
        return (y2 - y) / (y2 - y1) * r1 + (y - y1) / (y2 - y1) * r2;
    }

    public static interface GridModel {
        public int getWidth();

        public int getHeight();

        public double getValue(int var1, int var2);
    }
}

