/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import gaiasky.data.group.PointDataProvider;
import gaiasky.render.BlendMode;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import java.util.List;
import java.util.Locale;
import net.jafama.FastMath;

public class BillboardDataset {
    private static final Logger.Log logger = Logger.getLogger(BillboardDataset.class);
    public String file;
    public String fileUnpack;
    public List<IParticleRecord> data;
    public ParticleType type;
    public int[] layers;
    public float[] completion;
    public float size = 1.0f;
    public float intensity = 1.0f;
    public boolean depthMask = false;
    public BlendMode blending = BlendMode.ADDITIVE;
    public double[] maxSizes;

    public boolean initialize(PointDataProvider provider, boolean reload) {
        if (this.file != null && !this.file.isBlank()) {
            Pair<List<IParticleRecord>, String> p = this.reloadFile(provider, this.file, this.fileUnpack, this.data);
            reload = reload || !p.getSecond().equals(this.fileUnpack);
            this.data = p.getFirst();
            this.fileUnpack = p.getSecond();
            return reload;
        }
        return false;
    }

    private Pair<List<IParticleRecord>, String> reloadFile(PointDataProvider prov, String src, String srcUpk, List<IParticleRecord> curr) {
        String upk = GlobalResources.unpackAssetPath(Settings.settings.data.dataFile(src));
        if (srcUpk == null || !srcUpk.equals(upk)) {
            return new Pair<List<IParticleRecord>, String>(prov.loadData(upk), upk);
        }
        return new Pair<List<IParticleRecord>, String>(curr, srcUpk);
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setSize(Double size) {
        this.size = size.floatValue();
    }

    public void setIntensity(Double intensity) {
        this.intensity = intensity.floatValue();
    }

    public void setType(String type) {
        if (type != null && !type.isBlank()) {
            this.type = ParticleType.valueOf(type.toUpperCase(Locale.ROOT));
        }
    }

    public void setLayers(int[] layers) {
        this.layers = new int[layers.length];
        System.arraycopy(layers, 0, this.layers, 0, layers.length);
    }

    public void setCompletion(Double completion) {
        float c = completion.floatValue();
        this.completion = new float[]{c, c, c, c};
    }

    public void setCompletion(double[] completion) {
        int len = Settings.GraphicsQuality.values().length;
        if (completion.length == len) {
            this.completion = new float[]{(float)completion[0], (float)completion[1], (float)completion[2], (float)completion[3]};
        } else {
            logger.warn("The length of the completion array must be " + len + ", got " + completion.length);
        }
    }

    public void setDepthMask(Boolean depthMask) {
        this.depthMask = depthMask;
    }

    public void setDepthmask(Boolean depthMask) {
        this.setDepthMask(depthMask);
    }

    public void setBlending(String blending) {
        this.blending = BlendMode.valueOf(blending.toUpperCase(Locale.ROOT));
    }

    public void setMaxSize(Double maxSize) {
        this.maxSizes = new double[Settings.GraphicsQuality.values().length];
        double val = FastMath.tan((double)Math.toRadians(maxSize));
        for (int i = 0; i < Settings.GraphicsQuality.values().length; ++i) {
            this.maxSizes[i] = val;
        }
    }

    @Deprecated
    public void setMaxsize(Double maxSize) {
        this.setMaxSize(maxSize);
    }

    public void setMaxSizes(double[] maxSizes) {
        int len = Settings.GraphicsQuality.values().length;
        if (maxSizes.length == len) {
            this.maxSizes = new double[Settings.GraphicsQuality.values().length];
            for (int i = 0; i < Settings.GraphicsQuality.values().length; ++i) {
                this.maxSizes[i] = FastMath.tan((double)Math.toRadians(maxSizes[i]));
            }
        } else {
            logger.warn("The length of the completion array must be " + len + ", got " + maxSizes.length);
        }
    }

    @Deprecated
    public void setMaxsizes(double[] maxSizes) {
        this.setMaxSizes(maxSizes);
    }

    public static enum ParticleType {
        DUST,
        BULGE,
        STAR,
        GAS,
        HII,
        GALAXY,
        POINT,
        OTHER;

    }
}

