/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.data.AssetBean;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.BlendMode;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.api.IUpdatable;
import gaiasky.scene.component.Model;
import gaiasky.scene.record.ComponentUtils;
import gaiasky.scene.record.CubemapComponent;
import gaiasky.scene.record.IMaterialProvider;
import gaiasky.scene.record.MaterialComponent;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.record.NamedComponent;
import gaiasky.scene.record.NoiseComponent;
import gaiasky.scene.record.VirtualTextureComponent;
import gaiasky.util.Bits;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.ModelCache;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.gdx.loader.OwnTextureLoader;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.AtmosphereAttribute;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.CubemapAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.IntAttribute;
import gaiasky.util.gdx.shader.attribute.OcclusionCloudsAttribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import gaiasky.util.gdx.shader.attribute.Vector2Attribute;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.svt.SVTManager;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jafama.FastMath;

public final class CloudComponent
extends NamedComponent
implements IMaterialProvider,
IUpdatable<CloudComponent> {
    private static final OwnTextureLoader.OwnTextureParameter textureParams;
    private static final Logger.Log logger;
    public int quality;
    public float size;
    public NoiseComponent nc;
    public ModelComponent mc;
    public Matrix4 localTransform;
    public float[] color = new float[]{1.0f, 1.0f, 1.0f, 0.7f};
    public String diffuse;
    public String diffuseUnpacked;
    public MaterialComponent materialComponent;
    public CubemapComponent diffuseCubemap;
    public VirtualTextureComponent diffuseSvt;
    public Map<Object, Object> svtParams;
    public Map<String, Object> params;
    Vector3 aux;
    Vector3D aux3;
    private AssetManager manager;
    private final AtomicBoolean generated = new AtomicBoolean(false);
    private Texture cloudTex;
    private Material material;
    private boolean texInitialised;
    private boolean texLoading;

    public CloudComponent() {
        this.localTransform = new Matrix4();
        this.mc = new ModelComponent(false);
        this.mc.setBlendMode(BlendMode.COLOR);
        this.mc.initialize(null);
        this.aux = new Vector3();
        this.aux3 = new Vector3D();
    }

    public void initialize(String name, boolean force) {
        super.initialize(name);
        this.initialize(force);
    }

    private void initialize(boolean force) {
        if (!Settings.settings.scene.initialization.lazyTexture || force) {
            if (this.diffuse != null && !this.diffuse.endsWith("generate")) {
                this.diffuseUnpacked = this.addToLoad(this.diffuse);
                if (this.diffuseUnpacked != null) {
                    logger.info(I18n.msg("notif.loading", this.diffuseUnpacked));
                }
            }
            if (this.diffuseCubemap != null) {
                this.diffuseCubemap.initialize(this.manager);
            }
            if (this.diffuseSvt != null) {
                this.diffuseSvt.initialize("diffuseSvt", this, TextureAttribute.SvtIndirectionDiffuse);
            }
        }
        this.generated.set(false);
    }

    public boolean isFinishedLoading(AssetManager manager) {
        return ComponentUtils.isLoaded(this.diffuseUnpacked, manager) && ComponentUtils.isLoaded(this.diffuseCubemap, manager);
    }

    private String addToLoad(String tex) {
        if (tex == null) {
            return null;
        }
        tex = GlobalResources.unpackAssetPath(tex);
        AssetBean.addAsset(tex, Texture.class, textureParams);
        return tex;
    }

    public void doneLoading(AssetManager manager) {
        this.manager = manager;
        Pair<IntModel, Map<String, Material>> pair = ModelCache.cache.getModel("sphere", this.params, Bits.indices(1, 8, 128, 256, 16), 4);
        IntModel cloudModel = pair.getFirst();
        Material material = pair.getSecond().get("base");
        material.clear();
        this.mc.instance = new IntModelInstance(cloudModel, this.localTransform);
        if (!Settings.settings.scene.initialization.lazyTexture) {
            this.initMaterial(null);
        }
        this.texInitialised = !Settings.settings.scene.initialization.lazyTexture;
        this.texLoading = false;
    }

    public void touch(Model model) {
        if (Settings.settings.scene.initialization.lazyTexture && !this.texInitialised) {
            if (!this.texLoading) {
                this.initialize(true);
                this.texLoading = true;
            } else if (this.isFinishedLoading(this.manager)) {
                GaiaSky.postRunnable(() -> this.initMaterial(model));
                this.texInitialised = true;
                this.texLoading = false;
            }
        }
    }

    public void update(Vector3Q transform) {
        transform.setToTranslation(this.localTransform).scl(this.size);
    }

    public void updateCullFace(double distToCamera) {
        if (this.material != null) {
            ((IntAttribute)Objects.requireNonNull(this.material.get((int)IntAttribute.CullFace))).value = distToCamera > (double)this.size ? 1029 : 0;
        }
    }

    public void initMaterial(Model model) {
        this.material = (Material)this.mc.instance.materials.first();
        if (this.diffuse != null && this.material.get(TextureAttribute.Diffuse) == null) {
            if (!this.diffuse.endsWith("generate")) {
                Texture tex = (Texture)this.manager.get(this.diffuseUnpacked, Texture.class);
                this.material.set((Attribute)new TextureAttribute(TextureAttribute.Diffuse, tex));
            } else {
                this.initializeGenCloudData(model);
            }
        }
        if (this.diffuseCubemap != null) {
            this.diffuseCubemap.prepareCubemap(this.manager);
            this.material.set((Attribute)new CubemapAttribute(CubemapAttribute.DiffuseCubemap, this.diffuseCubemap.cubemap));
        }
        if (this.diffuseSvt != null && this.materialComponent != null && this.materialComponent.svts != null) {
            if (this.materialComponent.diffuseSvt != null) {
                this.addSVTAttributes(this.material, this.diffuseSvt, this.materialComponent.diffuseSvt.id);
                this.materialComponent.svts.add((Object)this.diffuseSvt);
            } else {
                int svtId = SVTManager.nextSvtId();
                this.addSVTAttributes(this.material, this.diffuseSvt, svtId);
                this.materialComponent.svts.add((Object)this.diffuseSvt);
            }
            if (this.diffuseSvt.id > 0) {
                EventManager.publish(Event.SVT_MATERIAL_INFO, this, this.diffuseSvt.id, this);
            }
        }
        this.material.set((Attribute)new BlendingAttribute(1.0f));
        this.material.set((Attribute)new IntAttribute(IntAttribute.CullFace, 1029));
    }

    private void addSVTAttributes(Material material, VirtualTextureComponent svt, int id) {
        svt.doneLoading(null);
        svt.id = id;
        double svtResolution = (double)svt.tileSize * FastMath.pow((double)2.0, (double)svt.tree.depth);
        material.set((Attribute)new Vector2Attribute(Vector2Attribute.SvtResolution, new Vector2((float)(svtResolution * (double)svt.tree.root.length), (float)svtResolution)));
        material.set((Attribute)new FloatAttribute(FloatAttribute.SvtTileSize, svt.tileSize));
        material.set((Attribute)new FloatAttribute(FloatAttribute.SvtDepth, svt.tree.depth));
        material.set((Attribute)new FloatAttribute(FloatAttribute.SvtId, svt.id));
        material.set((Attribute)new FloatAttribute(FloatAttribute.SvtDetectionFactor, (float)Settings.settings.scene.renderer.virtualTextures.detectionBufferFactor));
    }

    public void setGenerated(boolean generated) {
        this.generated.set(generated);
    }

    private synchronized void initializeGenCloudData(Model model) {
        if (!this.generated.get()) {
            this.generated.set(true);
            GaiaSky.postRunnable(() -> {
                int N = Settings.settings.graphics.proceduralGenerationResolution[0];
                int M = Settings.settings.graphics.proceduralGenerationResolution[1];
                long start = TimeUtils.millis();
                logger.info(I18n.msg("gui.procedural.info.generate", I18n.msg("gui.procedural.cloud"), N, M));
                if (this.nc == null) {
                    this.nc = new NoiseComponent();
                    Random noiseRandom = new Random();
                    this.nc.randomizeAll(noiseRandom, true);
                }
                FrameBuffer cloudFb = this.nc.generateNoise(N, M, 1, 1, this.color);
                if (Settings.settings.program.saveProceduralTextures) {
                    SysUtils.saveProceduralGLTexture((Texture)cloudFb.getColorBufferTexture(), this.name + "-cloud", Settings.ImageFormat.JPG);
                }
                if (cloudFb != null) {
                    this.cloudTex = (Texture)cloudFb.getColorBufferTexture();
                    this.material.set((Attribute)new TextureAttribute(TextureAttribute.Diffuse, this.cloudTex));
                    if (model != null && model.model != null && model.model.mtc != null && GaiaSky.instance.sceneRenderer.visible.get(ComponentTypes.ComponentType.Clouds.ordinal())) {
                        model.model.mtc.getMaterial().remove(OcclusionCloudsAttribute.Type);
                        model.model.mtc.getMaterial().remove(TextureAttribute.AO);
                        model.model.mtc.aoTexture = this.cloudTex;
                        model.model.mtc.getMaterial().set((Attribute)new TextureAttribute(TextureAttribute.AO, model.model.mtc.aoTexture));
                        model.model.mtc.getMaterial().set((Attribute)new OcclusionCloudsAttribute(true));
                        model.model.mtc.setOcclusionClouds(true);
                    }
                }
                long elapsed = TimeUtils.millis() - start;
                logger.info(I18n.msg("gui.procedural.info.done", I18n.msg("gui.procedural.cloud"), (double)elapsed / 1000.0));
            });
        }
    }

    public void disposeTexture(AssetManager manager, Material material, String name, String nameUnpacked, int texAttributeIndex, Texture tex) {
        if (name != null && manager != null && manager.isLoaded(nameUnpacked)) {
            this.unload(material, texAttributeIndex);
            manager.unload(nameUnpacked);
        }
        if (tex != null) {
            this.unload(material, texAttributeIndex);
            tex.dispose();
        }
    }

    public void disposeCubemap(AssetManager manager, Material mat, int attributeIndex, CubemapComponent cubemap) {
        if (cubemap != null && cubemap.isLoaded(manager)) {
            this.unload(this.material, attributeIndex);
            manager.unload(cubemap.cmBack);
            manager.unload(cubemap.cmFront);
            manager.unload(cubemap.cmUp);
            manager.unload(cubemap.cmDown);
            manager.unload(cubemap.cmRight);
            manager.unload(cubemap.cmLeft);
            cubemap.dispose();
        }
    }

    public void disposeTextures(AssetManager manager) {
        this.disposeTexture(manager, this.material, this.diffuse, this.diffuseUnpacked, TextureAttribute.Diffuse, this.cloudTex);
        this.disposeCubemap(manager, this.material, CubemapAttribute.DiffuseCubemap, this.diffuseCubemap);
        this.texLoading = false;
        this.texInitialised = false;
    }

    public void disposeNoiseBuffers() {
        if (this.nc != null) {
            this.nc.dispose();
        }
    }

    private void unload(Material mat, int attrIndex) {
        if (mat != null) {
            Attribute attr = mat.get(attrIndex);
            mat.remove(attrIndex);
            if (attr instanceof TextureAttribute) {
                Texture tex = (Texture)((TextureAttribute)attr).textureDescription.texture;
                tex.dispose();
            }
        }
    }

    public void removeAtmosphericScattering(Material mat) {
        mat.remove(AtmosphereAttribute.CameraHeight);
    }

    public void setQuality(Long quality) {
        this.quality = quality.intValue();
    }

    public void setSize(Double size) {
        this.size = (float)(size * Constants.KM_TO_U);
    }

    public void setMc(ModelComponent mc) {
        this.mc = mc;
    }

    public void setLocalTransform(Matrix4 localTransform) {
        this.localTransform = localTransform;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setCloud(String diffuse) {
        this.setDiffuse(diffuse);
    }

    public void setDiffuse(String diffuse) {
        this.diffuse = Settings.settings.data.dataFile(diffuse);
    }

    public void setNoise(NoiseComponent noise) {
        this.nc = noise;
    }

    public void setDiffuseCubemap(String diffuseCubemap) {
        this.diffuseCubemap = new CubemapComponent();
        this.diffuseCubemap.setLocation(diffuseCubemap);
    }

    public void setDiffuseSVT(VirtualTextureComponent virtualTextureComponent) {
        this.diffuseSvt = virtualTextureComponent;
    }

    public void setDiffuseSVT(Map<Object, Object> virtualTexture) {
        this.svtParams = virtualTexture;
        this.setDiffuseSVT(MaterialComponent.convertToComponent(virtualTexture));
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    public boolean hasSVT() {
        return this.diffuseSvt != null;
    }

    public void randomizeAll(long seed, double bodyDiameter) {
        Random rand = new Random(seed);
        double bodyDiameterKm = bodyDiameter * Constants.U_TO_KM;
        this.setSize(bodyDiameterKm + bodyDiameterKm * 0.005);
        this.setDiffuse("generate");
        if (rand.nextDouble() > 0.3) {
            this.color[0] = 1.0f;
            this.color[1] = 1.0f;
            this.color[2] = 1.0f;
            this.color[3] = 0.8f;
        } else {
            this.color[0] = (float)MathUtils.clamp((double)rand.nextGaussian(0.95, 0.1), (double)0.0, (double)1.0);
            this.color[1] = (float)MathUtils.clamp((double)rand.nextGaussian(0.95, 0.1), (double)0.0, (double)1.0);
            this.color[2] = (float)MathUtils.clamp((double)rand.nextGaussian(0.95, 0.1), (double)0.0, (double)1.0);
            this.color[3] = (float)MathUtils.clamp((double)rand.nextGaussian(0.75, 0.2), (double)0.0, (double)1.0);
        }
        this.setParams(this.createModelParameters(400L, 1.0, false));
        if (this.nc != null) {
            this.nc.dispose();
        }
        NoiseComponent nc = new NoiseComponent();
        nc.randomizeAll(rand, true);
        this.setNoise(nc);
    }

    public void copyFrom(CloudComponent other) {
        this.size = other.size;
        this.diffuse = other.diffuse;
        this.params = other.params;
        this.diffuseCubemap = other.diffuseCubemap;
        this.diffuseSvt = other.diffuseSvt;
        this.svtParams = other.svtParams;
        this.nc = new NoiseComponent();
        if (other.color != null) {
            this.color = Arrays.copyOf(other.color, other.color.length);
        }
        if (other.nc != null) {
            this.nc.copyFrom(other.nc);
        } else {
            this.nc.randomizeAll(new Random());
        }
    }

    public void print(Logger.Log log) {
        log.debug("Size: " + this.size);
        log.debug("---Noise---");
        if (this.nc != null) {
            this.nc.print(log);
        }
    }

    public void dispose() {
        this.disposeTextures(this.manager);
    }

    @Override
    public void updateWith(CloudComponent object) {
        if (object.size > 0.0f) {
            this.size = object.size;
        }
        if (object.diffuse != null) {
            this.diffuse = object.diffuse;
        }
        if (object.diffuseCubemap != null) {
            this.diffuseCubemap = object.diffuseCubemap;
        }
        if (object.diffuseSvt != null) {
            this.diffuseSvt = object.diffuseSvt;
        }
        if (object.svtParams != null) {
            this.svtParams = object.svtParams;
        }
    }

    static {
        logger = Logger.getLogger(CloudComponent.class);
        textureParams = new OwnTextureLoader.OwnTextureParameter();
        CloudComponent.textureParams.genMipMaps = true;
        CloudComponent.textureParams.magFilter = Texture.TextureFilter.Linear;
        CloudComponent.textureParams.minFilter = Texture.TextureFilter.MipMapLinearNearest;
    }
}

