/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.data.AssetBean;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gdx.OwnCubemap;
import gaiasky.util.gdx.loader.OwnTextureLoader;
import gaiasky.util.i18n.I18n;

public class CubemapComponent
implements Disposable {
    private static final Logger.Log logger = Logger.getLogger(CubemapComponent.class);
    public OwnCubemap cubemap;
    public String location;
    protected boolean loaded = false;
    protected boolean prepared = false;
    protected String cmBack;
    protected String cmFront;
    protected String cmUp;
    protected String cmDown;
    protected String cmRight;
    protected String cmLeft;

    public synchronized void initialize() {
        this.initialize(null);
    }

    public synchronized void initialize(AssetManager manager) {
        if (!this.loaded) {
            OwnTextureLoader.OwnTextureParameter textureParams = new OwnTextureLoader.OwnTextureParameter();
            textureParams.genMipMaps = true;
            textureParams.magFilter = Texture.TextureFilter.Linear;
            textureParams.minFilter = Texture.TextureFilter.MipMapLinearLinear;
            this.loaded = true;
            try {
                String cubemapLocation = this.location == null ? Settings.settings.data.reflectionSkyboxLocation : this.location;
                String cubemapLocationUnpacked = Settings.settings.data.dataFile(cubemapLocation);
                cubemapLocationUnpacked = GlobalResources.unpackAssetPath(cubemapLocationUnpacked);
                logger.info(I18n.msg("notif.loading", "cubemap: " + cubemapLocationUnpacked));
                this.cmBack = GlobalResources.resolveCubemapSide(cubemapLocationUnpacked, "bk", "back", "b");
                this.cmFront = GlobalResources.resolveCubemapSide(cubemapLocationUnpacked, "ft", "front", "f");
                this.cmUp = GlobalResources.resolveCubemapSide(cubemapLocationUnpacked, "up", "top", "u", "t");
                this.cmDown = GlobalResources.resolveCubemapSide(cubemapLocationUnpacked, "dn", "bottom", "d");
                this.cmRight = GlobalResources.resolveCubemapSide(cubemapLocationUnpacked, "rt", "right", "r");
                this.cmLeft = GlobalResources.resolveCubemapSide(cubemapLocationUnpacked, "lf", "left", "l");
                this.addToLoad(this.cmBack, textureParams, manager);
                this.addToLoad(this.cmFront, textureParams, manager);
                this.addToLoad(this.cmUp, textureParams, manager);
                this.addToLoad(this.cmDown, textureParams, manager);
                this.addToLoad(this.cmRight, textureParams, manager);
                this.addToLoad(this.cmLeft, textureParams, manager);
            }
            catch (RuntimeException e) {
                logger.error(e, "Error loading skybox: " + Settings.settings.data.reflectionSkyboxLocation);
            }
        }
    }

    public synchronized void prepareCubemap(AssetManager manager) {
        if (this.cubemap == null && !this.prepared) {
            TextureData bk = ((Texture)manager.get(this.cmBack, Texture.class)).getTextureData();
            TextureData ft = ((Texture)manager.get(this.cmFront, Texture.class)).getTextureData();
            TextureData up = ((Texture)manager.get(this.cmUp, Texture.class)).getTextureData();
            TextureData dn = ((Texture)manager.get(this.cmDown, Texture.class)).getTextureData();
            TextureData rt = ((Texture)manager.get(this.cmRight, Texture.class)).getTextureData();
            TextureData lf = ((Texture)manager.get(this.cmLeft, Texture.class)).getTextureData();
            this.cubemap = new OwnCubemap(rt, lf, up, dn, ft, bk, Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear);
            this.prepared = true;
        }
    }

    public boolean isLoaded(AssetManager manager) {
        return manager.isLoaded(this.cmBack) && manager.isLoaded(this.cmFront) && manager.isLoaded(this.cmUp) && manager.isLoaded(this.cmDown) && manager.isLoaded(this.cmLeft) && manager.isLoaded(this.cmRight);
    }

    private String addToLoad(String tex, OwnTextureLoader.OwnTextureParameter texParams, AssetManager manager) {
        if (manager == null) {
            return this.addToLoad(tex, texParams);
        }
        if (tex == null) {
            return null;
        }
        if (!manager.contains(tex = GlobalResources.unpackAssetPath(tex), Texture.class)) {
            logger.debug(I18n.msg("notif.loading", tex));
            manager.load(tex, Texture.class, (AssetLoaderParameters)texParams);
        }
        return tex;
    }

    private String addToLoad(String tex, OwnTextureLoader.OwnTextureParameter texParams) {
        if (tex == null) {
            return null;
        }
        tex = GlobalResources.unpackAssetPath(tex);
        logger.debug(I18n.msg("notif.loading", tex));
        AssetBean.addAsset(tex, Texture.class, texParams);
        return tex;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void dispose() {
        if (this.cubemap != null) {
            this.cubemap.dispose();
            this.cubemap = null;
        }
        this.loaded = false;
    }
}

