/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.FileTextureData;
import com.badlogic.gdx.graphics.glutils.GLOnlyTextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import gaiasky.GaiaSky;
import gaiasky.scene.record.BilinearInterpolator;
import gaiasky.scene.record.IHeightData;
import gaiasky.util.GlobalResources;
import gaiasky.util.SysUtils;

public final class HeightDataPixmap
implements IHeightData {
    private final Pixmap heightPixmap;
    private BilinearInterpolator.GridModel model;

    public HeightDataPixmap(Pixmap heightPixmap, Runnable finished) {
        this.heightPixmap = heightPixmap;
        if (finished != null) {
            GaiaSky.postRunnable(finished);
        }
        this.initModel();
    }

    public HeightDataPixmap(String heightTexturePacked, Runnable finished) {
        this(new Pixmap(new FileHandle(GlobalResources.unpackAssetPath(heightTexturePacked))), finished);
    }

    public HeightDataPixmap(Texture texture, Runnable finished) {
        TextureData textureData;
        if (texture != null && texture.getTextureData() instanceof PixmapTextureData) {
            this.heightPixmap = texture.getTextureData().consumePixmap();
            this.initModel();
        } else if (texture != null && (textureData = texture.getTextureData()) instanceof FileTextureData) {
            FileTextureData fileTextureData = (FileTextureData)textureData;
            this.heightPixmap = new Pixmap(fileTextureData.getFileHandle());
            this.initModel();
        } else if (texture != null && texture.getTextureData() instanceof GLOnlyTextureData) {
            this.heightPixmap = SysUtils.pixmapFromGLTexture(texture);
            this.initModel();
        } else {
            this.heightPixmap = null;
        }
        if (finished != null) {
            GaiaSky.postRunnable(finished);
        }
    }

    private void initModel() {
        this.model = new BilinearInterpolator.GridModel(){
            private final Color color = new Color();

            @Override
            public int getWidth() {
                assert (HeightDataPixmap.this.heightPixmap != null);
                return HeightDataPixmap.this.heightPixmap.getWidth();
            }

            @Override
            public int getHeight() {
                assert (HeightDataPixmap.this.heightPixmap != null);
                return HeightDataPixmap.this.heightPixmap.getHeight();
            }

            @Override
            public double getValue(int x, int y) {
                assert (HeightDataPixmap.this.heightPixmap != null);
                return this.color.set((int)HeightDataPixmap.this.heightPixmap.getPixel((int)x, (int)y)).r;
            }
        };
    }

    @Override
    public double getNormalizedHeight(double u, double v) {
        if (this.heightPixmap == null) {
            return 0.0;
        }
        return BilinearInterpolator.interpolate(u, v, this.model, true, false);
    }
}

