/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import gaiasky.scene.record.BilinearInterpolator;
import gaiasky.scene.record.IHeightData;
import gaiasky.util.svt.SVTQuadtree;
import gaiasky.util.svt.SVTQuadtreeNode;
import java.nio.file.Path;
import net.jafama.FastMath;

public final class HeightDataSVT
implements IHeightData {
    private final SVTQuadtree<Path> svt;
    private final AssetManager manager;
    private final PixmapGridModel model;

    public HeightDataSVT(SVTQuadtree<Path> svt, AssetManager manager) {
        this.svt = svt;
        this.manager = manager;
        this.model = new PixmapGridModel();
    }

    @Override
    public double getNormalizedHeight(double u, double v) {
        if (this.svt != null) {
            v = 1.0 - v;
            for (int level = this.svt.depth; level >= 0; --level) {
                int[] cr = this.svt.getColRow(level, u, v);
                if (!this.svt.contains(level, cr[0], cr[1])) continue;
                SVTQuadtreeNode<Path> tile = this.svt.getTile(level, cr[0], cr[1]);
                if (!this.manager.contains(((Path)tile.object).toString())) continue;
                Pixmap pm = (Pixmap)this.manager.get(((Path)tile.object).toString());
                double[] tileUV = tile.getUV();
                double tilesPerLevel = FastMath.pow((double)2.0, (double)level);
                double tileU = (u - tileUV[0]) * tilesPerLevel * (double)this.svt.root.length;
                double tileV = (v - tileUV[1]) * tilesPerLevel;
                this.model.setPixmap(pm);
                return BilinearInterpolator.interpolate(tileU, tileV, this.model, false, false);
            }
        }
        return 0.0;
    }

    private static class PixmapGridModel
    implements BilinearInterpolator.GridModel {
        private Pixmap pixmap;
        private final Color color = new Color();

        public void setPixmap(Pixmap pixmap) {
            this.pixmap = pixmap;
        }

        @Override
        public int getWidth() {
            return this.pixmap.getWidth();
        }

        @Override
        public int getHeight() {
            return this.pixmap.getHeight();
        }

        @Override
        public double getValue(int x, int y) {
            return this.color.set((int)this.pixmap.getPixel((int)x, (int)y)).r;
        }
    }
}

