/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.data.AssetBean;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.api.IUpdatable;
import gaiasky.scene.record.ComponentUtils;
import gaiasky.scene.record.CubemapComponent;
import gaiasky.scene.record.HeightDataPixmap;
import gaiasky.scene.record.HeightDataSVT;
import gaiasky.scene.record.IHeightData;
import gaiasky.scene.record.IMaterialProvider;
import gaiasky.scene.record.NamedComponent;
import gaiasky.scene.record.NoiseComponent;
import gaiasky.scene.record.VirtualTextureComponent;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.gdx.loader.OwnTextureLoader;
import gaiasky.util.gdx.loader.PFMTextureLoader;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.CubemapAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.IntAttribute;
import gaiasky.util.gdx.shader.attribute.OcclusionCloudsAttribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import gaiasky.util.gdx.shader.attribute.Vector2Attribute;
import gaiasky.util.i18n.I18n;
import gaiasky.util.svt.SVTManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.jafama.FastMath;

public final class MaterialComponent
extends NamedComponent
implements IObserver,
IMaterialProvider,
IUpdatable<MaterialComponent> {
    private static final OwnTextureLoader.OwnTextureParameter textureParamsMipMap;
    private static final OwnTextureLoader.OwnTextureParameter textureParams;
    private static final PFMTextureLoader.PFMTextureParameter pfmTextureParams;
    private static final Array<String> lookUpTables;
    private static final Logger.Log logger;
    private static final float DEFAULT_HEIGHT_SCALE;
    public static CubemapComponent reflectionCubemap;
    public boolean texInitialised;
    public boolean texLoading;
    public String diffuse;
    public String specular;
    public String normal;
    public String emissive;
    public String ring;
    public String height;
    public String ringnormal;
    public String roughness;
    public String metallic;
    public String ao;
    public String occlusionMetallicRoughness;
    public String texture0;
    public String texture1;
    public String diffuseUnpacked;
    public String specularUnpacked;
    public String normalUnpacked;
    public String emissiveUnpacked;
    public String ringUnpacked;
    public String heightUnpacked;
    public String ringnormalUnpacked;
    public String roughnessUnapcked;
    public String metallicUnpacked;
    public String aoUnpacked;
    public String occlusionMetallicRoughnessUnpacked;
    public String texture0Unpacked;
    public String texture1Unpacked;
    public float[] diffuseColor;
    public float[] specularColor;
    public float[] metallicColor;
    public float[] emissiveColor;
    public float[] diffuseScatteringColor;
    public float[] ringDiffuseScatteringColor;
    public float roughnessColor = Float.NaN;
    public Float heightScale = Float.valueOf(DEFAULT_HEIGHT_SCALE);
    public Vector2 heightSize = new Vector2();
    public IHeightData heightData;
    public NoiseComponent nc;
    public VirtualTextureComponent diffuseSvt;
    public VirtualTextureComponent specularSvt;
    public VirtualTextureComponent heightSvt;
    public VirtualTextureComponent normalSvt;
    public VirtualTextureComponent emissiveSvt;
    public VirtualTextureComponent roughnessSvt;
    public VirtualTextureComponent metallicSvt;
    public VirtualTextureComponent aoSvt;
    public Array<VirtualTextureComponent> svts;
    public CubemapComponent diffuseCubemap;
    public CubemapComponent specularCubemap;
    public CubemapComponent normalCubemap;
    public CubemapComponent emissiveCubemap;
    public CubemapComponent heightCubemap;
    public CubemapComponent roughnessCubemap;
    public CubemapComponent metallicCubemap;
    public CubemapComponent aoCubemap;
    public Texture aoTexture;
    public boolean occlusionClouds = false;
    public String biomeLUT = "$data/default-data/tex/lut/biome-lut.jpg";
    public float biomeHueShift = 0.0f;
    public float biomeSaturation = 1.0f;
    public boolean colorIfTexture = false;
    private Material material;
    private Material ringMaterial;
    private final AtomicBoolean heightGenerated = new AtomicBoolean(false);
    private final AtomicBoolean heightInitialized = new AtomicBoolean(false);
    private Texture heightTex;
    private Texture specularTex;
    private Texture diffuseTex;
    private Texture normalTex;
    private Texture emissiveTex;

    private void initializeLookUpTables() {
        if (lookUpTables.isEmpty()) {
            Path dataPath = Settings.settings.data.dataPath("default-data/tex/lut");
            char sep = File.separatorChar;
            try (Stream<Path> paths = Files.list(dataPath);){
                List<Path> l = paths.filter(f -> f.toString().endsWith("-lut.jpg") || f.toString().endsWith("-lut.png")).toList();
                for (Path p : l) {
                    String name = p.toString();
                    lookUpTables.add((Object)("$data/" + name.substring(name.indexOf("default-data" + sep + "tex" + sep + "lut" + sep))));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lookUpTables.isEmpty()) {
                lookUpTables.add((Object)"$data/default-data/tex/lut/biome-lut.jpg");
                lookUpTables.add((Object)"$data/default-data/tex/lut/biome-smooth-lut.png");
                lookUpTables.add((Object)"$data/default-data/tex/lut/biome-snow1-lut.jpg");
                lookUpTables.add((Object)"$data/default-data/tex/lut/biome-snow2-lut.jpg");
            }
        }
    }

    public MaterialComponent() {
        this.svts = new Array();
        EventManager.instance.subscribe((IObserver)this, Event.ELEVATION_TYPE_CMD, Event.ELEVATION_MULTIPLIER_CMD, Event.TESSELLATION_QUALITY_CMD, Event.TOGGLE_VISIBILITY_CMD);
    }

    private static OwnTextureLoader.OwnTextureParameter getTP(String tex) {
        return MaterialComponent.getTP(tex, false);
    }

    private static OwnTextureLoader.OwnTextureParameter getTP(String tex, boolean mipmap) {
        if (tex != null && tex.endsWith(".pfm")) {
            return pfmTextureParams;
        }
        if (mipmap) {
            return textureParamsMipMap;
        }
        return textureParams;
    }

    public void initialize(String name, AssetManager manager) {
        super.initialize(name);
        if (this.diffuse != null && !this.diffuse.endsWith("generate")) {
            this.diffuseUnpacked = this.addToLoad(this.diffuse, MaterialComponent.getTP(this.diffuse, true), manager);
        }
        if (this.normal != null && !this.normal.endsWith("generate")) {
            this.normalUnpacked = this.addToLoad(this.normal, MaterialComponent.getTP(this.normal), manager);
        }
        if (this.specular != null && !this.specular.endsWith("generate")) {
            this.specularUnpacked = this.addToLoad(this.specular, MaterialComponent.getTP(this.specular, true), manager);
        }
        if (this.emissive != null && !this.emissive.endsWith("generate")) {
            this.emissiveUnpacked = this.addToLoad(this.emissive, MaterialComponent.getTP(this.emissive, true), manager);
        }
        if (this.roughness != null && !this.roughness.endsWith("generate")) {
            this.roughnessUnapcked = this.addToLoad(this.roughness, MaterialComponent.getTP(this.roughness, true), manager);
        }
        if (this.metallic != null && !this.metallic.endsWith("generate")) {
            this.metallicUnpacked = this.addToLoad(this.metallic, MaterialComponent.getTP(this.metallic, true), manager);
        }
        if (this.ao != null && !this.ao.endsWith("generate")) {
            this.aoUnpacked = this.addToLoad(this.ao, MaterialComponent.getTP(this.ao, true), manager);
        }
        if (this.occlusionMetallicRoughness != null && !this.occlusionMetallicRoughness.endsWith("generate")) {
            this.occlusionMetallicRoughnessUnpacked = this.addToLoad(this.occlusionMetallicRoughness, MaterialComponent.getTP(this.occlusionMetallicRoughness, true), manager);
        }
        if (this.height != null && !this.height.endsWith("generate")) {
            this.heightUnpacked = this.addToLoad(this.height, MaterialComponent.getTP(this.height, true), manager);
        }
        if (this.ring != null) {
            this.ringUnpacked = this.addToLoad(this.ring, MaterialComponent.getTP(this.ring, true), manager);
        }
        if (this.ringnormal != null) {
            this.ringnormalUnpacked = this.addToLoad(this.ringnormal, MaterialComponent.getTP(this.ringnormal, true), manager);
        }
        if (this.texture0 != null) {
            this.texture0Unpacked = this.addToLoad(this.texture0, MaterialComponent.getTP(this.texture0, true), manager);
        }
        if (this.texture1 != null) {
            this.texture1Unpacked = this.addToLoad(this.texture1, MaterialComponent.getTP(this.texture1, true), manager);
        }
        if (this.diffuseCubemap != null) {
            this.diffuseCubemap.initialize(manager);
        }
        if (this.normalCubemap != null) {
            this.normalCubemap.initialize(manager);
        }
        if (this.specularCubemap != null) {
            this.specularCubemap.initialize(manager);
        }
        if (this.emissiveCubemap != null) {
            this.emissiveCubemap.initialize(manager);
        }
        if (this.heightCubemap != null) {
            this.heightCubemap.initialize(manager);
        }
        if (this.roughnessCubemap != null) {
            this.roughnessCubemap.initialize(manager);
        }
        if (this.metallicCubemap != null) {
            this.metallicCubemap.initialize(manager);
        }
        if (this.aoCubemap != null) {
            this.aoCubemap.initialize(manager);
        }
        if (this.diffuseSvt != null) {
            this.diffuseSvt.initialize("diffuseSvt", this, TextureAttribute.SvtIndirectionDiffuse);
        }
        if (this.heightSvt != null) {
            this.heightSvt.initialize("heightSvt", this, TextureAttribute.SvtIndirectionHeight);
        }
        if (this.specularSvt != null) {
            this.specularSvt.initialize("specularSvt", this, TextureAttribute.SvtIndirectionSpecular);
        }
        if (this.normalSvt != null) {
            this.normalSvt.initialize("normalSvt", this, TextureAttribute.SvtIndirectionNormal);
        }
        if (this.emissiveSvt != null) {
            this.emissiveSvt.initialize("emissiveSvt", this, TextureAttribute.SvtIndirectionEmissive);
        }
        if (this.roughnessSvt != null) {
            this.roughnessSvt.initialize("roughnessSvt", this, TextureAttribute.SvtIndirectionRoughness);
        }
        if (this.metallicSvt != null) {
            this.metallicSvt.initialize("metallicSvt", this, TextureAttribute.SvtIndirectionMetallic);
        }
        if (this.aoSvt != null) {
            this.aoSvt.initialize("aoSvt", this, TextureAttribute.SvtIndirectionAmbientOcclusion);
        }
        this.heightGenerated.set(false);
    }

    @Override
    public void initialize(String name) {
        this.initialize(name, null);
    }

    public boolean isFinishedLoading(AssetManager manager) {
        return ComponentUtils.isLoaded(this.diffuseUnpacked, manager) && ComponentUtils.isLoaded(this.normalUnpacked, manager) && ComponentUtils.isLoaded(this.specularUnpacked, manager) && ComponentUtils.isLoaded(this.emissiveUnpacked, manager) && ComponentUtils.isLoaded(this.ringUnpacked, manager) && ComponentUtils.isLoaded(this.ringnormalUnpacked, manager) && ComponentUtils.isLoaded(this.heightUnpacked, manager) && ComponentUtils.isLoaded(this.roughnessUnapcked, manager) && ComponentUtils.isLoaded(this.metallicUnpacked, manager) && ComponentUtils.isLoaded(this.aoUnpacked, manager) && ComponentUtils.isLoaded(this.diffuseCubemap, manager) && ComponentUtils.isLoaded(this.normalCubemap, manager) && ComponentUtils.isLoaded(this.emissiveCubemap, manager) && ComponentUtils.isLoaded(this.specularCubemap, manager) && ComponentUtils.isLoaded(this.roughnessCubemap, manager) && ComponentUtils.isLoaded(this.metallicCubemap, manager) && ComponentUtils.isLoaded(this.heightCubemap, manager) && ComponentUtils.isLoaded(this.aoCubemap, manager) && ComponentUtils.isLoaded(this.texture0, manager) && ComponentUtils.isLoaded(this.texture1, manager);
    }

    public boolean hasSVT() {
        return this.diffuseSvt != null || this.normalSvt != null || this.emissiveSvt != null || this.specularSvt != null || this.heightSvt != null || this.metallicSvt != null || this.roughnessSvt != null || this.aoSvt != null;
    }

    private String addToLoad(String tex, OwnTextureLoader.OwnTextureParameter texParams, AssetManager manager) {
        if (manager == null) {
            return this.addToLoad(tex, texParams);
        }
        if (tex == null) {
            return null;
        }
        tex = GlobalResources.unpackAssetPath(tex);
        logger.info(I18n.msg("notif.loading", tex));
        manager.load(tex, Texture.class, (AssetLoaderParameters)texParams);
        return tex;
    }

    private String addToLoad(String tex, OwnTextureLoader.OwnTextureParameter texParams) {
        if (tex == null) {
            return null;
        }
        tex = GlobalResources.unpackAssetPath(tex);
        logger.info(I18n.msg("notif.loading", tex));
        AssetBean.addAsset(tex, Texture.class, texParams);
        return tex;
    }

    public void initMaterial(AssetManager manager, IntModelInstance instance, float[] diffuseCol, boolean culling) {
        if (instance != null) {
            this.initMaterial(manager, (Material)instance.materials.get(0), instance.materials.size > 1 ? (Material)instance.materials.get(1) : null, diffuseCol, culling);
        }
    }

    public void initMaterial(AssetManager manager, Material mat, Material ring, float[] diffuseCol, boolean culling) {
        Texture tex;
        reflectionCubemap.initialize();
        this.material = mat;
        if (this.diffuse != null && this.material.get(TextureAttribute.Diffuse) == null && !this.diffuse.endsWith("generate")) {
            tex = (Texture)manager.get(this.diffuseUnpacked, Texture.class);
            this.addDiffuseTex(tex);
        }
        if (diffuseCol != null) {
            this.diffuseColor = new float[4];
            this.diffuseColor[0] = diffuseCol[0];
            this.diffuseColor[1] = diffuseCol[1];
            this.diffuseColor[2] = diffuseCol[2];
            this.diffuseColor[3] = diffuseCol[3];
            if (this.colorIfTexture || this.diffuse == null) {
                this.material.set((Attribute)new ColorAttribute(ColorAttribute.Diffuse, this.diffuseColor[0], this.diffuseColor[1], this.diffuseColor[2], this.diffuseColor[3]));
            }
        }
        if (this.normal != null && this.material.get(TextureAttribute.Normal) == null && !this.normal.endsWith("generate")) {
            tex = (Texture)manager.get(this.normalUnpacked, Texture.class);
            this.addNormalTex(tex);
        }
        if (this.specular != null && this.material.get(TextureAttribute.Specular) == null && !this.specular.endsWith("generate")) {
            tex = (Texture)manager.get(this.specularUnpacked, Texture.class);
            this.addSpecularTex(tex);
        }
        if (this.specularColor != null) {
            this.material.set((Attribute)new ColorAttribute(ColorAttribute.Specular, this.specularColor[0], this.specularColor[1], this.specularColor[2], 1.0f));
        }
        if (this.emissive != null && this.material.get(TextureAttribute.Emissive) == null && !this.emissive.endsWith("generate")) {
            tex = (Texture)manager.get(this.emissiveUnpacked, Texture.class);
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.Emissive, tex));
        }
        if (this.emissiveColor != null) {
            this.material.set((Attribute)new ColorAttribute(ColorAttribute.Emissive, this.emissiveColor[0], this.emissiveColor[1], this.emissiveColor[2], 1.0f));
        }
        if (this.diffuseScatteringColor != null) {
            this.material.set((Attribute)new ColorAttribute(ColorAttribute.DiffuseScattering, this.diffuseScatteringColor[0], this.diffuseScatteringColor[1], this.diffuseScatteringColor[2], 1.0f));
        }
        if (this.height != null && this.material.get(TextureAttribute.Height) == null) {
            if (!this.height.endsWith("generate")) {
                tex = (Texture)manager.get(this.heightUnpacked, Texture.class);
                this.initializeElevationData(tex);
            } else {
                this.initializeGenElevationData();
            }
        }
        if (ring != null) {
            this.ringMaterial = ring;
            if (this.ringMaterial.get(TextureAttribute.Diffuse) == null) {
                this.ringMaterial.set((Attribute)new TextureAttribute(TextureAttribute.Diffuse, (Texture)manager.get(this.ringUnpacked, Texture.class)));
            }
            if (this.ringnormal != null && this.ringMaterial.get(TextureAttribute.Normal) == null) {
                this.ringMaterial.set((Attribute)new TextureAttribute(TextureAttribute.Normal, (Texture)manager.get(this.ringnormalUnpacked, Texture.class)));
            }
            if (this.ringDiffuseScatteringColor != null) {
                this.ringMaterial.set((Attribute)new ColorAttribute(ColorAttribute.DiffuseScattering, this.ringDiffuseScatteringColor[0], this.ringDiffuseScatteringColor[1], this.ringDiffuseScatteringColor[2], 1.0f));
            }
            this.ringMaterial.set((Attribute)new BlendingAttribute(770, 771));
            if (!culling) {
                this.ringMaterial.set((Attribute)new IntAttribute(IntAttribute.CullFace, 0));
            }
        }
        if (!culling) {
            this.material.set((Attribute)new IntAttribute(IntAttribute.CullFace, 0));
        }
        if (this.metallic != null || this.metallicColor != null) {
            reflectionCubemap.prepareCubemap(manager);
            this.material.set((Attribute)new CubemapAttribute(CubemapAttribute.ReflectionCubemap, MaterialComponent.reflectionCubemap.cubemap));
        }
        if (this.metallic != null && !this.metallic.endsWith("generate") && this.material.get(TextureAttribute.Metallic) == null) {
            tex = (Texture)manager.get(this.metallicUnpacked, Texture.class);
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.Metallic, tex));
        }
        if (this.metallicColor != null) {
            this.material.set((Attribute)new ColorAttribute(ColorAttribute.Metallic, this.metallicColor[0], this.metallicColor[1], this.metallicColor[2], 1.0f));
        }
        if (this.roughness != null && this.material.get(TextureAttribute.Roughness) == null && !this.roughness.endsWith("generate")) {
            tex = (Texture)manager.get(this.roughnessUnapcked, Texture.class);
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.Roughness, tex));
        }
        if (Float.isFinite(this.roughnessColor)) {
            this.material.set((Attribute)new FloatAttribute(FloatAttribute.Shininess, 1.0f - this.roughnessColor));
        }
        if (this.ao != null && this.material.get(TextureAttribute.AO) == null && !this.ao.endsWith("generate")) {
            this.aoTexture = (Texture)manager.get(this.aoUnpacked, Texture.class);
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.AO, this.aoTexture));
        }
        if (this.occlusionMetallicRoughness != null && this.material.get(TextureAttribute.AO) == null && !this.occlusionMetallicRoughness.endsWith("generate")) {
            tex = (Texture)manager.get(this.occlusionMetallicRoughnessUnpacked, Texture.class);
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.OcclusionMetallicRoughness, tex));
        }
        if (this.texture0 != null && this.material.get(TextureAttribute.Texture0) == null) {
            tex = (Texture)manager.get(this.texture0Unpacked, Texture.class);
            this.addTexture0(tex);
        }
        if (this.texture1 != null && this.material.get(TextureAttribute.Texture1) == null) {
            tex = (Texture)manager.get(this.texture1Unpacked, Texture.class);
            this.addTexture1(tex);
        }
        if (this.diffuseCubemap != null) {
            this.diffuseCubemap.prepareCubemap(manager);
            this.material.set((Attribute)new CubemapAttribute(CubemapAttribute.DiffuseCubemap, this.diffuseCubemap.cubemap));
        }
        if (this.normalCubemap != null) {
            this.normalCubemap.prepareCubemap(manager);
            this.material.set((Attribute)new CubemapAttribute(CubemapAttribute.NormalCubemap, this.normalCubemap.cubemap));
        }
        if (this.emissiveCubemap != null) {
            this.emissiveCubemap.prepareCubemap(manager);
            this.material.set((Attribute)new CubemapAttribute(CubemapAttribute.EmissiveCubemap, this.emissiveCubemap.cubemap));
        }
        if (this.specularCubemap != null) {
            this.specularCubemap.prepareCubemap(manager);
            this.material.set((Attribute)new CubemapAttribute(CubemapAttribute.SpecularCubemap, this.specularCubemap.cubemap));
        }
        if (this.roughnessCubemap != null) {
            this.roughnessCubemap.prepareCubemap(manager);
            this.material.set((Attribute)new CubemapAttribute(CubemapAttribute.RoughnessCubemap, this.roughnessCubemap.cubemap));
        }
        if (this.metallicCubemap != null) {
            this.metallicCubemap.prepareCubemap(manager);
            this.material.set((Attribute)new CubemapAttribute(CubemapAttribute.MetallicCubemap, this.metallicCubemap.cubemap));
        }
        if (this.heightCubemap != null) {
            this.heightCubemap.prepareCubemap(manager);
            this.material.set((Attribute)new CubemapAttribute(CubemapAttribute.HeightCubemap, this.heightCubemap.cubemap));
        }
        if (this.aoCubemap != null) {
            this.aoCubemap.prepareCubemap(manager);
            if (!this.occlusionClouds || GaiaSky.instance.sceneRenderer.visible.get(ComponentTypes.ComponentType.Clouds.ordinal())) {
                this.material.set((Attribute)new CubemapAttribute(CubemapAttribute.AmbientOcclusionCubemap, this.aoCubemap.cubemap));
            }
        }
        if (this.occlusionClouds && GaiaSky.instance.sceneRenderer.visible.get(ComponentTypes.ComponentType.Clouds.ordinal())) {
            this.material.set((Attribute)new OcclusionCloudsAttribute(true));
        }
        int svtId = 0;
        if (this.diffuseSvt != null || this.normalSvt != null || this.emissiveSvt != null || this.specularSvt != null || this.heightSvt != null || this.metallicSvt != null || this.roughnessSvt != null || this.aoSvt != null) {
            svtId = SVTManager.nextSvtId();
        }
        if (this.diffuseSvt != null) {
            this.addSVTAttributes(this.material, this.diffuseSvt, svtId);
        }
        if (this.normalSvt != null) {
            this.addSVTAttributes(this.material, this.normalSvt, svtId);
        }
        if (this.emissiveSvt != null) {
            this.addSVTAttributes(this.material, this.emissiveSvt, svtId);
        }
        if (this.specularSvt != null) {
            this.addSVTAttributes(this.material, this.specularSvt, svtId);
        }
        if (this.heightSvt != null) {
            this.addSVTAttributes(this.material, this.heightSvt, svtId);
            this.initializeElevationData(this.heightSvt, manager);
        }
        if (this.metallicSvt != null) {
            this.addSVTAttributes(this.material, this.metallicSvt, svtId);
        }
        if (this.roughnessSvt != null) {
            this.addSVTAttributes(this.material, this.roughnessSvt, svtId);
        }
        if (this.aoSvt != null) {
            this.addSVTAttributes(this.material, this.aoSvt, svtId);
        }
        if (svtId > 0) {
            EventManager.publish(Event.SVT_MATERIAL_INFO, this, svtId, this);
        }
    }

    private void addSVTAttributes(Material material, VirtualTextureComponent svt) {
        this.addSVTAttributes(material, svt, svt.id);
    }

    private void addSVTAttributes(Material material, VirtualTextureComponent svt, int id) {
        svt.doneLoading(null);
        svt.id = id;
        material.set((Attribute)new FloatAttribute(FloatAttribute.SvtTileSize, svt.tileSize));
        material.set((Attribute)new FloatAttribute(FloatAttribute.SvtId, svt.id));
        material.set((Attribute)new FloatAttribute(FloatAttribute.SvtDetectionFactor, (float)Settings.settings.scene.renderer.virtualTextures.detectionBufferFactor));
        if (!material.has(FloatAttribute.SvtDepth) || ((FloatAttribute)Objects.requireNonNull(material.get((int)FloatAttribute.SvtDepth))).value < (float)svt.tree.depth) {
            material.set((Attribute)new FloatAttribute(FloatAttribute.SvtDepth, svt.tree.depth));
            double svtResolution = (double)svt.tileSize * FastMath.pow((double)2.0, (double)svt.tree.depth);
            material.set((Attribute)new Vector2Attribute(Vector2Attribute.SvtResolution, new Vector2((float)(svtResolution * (double)svt.tree.root.length), (float)svtResolution)));
        }
        this.svts.add((Object)svt);
    }

    private void addHeightTex(Texture heightTex) {
        if (heightTex != null && this.material != null) {
            this.heightSize.set((float)heightTex.getWidth(), (float)heightTex.getHeight());
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.Height, heightTex));
            this.material.set((Attribute)new FloatAttribute(FloatAttribute.HeightScale, this.heightScale.floatValue()));
            this.material.set((Attribute)new FloatAttribute(FloatAttribute.ElevationMultiplier, (float)Settings.settings.scene.renderer.elevation.multiplier));
            this.material.set((Attribute)new Vector2Attribute(Vector2Attribute.HeightSize, this.heightSize));
            this.material.set((Attribute)new FloatAttribute(FloatAttribute.TessQuality, (float)Settings.settings.scene.renderer.elevation.quality));
        }
    }

    private void addDiffuseTex(Texture diffuseTex) {
        if (diffuseTex != null && this.material != null) {
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.Diffuse, diffuseTex));
        }
    }

    private void addSpecularTex(Texture specularTex) {
        if (specularTex != null && this.material != null) {
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.Specular, specularTex));
        }
    }

    private void addNormalTex(Texture normalTex) {
        if (normalTex != null && this.material != null) {
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.Normal, normalTex));
        }
    }

    private void addEmissiveTex(Texture emissiveTex) {
        if (emissiveTex != null && this.material != null) {
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.Emissive, emissiveTex));
        }
    }

    private void addRoughnessTex(Texture roughnessTex) {
        if (roughnessTex != null && this.material != null) {
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.Roughness, roughnessTex));
        }
    }

    private void addTexture0(Texture tex) {
        if (tex != null && this.material != null) {
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.Texture0, tex));
        }
    }

    private void addTexture1(Texture tex) {
        if (tex != null && this.material != null) {
            this.material.set((Attribute)new TextureAttribute(TextureAttribute.Texture1, tex));
        }
    }

    public void setGenerated(boolean generated) {
        this.heightGenerated.set(generated);
    }

    private synchronized void initializeGenElevationData() {
        if (this.heightGenerated.get()) {
            this.addHeightTex(this.heightTex);
        } else {
            this.heightGenerated.set(true);
            GaiaSky.postRunnable(() -> {
                int N = Settings.settings.graphics.proceduralGenerationResolution[0];
                int M = Settings.settings.graphics.proceduralGenerationResolution[1];
                logger.info(I18n.msg("gui.procedural.info.generate", I18n.msg("gui.procedural.surface"), Integer.toString(N), Integer.toString(M)));
                Random rand = new Random();
                if (this.nc == null) {
                    this.nc = new NoiseComponent();
                    switch (rand.nextInt(10)) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            this.nc.randomizeEarthLike(rand);
                            break;
                        }
                        case 4: {
                            this.nc.randomizeRockyPlanet(rand);
                            break;
                        }
                        case 5: {
                            this.nc.randomizeGasGiant(rand);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            this.nc.randomizeSnowPlanet(rand);
                            break;
                        }
                        case 9: {
                            this.nc.randomizeAll(rand);
                        }
                    }
                }
                GaiaSky.postRunnable(() -> {
                    FrameBuffer fbBiome = this.nc.generateBiome(N, M);
                    GaiaSky.postRunnable(() -> {
                        FrameBuffer fbSurface = this.nc.generateSurface(N, M, this.biomeLUT, this.biomeHueShift, this.biomeSaturation, Settings.settings.scene.renderer.elevation.type.isNone());
                        GaiaSky.postRunnable(() -> {
                            boolean cEmissive;
                            int nBiomeAttachments = fbBiome.getTextureAttachments().size;
                            int nSurfaceAttachments = fbSurface.getTextureAttachments().size;
                            Texture heightT = (Texture)fbBiome.getColorBufferTexture();
                            Texture emissiveT = nBiomeAttachments > 1 ? (Texture)fbBiome.getTextureAttachments().get(1) : null;
                            Texture diffuseT = (Texture)fbSurface.getColorBufferTexture();
                            Texture specularT = (Texture)fbSurface.getTextureAttachments().get(1);
                            Texture normalT = nSurfaceAttachments > 2 ? (Texture)fbSurface.getTextureAttachments().get(2) : null;
                            boolean cDiffuse = this.diffuse != null && this.diffuse.endsWith("generate");
                            boolean cSpecular = this.specular != null && this.specular.endsWith("generate");
                            boolean cNormal = this.normal != null && this.normal.endsWith("generate");
                            boolean bl = cEmissive = this.emissive != null && this.emissive.endsWith("generate");
                            if (heightT != null && !Settings.settings.scene.renderer.elevation.type.isNone()) {
                                this.heightData = new HeightDataPixmap(heightT, null);
                                this.heightTex = heightT;
                                this.addHeightTex(this.heightTex);
                            }
                            if (cDiffuse && diffuseT != null) {
                                this.diffuseTex = diffuseT;
                                this.addDiffuseTex(this.diffuseTex);
                            }
                            if (cSpecular && specularT != null) {
                                this.specularTex = specularT;
                                this.addSpecularTex(this.specularTex);
                            }
                            if (cNormal && normalT != null) {
                                this.normalTex = normalT;
                                this.addNormalTex(this.normalTex);
                            }
                            if (cEmissive && emissiveT != null) {
                                this.emissiveTex = emissiveT;
                                this.addEmissiveTex(this.emissiveTex);
                            }
                            if (Settings.settings.program.saveProceduralTextures) {
                                SysUtils.saveProceduralGLTextures(new Texture[]{heightT, diffuseT, specularT, normalT, emissiveT}, new String[]{this.name + "-biome", this.name + "-diffuse", this.name + "-specular", this.name + "-normal", this.name + "-emissive"}, Settings.ImageFormat.JPG);
                            }
                        });
                    });
                });
            });
        }
    }

    private void initializeElevationData(VirtualTextureComponent svt, AssetManager manager) {
        if (!this.heightInitialized.get()) {
            this.heightInitialized.set(true);
            GaiaSky.instance.getExecutorService().execute(() -> {
                this.heightData = new HeightDataSVT(svt.tree, manager);
            });
        }
    }

    private void initializeElevationData(Texture tex) {
        if (!this.heightInitialized.get()) {
            this.heightInitialized.set(true);
            GaiaSky.instance.getExecutorService().execute(() -> {
                this.heightData = new HeightDataPixmap(tex, () -> this.addHeightTex(tex));
            });
        }
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    public Material getRingMaterial() {
        return this.ringMaterial;
    }

    private void removeElevationData() {
        this.heightData = null;
        this.material.remove(TextureAttribute.Height);
        this.material.remove(FloatAttribute.HeightScale);
        this.material.remove(FloatAttribute.ElevationMultiplier);
        this.material.remove(Vector2Attribute.HeightSize);
        this.material.remove(FloatAttribute.HeightNoiseSize);
        this.material.remove(FloatAttribute.TessQuality);
        if (this.normalTex != null && this.material != null && this.material.get(TextureAttribute.Normal) == null) {
            this.addNormalTex(this.normalTex);
        }
    }

    @Deprecated
    public void setBase(String diffuse) {
        this.setDiffuse(diffuse);
    }

    public void setDiffuse(String diffuse) {
        this.diffuse = Settings.settings.data.dataFile(diffuse);
    }

    public void setSpecular(String specular) {
        this.specular = Settings.settings.data.dataFile(specular);
    }

    public void setSpecularValue(Double specular) {
        float r = specular.floatValue();
        this.specularColor = new float[]{r, r, r};
    }

    public void setSpecular(Double specular) {
        this.setSpecularValue(specular);
    }

    public void setSpecularValues(double[] specular) {
        if (specular.length > 1) {
            this.specularColor = new float[]{(float)specular[0], (float)specular[1], (float)specular[2]};
        } else {
            float r = (float)specular[0];
            this.specularColor = new float[]{r, r, r};
        }
    }

    public void setSpecular(double[] specular) {
        this.setSpecularValues(specular);
    }

    public void setNormal(String normal) {
        this.normal = Settings.settings.data.dataFile(normal);
    }

    @Deprecated
    public void setNight(String emissive) {
        this.setEmissive(emissive);
    }

    public void setEmissive(String emissive) {
        this.emissive = Settings.settings.data.dataFile(emissive);
    }

    public void setEmissive(Double emissive) {
        float r = emissive.floatValue();
        this.emissiveColor = new float[]{r, r, r};
    }

    public void setEmissive(double[] emissive) {
        if (emissive.length > 1) {
            this.emissiveColor = new float[]{(float)emissive[0], (float)emissive[1], (float)emissive[2]};
        } else {
            float r = (float)emissive[0];
            this.emissiveColor = new float[]{r, r, r};
        }
    }

    public void setDiffuseScattering(Double diffuseScattering) {
        float r = diffuseScattering.floatValue();
        this.diffuseScatteringColor = new float[]{r, r, r};
    }

    public void setDiffuseScattering(double[] diffuseScattering) {
        if (diffuseScattering.length > 1) {
            this.diffuseScatteringColor = new float[]{(float)diffuseScattering[0], (float)diffuseScattering[1], (float)diffuseScattering[2]};
        } else {
            float r = (float)diffuseScattering[0];
            this.diffuseScatteringColor = new float[]{r, r, r};
        }
    }

    public void setRing(String ring) {
        this.setRingDiffuse(ring);
    }

    public void setRingDiffuse(String ringDiffuse) {
        this.ring = Settings.settings.data.dataFile(ringDiffuse);
    }

    public void setRingnormal(String ringNormal) {
        this.setRingNormal(ringNormal);
    }

    public void setRingNormal(String ringNormal) {
        this.ringnormal = Settings.settings.data.dataFile(ringNormal);
    }

    public void setRingDiffuseScattering(Double ringDiffuseScattering) {
        float r = ringDiffuseScattering.floatValue();
        this.ringDiffuseScatteringColor = new float[]{r, r, r};
    }

    public void setRingDiffuseScattering(double[] ringDiffuseScattering) {
        if (ringDiffuseScattering.length > 1) {
            this.ringDiffuseScatteringColor = new float[]{(float)ringDiffuseScattering[0], (float)ringDiffuseScattering[1], (float)ringDiffuseScattering[2]};
        } else {
            float r = (float)ringDiffuseScattering[0];
            this.ringDiffuseScatteringColor = new float[]{r, r, r};
        }
    }

    public void setHeight(String height) {
        this.height = Settings.settings.data.dataFile(height);
    }

    public void setHeightScaleKm(Double heightScale) {
        this.heightScale = Float.valueOf((float)(heightScale * Constants.KM_TO_U));
    }

    public void setHeightScaleM(Double heightScale) {
        this.heightScale = Float.valueOf((float)(heightScale * Constants.M_TO_U));
    }

    public void setHeightScale(Double heightScale) {
        this.setHeightScaleKm(heightScale);
    }

    public void setHeightMapTopKm(Double heightMapTopKm) {
        this.setHeightScaleKm(heightMapTopKm);
    }

    public void setHeightMapTopM(Double heightMapTopM) {
        this.setHeightScaleM(heightMapTopM);
    }

    public void setColorIfTexture(Boolean colorIfTexture) {
        this.colorIfTexture = colorIfTexture;
    }

    public void setNoise(NoiseComponent noise) {
        this.nc = noise;
    }

    public void setBiomelut(String biomeLookupTex) {
        this.setBiomeLUT(biomeLookupTex);
    }

    public void setBiomeLUT(String biomeLookupTex) {
        this.biomeLUT = biomeLookupTex;
    }

    public void setBiomehueshift(Double hueShift) {
        this.setBiomeHueShift(hueShift);
    }

    public void setBiomeHueShift(Double hueShift) {
        this.biomeHueShift = hueShift.floatValue();
    }

    public void setBiomeSaturation(Double saturation) {
        this.biomeSaturation = saturation.floatValue();
    }

    @Deprecated
    public void setReflection(Double metallicColor) {
        this.setMetallic(metallicColor);
    }

    public void setMetallic(Double metallicColor) {
        float r = metallicColor.floatValue();
        this.metallicColor = new float[]{r, r, r};
    }

    public void setMetallic(String metallic) {
        this.metallic = Settings.settings.data.dataFile(metallic);
    }

    public void setReflection(double[] metallic) {
        if (metallic.length > 1) {
            this.metallicColor = new float[]{(float)metallic[0], (float)metallic[1], (float)metallic[2]};
        } else {
            float r = (float)metallic[0];
            this.metallicColor = new float[]{r, r, r};
        }
    }

    public void setRoughness(String roughness) {
        this.roughness = Settings.settings.data.dataFile(roughness);
    }

    public void setRoughness(Double roughness) {
        this.roughnessColor = roughness.floatValue();
    }

    public void setAo(String ao) {
        this.ao = Settings.settings.data.dataFile(ao);
    }

    public void setOcclusionMetallicRoughness(String texture) {
        this.occlusionMetallicRoughness = Settings.settings.data.dataFile(texture);
    }

    public void setTexture0(String texture0) {
        this.texture0 = Settings.settings.data.dataFile(texture0);
    }

    public void setTexture1(String texture1) {
        this.texture1 = Settings.settings.data.dataFile(texture1);
    }

    public void setDiffuseCubemap(String cubemap) {
        this.diffuseCubemap = new CubemapComponent();
        this.diffuseCubemap.setLocation(cubemap);
    }

    public void setNormalCubemap(String cubemap) {
        this.normalCubemap = new CubemapComponent();
        this.normalCubemap.setLocation(cubemap);
    }

    public void setSpecularCubemap(String cubemap) {
        this.specularCubemap = new CubemapComponent();
        this.specularCubemap.setLocation(cubemap);
    }

    public void setEmissiveCubemap(String cubemap) {
        this.emissiveCubemap = new CubemapComponent();
        this.emissiveCubemap.setLocation(cubemap);
    }

    public void setNightCubemap(String cubemap) {
        this.setEmissiveCubemap(cubemap);
    }

    public void setHeightCubemap(String cubemap) {
        this.heightCubemap = new CubemapComponent();
        this.heightCubemap.setLocation(cubemap);
    }

    public void setMetallicCubemap(String cubemap) {
        this.metallicCubemap = new CubemapComponent();
        this.metallicCubemap.setLocation(cubemap);
    }

    public void setRoughnessCubemap(String cubemap) {
        this.roughnessCubemap = new CubemapComponent();
        this.roughnessCubemap.setLocation(cubemap);
    }

    public void setReflectionCubemap(String reflectionCubemap) {
        MaterialComponent.reflectionCubemap = new CubemapComponent();
        MaterialComponent.reflectionCubemap.setLocation(reflectionCubemap);
    }

    public void setAmbientOcclusionCubemap(String cubemap) {
        this.aoCubemap = new CubemapComponent();
        this.aoCubemap.setLocation(cubemap);
    }

    public void setOcclusionClouds(boolean state) {
        this.occlusionClouds = state;
    }

    public void setAmbientOcclusionCubemap(CubemapComponent cubemap) {
        this.aoCubemap = cubemap;
    }

    public void setSkybox(String diffuseCubemap) {
        this.setDiffuseCubemap(diffuseCubemap);
    }

    public void setDiffuseSVT(VirtualTextureComponent virtualTextureComponent) {
        if (this.diffuseSvt != null && !this.diffuseSvt.location.equals(virtualTextureComponent.location)) {
            logger.warn("Overwriting diffuse SVT: " + this.diffuseSvt.location + " -> " + virtualTextureComponent.location);
        }
        this.diffuseSvt = virtualTextureComponent;
    }

    public void setDiffuseSVT(Map<Object, Object> virtualTexture) {
        this.setDiffuseSVT(MaterialComponent.convertToComponent(virtualTexture));
    }

    public void setSpecularSVT(VirtualTextureComponent virtualTextureComponent) {
        if (this.specularSvt != null && !this.specularSvt.location.equals(virtualTextureComponent.location)) {
            logger.warn("Overwriting specular SVT: " + this.specularSvt.location + " -> " + virtualTextureComponent.location);
        }
        this.specularSvt = virtualTextureComponent;
    }

    public void setSpecularSVT(Map<Object, Object> virtualTexture) {
        this.setSpecularSVT(MaterialComponent.convertToComponent(virtualTexture));
    }

    public void setNormalSVT(VirtualTextureComponent virtualTextureComponent) {
        this.normalSvt = virtualTextureComponent;
    }

    public void setNormalSVT(Map<Object, Object> virtualTexture) {
        this.setNormalSVT(MaterialComponent.convertToComponent(virtualTexture));
    }

    public void setHeightSVT(VirtualTextureComponent virtualTextureComponent) {
        this.heightSvt = virtualTextureComponent;
    }

    public void setHeightSVT(Map<Object, Object> virtualTexture) {
        this.setHeightSVT(MaterialComponent.convertToComponent(virtualTexture));
    }

    public void setEmissiveSVT(VirtualTextureComponent virtualTextureComponent) {
        this.emissiveSvt = virtualTextureComponent;
    }

    public void setEmissiveSVT(Map<Object, Object> virtualTexture) {
        this.setEmissiveSVT(MaterialComponent.convertToComponent(virtualTexture));
    }

    public void setMetallicSVT(VirtualTextureComponent virtualTextureComponent) {
        this.metallicSvt = virtualTextureComponent;
    }

    public void setMetallicSVT(Map<Object, Object> virtualTexture) {
        this.setMetallicSVT(MaterialComponent.convertToComponent(virtualTexture));
    }

    public void setRoughnessSVT(VirtualTextureComponent virtualTextureComponent) {
        this.roughnessSvt = virtualTextureComponent;
    }

    public void setRoughnessSVT(Map<Object, Object> virtualTexture) {
        this.setRoughnessSVT(MaterialComponent.convertToComponent(virtualTexture));
    }

    public void setAoSVT(VirtualTextureComponent virtualTextureComponent) {
        this.aoSvt = virtualTextureComponent;
    }

    public void setAoSVT(Map<Object, Object> virtualTexture) {
        this.setAoSVT(MaterialComponent.convertToComponent(virtualTexture));
    }

    public static VirtualTextureComponent convertToComponent(Map<Object, Object> map) {
        VirtualTextureComponent vt = new VirtualTextureComponent();
        if (map.containsKey("location")) {
            vt.setLocation((String)map.get("location"));
        }
        if (map.containsKey("tileSize")) {
            vt.setTileSize((Long)map.get("tileSize"));
        }
        return vt;
    }

    public boolean hasHeight() {
        return this.height != null && !this.height.isEmpty();
    }

    public void disposeTexture(AssetManager manager, Material material, String name, String nameUnpacked, int attributeIndex, Texture tex) {
        if (name != null && manager != null && manager.isLoaded(nameUnpacked)) {
            this.unload(material, attributeIndex);
            manager.unload(nameUnpacked);
        }
        if (tex != null) {
            this.unload(material, attributeIndex);
            tex.dispose();
        }
    }

    public void disposeCubemap(AssetManager manager, Material mat, int attributeIndex, CubemapComponent cubemap) {
        if (cubemap != null && cubemap.isLoaded(manager)) {
            this.unload(mat, attributeIndex);
            manager.unload(cubemap.cmBack);
            manager.unload(cubemap.cmFront);
            manager.unload(cubemap.cmUp);
            manager.unload(cubemap.cmDown);
            manager.unload(cubemap.cmRight);
            manager.unload(cubemap.cmLeft);
            cubemap.dispose();
        }
    }

    public void disposeTextures(AssetManager manager) {
        this.disposeTexture(manager, this.material, this.diffuse, this.diffuseUnpacked, TextureAttribute.Diffuse, this.diffuseTex);
        this.disposeTexture(manager, this.material, this.normal, this.normalUnpacked, TextureAttribute.Normal, this.normalTex);
        this.disposeTexture(manager, this.material, this.specular, this.specularUnpacked, TextureAttribute.Specular, this.specularTex);
        this.disposeTexture(manager, this.material, this.emissive, this.emissiveUnpacked, TextureAttribute.Emissive, null);
        this.disposeTexture(manager, this.ringMaterial, this.ring, this.ringUnpacked, TextureAttribute.Diffuse, null);
        this.disposeTexture(manager, this.ringMaterial, this.ringnormal, this.ringnormalUnpacked, TextureAttribute.Normal, null);
        this.disposeTexture(manager, this.material, this.height, this.heightUnpacked, TextureAttribute.Height, this.heightTex);
        this.disposeTexture(manager, this.material, this.metallic, this.metallicUnpacked, TextureAttribute.Metallic, null);
        this.disposeTexture(manager, this.material, this.roughness, this.roughnessUnapcked, TextureAttribute.Roughness, null);
        this.disposeTexture(manager, this.material, this.ao, this.aoUnpacked, TextureAttribute.AO, null);
        this.disposeTexture(manager, this.material, this.texture0, this.texture0Unpacked, TextureAttribute.Texture0, null);
        this.disposeTexture(manager, this.material, this.texture1, this.texture1Unpacked, TextureAttribute.Texture1, null);
        this.disposeCubemap(manager, this.material, CubemapAttribute.DiffuseCubemap, this.diffuseCubemap);
        this.disposeCubemap(manager, this.material, CubemapAttribute.NormalCubemap, this.normalCubemap);
        this.disposeCubemap(manager, this.material, CubemapAttribute.EmissiveCubemap, this.emissiveCubemap);
        this.disposeCubemap(manager, this.material, CubemapAttribute.SpecularCubemap, this.specularCubemap);
        this.disposeCubemap(manager, this.material, CubemapAttribute.RoughnessCubemap, this.roughnessCubemap);
        this.disposeCubemap(manager, this.material, CubemapAttribute.MetallicCubemap, this.metallicCubemap);
        this.disposeCubemap(manager, this.material, CubemapAttribute.HeightCubemap, this.heightCubemap);
        this.disposeCubemap(manager, this.material, CubemapAttribute.AmbientOcclusionCubemap, this.aoCubemap);
        this.texLoading = false;
        this.texInitialised = false;
    }

    public void disposeNoiseBuffers() {
        if (this.nc != null) {
            this.nc.dispose();
        }
    }

    private void unload(Material mat, int attrIndex) {
        if (mat != null) {
            Attribute attr = mat.get(attrIndex);
            mat.remove(attrIndex);
            if (attr instanceof TextureAttribute) {
                Texture tex = (Texture)((TextureAttribute)attr).textureDescription.texture;
                tex.dispose();
            }
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case ELEVATION_TYPE_CMD: {
                if (!this.hasHeight() || this.material == null) break;
                Settings.ElevationType newType = (Settings.ElevationType)((Object)data[0]);
                GaiaSky.postRunnable(() -> {
                    if (newType.isNone()) {
                        this.removeElevationData();
                    } else if (this.height.endsWith("generate")) {
                        this.initializeGenElevationData();
                    } else if (this.heightData == null) {
                        if (this.material.has(TextureAttribute.Height)) {
                            this.initializeElevationData((Texture)((TextureAttribute)Objects.requireNonNull(this.material.get((int)TextureAttribute.Height))).textureDescription.texture);
                        } else if (AssetBean.manager().isLoaded(this.heightUnpacked)) {
                            if (!this.height.endsWith("generate")) {
                                Texture tex = (Texture)AssetBean.manager().get(this.heightUnpacked, Texture.class);
                                if (!Settings.settings.scene.renderer.elevation.type.isNone()) {
                                    this.initializeElevationData(tex);
                                }
                            } else {
                                this.initializeGenElevationData();
                            }
                        }
                    }
                });
                break;
            }
            case ELEVATION_MULTIPLIER_CMD: {
                if (!this.hasHeight() || this.material == null) break;
                float newMultiplier = ((Float)data[0]).floatValue();
                GaiaSky.postRunnable(() -> this.material.set((Attribute)new FloatAttribute(FloatAttribute.ElevationMultiplier, newMultiplier)));
                break;
            }
            case TESSELLATION_QUALITY_CMD: {
                if (!this.hasHeight() || this.material == null) break;
                float newQuality = ((Float)data[0]).floatValue();
                GaiaSky.postRunnable(() -> this.material.set((Attribute)new FloatAttribute(FloatAttribute.TessQuality, newQuality)));
                break;
            }
            case TOGGLE_VISIBILITY_CMD: {
                if (!this.occlusionClouds || this.getMaterial() == null) break;
                GaiaSky.postRunnable(() -> {
                    if (GaiaSky.instance.sceneRenderer.visible.get(ComponentTypes.ComponentType.Clouds.ordinal())) {
                        if (this.aoTexture != null) {
                            this.material.set((Attribute)new TextureAttribute(TextureAttribute.AO, this.aoTexture));
                        } else if (this.aoCubemap != null) {
                            this.getMaterial().set((Attribute)new CubemapAttribute(CubemapAttribute.AmbientOcclusionCubemap, this.aoCubemap.cubemap));
                        } else if (this.aoSvt != null) {
                            this.material.set((Attribute)new TextureAttribute(TextureAttribute.SvtIndirectionAmbientOcclusion, this.aoSvt.indirectionBuffer));
                        }
                        this.getMaterial().set((Attribute)new OcclusionCloudsAttribute(true));
                    } else {
                        this.getMaterial().remove(OcclusionCloudsAttribute.Type);
                        this.getMaterial().remove(CubemapAttribute.AmbientOcclusionCubemap);
                        this.getMaterial().remove(TextureAttribute.AO);
                        this.getMaterial().remove(TextureAttribute.SvtIndirectionAmbientOcclusion);
                    }
                });
                break;
            }
        }
    }

    public String getTexturesString() {
        StringBuilder sb = new StringBuilder();
        if (this.diffuse != null) {
            sb.append(this.diffuse);
        }
        if (this.normal != null) {
            sb.append(",").append(this.normal);
        }
        if (this.specular != null) {
            sb.append(",").append(this.specular);
        }
        if (this.emissive != null) {
            sb.append(",").append(this.emissive);
        }
        if (this.ring != null) {
            sb.append(",").append(this.ring);
        }
        if (this.ringnormal != null) {
            sb.append(",").append(this.ringnormal);
        }
        if (this.height != null) {
            sb.append(",").append(this.height);
        }
        if (this.texture0 != null) {
            sb.append(",").append(this.texture0);
        }
        if (this.texture1 != null) {
            sb.append(",").append(this.texture1);
        }
        return sb.toString();
    }

    public String toString() {
        return this.diffuse;
    }

    public void copyFrom(MaterialComponent other) {
        this.height = other.height;
        this.diffuse = other.diffuse;
        this.normal = other.normal;
        this.specular = other.specular;
        this.emissive = other.emissive;
        this.metallic = other.metallic;
        this.roughness = other.roughness;
        this.biomeLUT = other.biomeLUT;
        this.biomeHueShift = other.biomeHueShift;
        this.biomeSaturation = other.biomeSaturation;
        this.heightScale = other.heightScale;
        this.texture0 = other.texture0;
        this.texture1 = other.texture1;
        this.nc = new NoiseComponent();
        if (other.nc != null) {
            this.nc.copyFrom(other.nc);
        } else {
            this.nc.randomizeAll(new Random());
        }
    }

    public void randomizeAll(long seed) {
        this.initializeLookUpTables();
        Random rand = new Random(seed);
        this.setHeight("generate");
        this.setDiffuse("generate");
        this.setSpecular("generate");
        this.setNormal("generate");
        this.setEmissive("generate");
        this.setBiomelut((String)lookUpTables.get(rand.nextInt(MaterialComponent.lookUpTables.size)));
        if (rand.nextBoolean()) {
            this.setBiomeHueShift(rand.nextDouble() * 360.0);
        } else {
            this.setBiomeHueShift(0.0);
        }
        if (rand.nextInt(6) < 5) {
            this.setBiomeSaturation(rand.nextDouble(0.5, 1.0));
        } else {
            this.setBiomeSaturation(rand.nextDouble(0.0, 0.5));
        }
        this.setHeightScale(this.gaussian(rand, 30.0, 40.0, 1.0, 80.0));
        if (this.nc != null) {
            this.nc.dispose();
        }
        NoiseComponent nc = new NoiseComponent();
        nc.randomizeAll(rand);
        this.setNoise(nc);
    }

    private String randomBiomeLut(Random rand, String ... names) {
        Array candidates = new Array(names.length);
        block0: for (String name : names) {
            for (String lut : lookUpTables) {
                if (!lut.contains(name)) continue;
                candidates.add((Object)lut);
                continue block0;
            }
        }
        return (String)candidates.get(rand.nextInt(candidates.size));
    }

    public void randomizeRockyPlanet(long seed) {
        this.initializeLookUpTables();
        Random rand = new Random(seed);
        this.setHeight("generate");
        this.setDiffuse("generate");
        this.setNormal("generate");
        this.setSpecular("generate");
        this.setEmissive("generate");
        this.setBiomelut(this.randomBiomeLut(rand, "rock-smooth-lut", "brown-green-lut", "biome-water-rock-lut"));
        if (rand.nextBoolean()) {
            this.setBiomeHueShift((rand.nextDouble(-20.0, 20.0) + 360.0) % 360.0);
        } else {
            this.setBiomeHueShift(rand.nextDouble(100.0, 140.0));
        }
        this.setBiomeSaturation(rand.nextDouble(0.0, 0.5));
        this.setHeightScale(this.gaussian(rand, 30.0, 40.0, 1.0, 80.0));
        if (this.nc != null) {
            this.nc.dispose();
        }
        NoiseComponent nc = new NoiseComponent();
        nc.randomizeRockyPlanet(rand);
        this.setNoise(nc);
    }

    public void randomizeEarthLike(long seed) {
        this.initializeLookUpTables();
        Random rand = new Random(seed);
        this.setHeight("generate");
        this.setDiffuse("generate");
        this.setNormal("generate");
        this.setSpecular("generate");
        this.setEmissive("generate");
        this.setBiomelut(this.randomBiomeLut(rand, "biome-lut", "biome-smooth-lut", "biome-vertical-lut", "biomes-separate-lut", "brown-green-lut", "biome-snow2-lut", "biome-brown-green-lut"));
        this.setBiomeHueShift((rand.nextDouble(-30.0, 30.0) + 360.0) % 360.0);
        this.setBiomeSaturation(rand.nextDouble(0.8, 1.0));
        this.setHeightScale(this.gaussian(rand, 30.0, 40.0, 1.0, 80.0));
        if (this.nc != null) {
            this.nc.dispose();
        }
        NoiseComponent nc = new NoiseComponent();
        nc.randomizeEarthLike(rand);
        this.setNoise(nc);
    }

    public void randomizeColdPlanet(long seed) {
        this.initializeLookUpTables();
        Random rand = new Random(seed);
        this.setHeight("generate");
        this.setDiffuse("generate");
        this.setNormal("generate");
        this.setSpecular("generate");
        this.setEmissive("generate");
        this.setBiomelut(this.randomBiomeLut(rand, "biome-snow1-lut", "biome-snow2-lut"));
        this.setBiomeHueShift((rand.nextDouble(-30.0, 30.0) + 360.0) % 360.0);
        this.setBiomeSaturation(rand.nextDouble(0.8, 1.0));
        this.setHeightScale(this.gaussian(rand, 30.0, 40.0, 1.0, 80.0));
        if (this.nc != null) {
            this.nc.dispose();
        }
        NoiseComponent nc = new NoiseComponent();
        nc.randomizeEarthLike(rand);
        this.setNoise(nc);
    }

    public void randomizeGasGiant(long seed) {
        this.initializeLookUpTables();
        Random rand = new Random(seed);
        this.setHeight("generate");
        this.setDiffuse("generate");
        this.setNormal("generate");
        this.setSpecular("generate");
        this.setEmissive("generate");
        this.setBiomelut((String)lookUpTables.get(rand.nextInt(MaterialComponent.lookUpTables.size)));
        this.setBiomehueshift(rand.nextDouble() * 360.0);
        this.setBiomeSaturation(rand.nextDouble(0.7, 1.0));
        this.setHeightScale(1.0);
        if (this.nc != null) {
            this.nc.dispose();
        }
        NoiseComponent nc = new NoiseComponent();
        nc.randomizeGasGiant(rand);
        this.setNoise(nc);
    }

    public void print(Logger.Log log) {
        log.debug("Height: " + this.height);
        log.debug("Diffuse: " + this.diffuse);
        log.debug("Specular: " + this.specular);
        log.debug("Normal: " + this.normal);
        log.debug("LUT: " + this.biomeLUT);
        log.debug("Biome hue shift: " + this.biomeHueShift);
        log.debug("Biome saturation: " + this.biomeSaturation);
        log.debug("Height scale: " + this.heightScale);
        log.debug("---Noise---");
        if (this.nc != null) {
            this.nc.print(log);
        }
    }

    public void dispose() {
        this.disposeTextures(GaiaSky.instance.assetManager);
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    @Override
    public void updateWith(MaterialComponent object) {
        if (object.specularColor != null) {
            this.specularColor = object.specularColor;
        }
        if (object.diffuseColor != null) {
            this.diffuseColor = object.diffuseColor;
        }
        if (object.emissiveColor != null) {
            this.emissiveColor = object.emissiveColor;
        }
        if (object.metallicColor != null) {
            this.metallicColor = object.metallicColor;
        }
        if (!Float.isNaN(object.roughnessColor)) {
            this.roughnessColor = object.roughnessColor;
        }
        if (object.heightScale.floatValue() != DEFAULT_HEIGHT_SCALE) {
            this.heightScale = object.heightScale;
        }
        if (object.diffuse != null) {
            this.diffuse = object.diffuse;
        }
        if (object.specular != null) {
            this.specular = object.specular;
        }
        if (object.normal != null) {
            this.normal = object.normal;
        }
        if (object.height != null) {
            this.height = object.height;
        }
        if (object.emissive != null) {
            this.emissive = object.emissive;
        }
        if (object.metallic != null) {
            this.metallic = object.metallic;
        }
        if (object.roughness != null) {
            this.roughness = object.roughness;
        }
        if (object.texture0 != null) {
            this.texture0 = object.texture0;
        }
        if (object.texture1 != null) {
            this.texture1 = object.texture1;
        }
        if (object.diffuseCubemap != null) {
            this.diffuseCubemap = object.diffuseCubemap;
        }
        if (object.specularCubemap != null) {
            this.specularCubemap = object.specularCubemap;
        }
        if (object.normalCubemap != null) {
            this.normalCubemap = object.normalCubemap;
        }
        if (object.heightCubemap != null) {
            this.heightCubemap = object.heightCubemap;
        }
        if (object.emissiveCubemap != null) {
            this.emissiveCubemap = object.emissiveCubemap;
        }
        if (object.metallicCubemap != null) {
            this.metallicCubemap = object.metallicCubemap;
        }
        if (object.roughnessCubemap != null) {
            this.roughnessCubemap = object.roughnessCubemap;
        }
        if (object.aoCubemap != null) {
            this.aoCubemap = object.aoCubemap;
        }
        if (object.diffuseSvt != null) {
            this.diffuseSvt = object.diffuseSvt;
        }
        if (object.specularSvt != null) {
            this.specularSvt = object.specularSvt;
        }
        if (object.normalSvt != null) {
            this.normalSvt = object.normalSvt;
        }
        if (object.heightSvt != null) {
            this.heightSvt = object.heightSvt;
        }
        if (object.emissiveSvt != null) {
            this.emissiveSvt = object.emissiveSvt;
        }
        if (object.metallicSvt != null) {
            this.metallicSvt = object.metallicSvt;
        }
        if (object.roughnessSvt != null) {
            this.roughnessSvt = object.roughnessSvt;
        }
        if (object.aoSvt != null) {
            this.aoSvt = object.aoSvt;
        }
    }

    static {
        lookUpTables = new Array();
        logger = Logger.getLogger(MaterialComponent.class);
        DEFAULT_HEIGHT_SCALE = (float)(4.0 * Constants.KM_TO_U);
        textureParamsMipMap = new OwnTextureLoader.OwnTextureParameter();
        MaterialComponent.textureParamsMipMap.genMipMaps = true;
        MaterialComponent.textureParamsMipMap.magFilter = Texture.TextureFilter.Linear;
        MaterialComponent.textureParamsMipMap.minFilter = Texture.TextureFilter.MipMapLinearLinear;
        textureParams = new OwnTextureLoader.OwnTextureParameter();
        MaterialComponent.textureParams.genMipMaps = false;
        MaterialComponent.textureParams.magFilter = Texture.TextureFilter.Linear;
        MaterialComponent.textureParams.minFilter = Texture.TextureFilter.Linear;
        pfmTextureParams = new PFMTextureLoader.PFMTextureParameter(textureParams);
        MaterialComponent.pfmTextureParams.invert = false;
        MaterialComponent.pfmTextureParams.internalFormat = 6407;
        reflectionCubemap = new CubemapComponent();
    }
}

