/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.math.Matrix4;
import gaiasky.scene.record.ITransform;
import gaiasky.util.math.Matrix4D;

public class MatrixTransform
implements ITransform {
    private Matrix4 matFloat;
    private Matrix4D matDouble;

    public MatrixTransform() {
    }

    public MatrixTransform(double[] mat) {
        this.setMatrix(mat);
    }

    public MatrixTransform(float[] mat) {
        this.setMatrix(mat);
    }

    public MatrixTransform(Matrix4D mat) {
        this.setMatrix(mat);
    }

    public MatrixTransform(Matrix4 mat) {
        this.matFloat = new Matrix4(mat);
        this.matDouble = new Matrix4D(this.matFloat.val);
    }

    public void setMatrix(float[] mat) {
        this.matDouble = new Matrix4D(mat);
        this.matFloat = this.matDouble.putIn(new Matrix4());
    }

    public void setMatrix(Matrix4 mat) {
        this.matFloat = new Matrix4(mat);
        this.matDouble = new Matrix4D(this.matFloat.val);
    }

    public void setMatrix(double[] mat) {
        this.matDouble = new Matrix4D(mat);
        this.matFloat = this.matDouble.putIn(new Matrix4());
    }

    public void setMatrix(Matrix4D mat) {
        this.matDouble = new Matrix4D(mat);
        this.matFloat = this.matDouble.putIn(new Matrix4());
    }

    @Override
    public void apply(Matrix4 mat) {
        mat.mul(this.matFloat);
    }

    @Override
    public void apply(Matrix4D mat) {
        mat.mul(this.matDouble);
    }

    public boolean isEmpty() {
        return this.matFloat == null || this.matDouble == null;
    }

    public Matrix4D getMatDouble() {
        return this.matDouble;
    }

    public Matrix4 getMatFloat() {
        return this.matFloat;
    }

    @Override
    public ITransform copy() {
        if (this.matDouble != null) {
            return new MatrixTransform(this.matDouble.val);
        }
        if (this.matFloat != null) {
            return new MatrixTransform(this.matFloat.val);
        }
        return new MatrixTransform();
    }
}

