/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.GaiaSky;
import gaiasky.data.AssetBean;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.event.Observer;
import gaiasky.gui.beans.PrimitiveComboBoxBean;
import gaiasky.render.BlendMode;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IUpdatable;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.record.MaterialComponent;
import gaiasky.scene.record.NamedComponent;
import gaiasky.scene.record.RelativisticEffectsComponent;
import gaiasky.util.Bits;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.ModelCache;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.model.gltf.scene3d.model.ModelInstanceHack;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.CubemapAttribute;
import gaiasky.util.gdx.shader.attribute.DepthTestAttribute;
import gaiasky.util.gdx.shader.attribute.DirectionalLightsAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.IntAttribute;
import gaiasky.util.gdx.shader.attribute.PointLightsAttribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import gaiasky.util.gdx.shader.attribute.Vector3Attribute;
import gaiasky.util.i18n.I18n;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;

public final class ModelComponent
extends NamedComponent
implements Disposable,
IObserver,
IUpdatable<ModelComponent> {
    private static final Logger.Log logger = Logger.getLogger(ModelComponent.class);
    private static final ColorAttribute globalAmbient = new ColorAttribute(ColorAttribute.AmbientLight, (float)Settings.settings.scene.renderer.ambient, (float)Settings.settings.scene.renderer.ambient, (float)Settings.settings.scene.renderer.ambient, 1.0f);
    public boolean forceInit = false;
    public IntModelInstance instance;
    public Environment env;
    public Map<String, Object> params;
    public String type;
    public String modelFile;
    public double scale = 1.0;
    public boolean culling = true;
    public boolean tessellated = false;
    public MaterialComponent mtc;
    public RelativisticEffectsComponent rec;
    private Boolean staticLight = false;
    private final float[] ambientColor = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};
    private boolean modelInitialised;
    private boolean modelLoading;
    private boolean useColor = false;
    private BlendMode blendMode = BlendMode.ALPHA;
    private AssetManager manager;
    private float[] cc;
    private int primitiveType = 4;
    private final Vector3 aux = new Vector3();
    private boolean sizeSet = false;

    public ModelComponent() {
        this(true);
    }

    public ModelComponent(Boolean initEnvironment) {
    }

    public static void setGlobalAmbientLight(float level) {
        ModelComponent.globalAmbient.color.set(level, level, level, 1.0f);
    }

    public PointLight pointLight(int i) {
        Attribute attribute = this.env.get(PointLightsAttribute.Type);
        if (attribute != null) {
            PointLightsAttribute pointLightsAttribute = (PointLightsAttribute)attribute;
            if (pointLightsAttribute.lights.size > i) {
                return (PointLight)pointLightsAttribute.lights.get(i);
            }
        }
        return null;
    }

    public boolean hasPointLight(int i) {
        PointLight point = this.pointLight(i);
        return point != null && !ColorUtils.isZero(point.color);
    }

    public void clearPoints() {
        Attribute attribute = this.env.get(PointLightsAttribute.Type);
        if (attribute != null) {
            PointLightsAttribute pointLightsAttribute = (PointLightsAttribute)attribute;
            for (PointLight light : pointLightsAttribute.lights) {
                light.color.set(0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    public DirectionalLight dirLight(int i) {
        Attribute attribute = this.env.get(DirectionalLightsAttribute.Type);
        if (attribute != null) {
            DirectionalLightsAttribute directionalLightAttribute = (DirectionalLightsAttribute)attribute;
            if (directionalLightAttribute.lights.size > i) {
                return (DirectionalLight)directionalLightAttribute.lights.get(i);
            }
        }
        return null;
    }

    public boolean hasDirLight(int i) {
        DirectionalLight directional = this.dirLight(i);
        return directional != null && !ColorUtils.isZero(directional.color);
    }

    public void clearDirectionals() {
        Attribute attribute = this.env.get(DirectionalLightsAttribute.Type);
        if (attribute != null) {
            DirectionalLightsAttribute directionalLightAttribute = (DirectionalLightsAttribute)attribute;
            for (DirectionalLight light : directionalLightAttribute.lights) {
                light.color.set(0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    @Override
    public void initialize(String name) {
        super.initialize(name);
        this.initialize(false);
    }

    public void initialize(boolean mesh) {
        FileHandle model;
        FileHandle fileHandle = model = this.modelFile != null ? Settings.settings.data.dataFileHandle(this.modelFile) : null;
        if (mesh) {
            if (!Settings.settings.scene.initialization.lazyMesh && this.modelFile != null && model.exists()) {
                AssetBean.addAsset(Settings.settings.data.dataFile(this.modelFile), IntModel.class);
            }
        } else if (this.modelFile != null && model.exists()) {
            AssetBean.addAsset(Settings.settings.data.dataFile(this.modelFile), IntModel.class);
        }
        if ((this.forceInit || !Settings.settings.scene.initialization.lazyTexture) && this.mtc != null) {
            this.mtc.initialize(this.name);
            this.mtc.texLoading = true;
        }
        this.initializeEnvironment();
        this.rec = new RelativisticEffectsComponent();
        MaterialComponent.reflectionCubemap.initialize();
    }

    public void initializeEnvironment() {
        this.env = new Environment();
        if (this.staticLight.booleanValue() || this.ambientColor[0] >= 0.0f && this.ambientColor[1] >= 0.0f && this.ambientColor[2] >= 0.0f && this.ambientColor[3] >= 0.0f) {
            ColorAttribute staticAmbientLight = new ColorAttribute(ColorAttribute.AmbientLight, this.ambientColor[0], this.ambientColor[1], this.ambientColor[2], this.ambientColor[3]);
            this.env.set((Attribute)staticAmbientLight);
        } else {
            this.env.set((Attribute)globalAmbient);
        }
        if (!this.staticLight.booleanValue()) {
            int i;
            for (i = 0; i < 3; ++i) {
                DirectionalLight dLight = new DirectionalLight();
                dLight.color.set(0.0f, 0.0f, 0.0f, 1.0f);
                this.env.add(dLight);
            }
            for (i = 0; i < 3; ++i) {
                PointLight pointLight = new PointLight();
                pointLight.color.set(0.0f, 0.0f, 0.0f, 1.0f);
                this.env.add(pointLight);
            }
        }
    }

    public void doneLoading(AssetManager manager, Matrix4 localTransform, float[] cc) {
        this.doneLoading(manager, localTransform, cc, false);
    }

    public void doneLoading(AssetManager manager, Matrix4 localTransform, float[] cc, boolean mesh) {
        this.manager = manager;
        this.cc = cc;
        if (!mesh || !Settings.settings.scene.initialization.lazyMesh) {
            Pair<IntModel, Map<String, Material>> modelMaterial = this.initModelFile();
            if (modelMaterial != null) {
                IntModel model = modelMaterial.getFirst();
                this.instance = this.modelFile != null && (this.modelFile.endsWith("gltf") || this.modelFile.endsWith("glb")) ? new ModelInstanceHack(model, localTransform) : new IntModelInstance(model, localTransform);
            }
            this.modelInitialised = true;
        }
        if ((this.forceInit || !Settings.settings.scene.initialization.lazyTexture) && this.mtc != null) {
            this.mtc.initMaterial(manager, this.instance, cc, this.culling);
            this.mtc.texLoading = false;
            this.mtc.texInitialised = true;
        }
        if (this.mtc == null && this.instance != null) {
            this.addColorToMaterial();
        }
        EventManager.instance.subscribe((IObserver)this, Event.ECLIPSES_CMD);
        this.modelInitialised = this.modelInitialised || !Settings.settings.scene.initialization.lazyMesh;
        this.modelLoading = false;
    }

    private Pair<IntModel, Map<String, Material>> initModelFile() {
        IntModel model = null;
        Map<Object, Object> materials = null;
        if (this.modelFile != null && this.manager.isLoaded(Settings.settings.data.dataFile(this.modelFile))) {
            model = (IntModel)this.manager.get(Settings.settings.data.dataFile(this.modelFile), IntModel.class);
            materials = new HashMap<String, Material>();
            if (model.materials.size == 0) {
                Material material = new Material();
                model.materials.add((Object)material);
                materials.put("base", material);
            } else if (this.modelFile == null) {
                if (model.materials.size > 1) {
                    for (int i = 0; i < model.materials.size; ++i) {
                        Material mat = (Material)model.materials.get(i);
                        if (mat.id != null && !mat.id.isEmpty()) {
                            materials.put(mat.id, mat);
                            continue;
                        }
                        materials.put("base" + i, (Material)model.materials.get(i));
                    }
                } else {
                    Material mat = (Material)model.materials.first();
                    if (mat.id != null && !mat.id.isEmpty()) {
                        materials.put(mat.id, mat);
                    } else {
                        materials.put("base", mat);
                    }
                }
            }
            this.addReflectionCubemapAttribute(model.materials);
        } else if (this.type != null) {
            Bits attributes = Bits.indices(1, 8, 128, 256, 16);
            if (this.params.containsKey("attributes")) {
                attributes = Bits.indices(((Long)this.params.get("attributes")).intValue());
            }
            Pair<IntModel, Map<String, Material>> pair = ModelCache.cache.getModel(this.type, this.params, attributes, this.primitiveType);
            model = pair.getFirst();
            materials = pair.getSecond();
        } else if (this.modelFile != null) {
            logger.error(new RuntimeException("Error loading model: " + this.modelFile));
        } else {
            logger.error(new RuntimeException("Error loading model type: " + this.type + " (" + this.params.toString() + ")"));
        }
        if (materials != null) {
            if (materials.containsKey("base") && ((Material)materials.get("base")).size() < 2) {
                ((Material)materials.get("base")).clear();
            }
            return new Pair<IntModel, Map<String, Material>>(model, materials);
        }
        return null;
    }

    public void load(Matrix4 localTransform) {
        if (this.manager == null) {
            this.manager = AssetBean.manager();
        }
        if (this.manager.isLoaded(Settings.settings.data.dataFile(this.modelFile))) {
            this.doneLoading(this.manager, localTransform, null);
            this.modelLoading = false;
            this.modelInitialised = true;
        }
    }

    public void update(boolean relativistic, Matrix4 localTransform, float alpha, int blendSrc, int blendDst, boolean blendEnabled) {
        this.touch(localTransform);
        if (this.instance != null) {
            ICamera cam = GaiaSky.instance.getICamera();
            this.setVROffset(GaiaSky.instance.getCameraManager().naturalCamera);
            this.setTransparency(alpha, blendSrc, blendDst, blendEnabled);
            if (relativistic) {
                this.updateRelativisticEffects(cam);
            } else {
                this.updateRelativisticEffects(cam);
            }
        }
    }

    public void update(Matrix4 localTransform, float alpha, int blendSrc, int blendDst, boolean blendEnabled) {
        this.update(true, localTransform, alpha, blendSrc, blendDst, blendEnabled);
    }

    public void update(boolean relativistic, Matrix4 localTransform, float alpha) {
        switch (this.blendMode) {
            case ALPHA: {
                this.update(relativistic, localTransform, alpha, 770, 771, true);
                break;
            }
            case COLOR: {
                this.update(relativistic, localTransform, alpha, 1, 769, true);
                break;
            }
            case ADDITIVE: {
                this.update(relativistic, localTransform, alpha, 1, 1, true);
                break;
            }
            case NONE: {
                this.update(relativistic, localTransform, alpha, 1, 1, false);
            }
        }
    }

    public void update(Matrix4 localTransform, float alpha) {
        this.update(true, localTransform, alpha);
    }

    public void update(float alpha, boolean relativistic) {
        this.update(relativistic, null, alpha);
    }

    public void update(float alpha) {
        this.update(null, alpha);
    }

    public void touch() {
        this.touch(null);
    }

    public void touch(Matrix4 localTransform) {
        if (Settings.settings.scene.initialization.lazyTexture && this.mtc != null && !this.mtc.texInitialised) {
            if (!this.mtc.texLoading) {
                this.mtc.initialize(this.name, this.manager);
                this.mtc.texLoading = true;
            } else if (this.mtc.isFinishedLoading(this.manager)) {
                GaiaSky.postRunnable(() -> this.mtc.initMaterial(this.manager, this.instance, this.cc, this.culling));
                this.mtc.texLoading = false;
                this.mtc.texInitialised = true;
            }
        }
        if (localTransform != null && Settings.settings.scene.initialization.lazyMesh && !this.modelInitialised) {
            if (!this.modelLoading) {
                String mf = Settings.settings.data.dataFile(this.modelFile);
                logger.info(I18n.msg("notif.loading", mf));
                AssetBean.addAsset(mf, IntModel.class);
                this.modelLoading = true;
            } else if (this.manager.isLoaded(Settings.settings.data.dataFile(this.modelFile))) {
                Pair<IntModel, Map<String, Material>> modMat = this.initModelFile();
                assert (modMat != null);
                IntModel model = modMat.getFirst();
                this.instance = this.modelFile != null && (this.modelFile.endsWith("gltf") || this.modelFile.endsWith("glb")) ? new ModelInstanceHack(model, localTransform) : new IntModelInstance(model, localTransform);
                if (this.mtc == null) {
                    this.addColorToMaterial();
                }
                this.modelInitialised = true;
                this.modelLoading = false;
            }
        }
    }

    public void setModelInitialized(boolean initialized) {
        this.modelInitialised = initialized;
    }

    public void addColorToMaterial() {
        int n = this.instance.materials.size;
        for (int i = 0; i < n; ++i) {
            Material material = (Material)this.instance.materials.get(i);
            if (this.cc != null && (this.useColor || !material.has(ColorAttribute.Diffuse))) {
                material.set((Attribute)new ColorAttribute(ColorAttribute.Diffuse, this.cc[0], this.cc[1], this.cc[2], this.cc[3]));
            }
            if (this.culling) continue;
            material.set((Attribute)new IntAttribute(IntAttribute.CullFace, 0));
        }
    }

    public void dispose() {
        if (this.instance != null && this.instance.model != null) {
            this.instance.model.dispose();
        }
    }

    public void setVROffset(NaturalCamera cam) {
        if (Settings.settings.runtime.openXr && cam.vrOffset != null) {
            int n = this.instance.materials.size;
            for (int i = 0; i < n; ++i) {
                Material mat = (Material)this.instance.materials.get(i);
                if (mat.has(Vector3Attribute.VrOffset)) {
                    cam.vrOffset.put(((Vector3Attribute)Objects.requireNonNull(mat.get((int)Vector3Attribute.VrOffset))).value);
                    ((Vector3Attribute)Objects.requireNonNull(mat.get((int)Vector3Attribute.VrOffset))).value.scl(50000.0f);
                    continue;
                }
                Vector3Attribute v3a = new Vector3Attribute(Vector3Attribute.VrOffset, cam.vrOffset.toVector3());
                mat.set((Attribute)v3a);
            }
        }
    }

    public void setTransparency(float alpha, int blendSrc, int blendDest, boolean blendEnabled) {
        boolean isAdditive = blendEnabled && this.blendMode == BlendMode.ADDITIVE;
        int n = this.instance.materials.size;
        for (int i = 0; i < n; ++i) {
            ColorAttribute c;
            Material mat = (Material)this.instance.materials.get(i);
            if (mat.has(BlendingAttribute.Type)) {
                ba = (BlendingAttribute)mat.get(BlendingAttribute.Type);
                assert (ba != null);
                ba.destFunction = blendDest;
                ba.sourceFunction = blendSrc;
            } else {
                ba = new BlendingAttribute(blendSrc, blendDest);
                mat.set((Attribute)ba);
            }
            ba.blended = blendEnabled;
            ba.opacity = alpha;
            if (!isAdditive || !mat.has(ColorAttribute.Diffuse) || (c = (ColorAttribute)mat.get(ColorAttribute.Diffuse)) == null) continue;
            c.color.a = alpha;
        }
    }

    public void updateSizeKm(double sizeInternal) {
        this.updateSize(sizeInternal * Constants.KM_TO_U);
    }

    public void updateSize(double sizeInternal) {
        if (!this.sizeSet && this.instance != null) {
            int n = this.instance.materials.size;
            for (int i = 0; i < n; ++i) {
                Material mat = (Material)this.instance.materials.get(i);
                if (mat.has(FloatAttribute.BodySize)) {
                    ((FloatAttribute)Objects.requireNonNull(mat.get((int)FloatAttribute.BodySize))).value = (float)sizeInternal;
                    continue;
                }
                mat.set((Attribute)new FloatAttribute(FloatAttribute.BodySize, (float)sizeInternal));
            }
            this.sizeSet = true;
        }
    }

    public void setUnits(double kmToUnits) {
        int n = this.instance.materials.size;
        for (int i = 0; i < n; ++i) {
            Material mat = (Material)this.instance.materials.get(i);
            if (mat.has(FloatAttribute.KmToU)) {
                ((FloatAttribute)Objects.requireNonNull(mat.get((int)FloatAttribute.KmToU))).value = (float)kmToUnits;
                continue;
            }
            mat.set((Attribute)new FloatAttribute(FloatAttribute.KmToU, (float)kmToUnits));
        }
    }

    public void disableBlending() {
        int n = this.instance.materials.size;
        for (int i = 0; i < n; ++i) {
            BlendingAttribute ba;
            Material mat = (Material)this.instance.materials.get(i);
            if (mat.has(BlendingAttribute.Type)) {
                ba = (BlendingAttribute)mat.get(BlendingAttribute.Type);
            } else {
                ba = new BlendingAttribute(false, 1.0f);
                mat.set((Attribute)ba);
            }
            assert (ba != null);
            ba.blended = false;
        }
    }

    public void updateDepthTest() {
        switch (this.blendMode) {
            case ALPHA: 
            case COLOR: 
            case NONE: {
                this.depthTestReadWrite();
                break;
            }
            case ADDITIVE: {
                this.depthTestReadOnly();
            }
        }
    }

    public void depthTestReadOnly() {
        this.setDepthTest(515, false);
    }

    public void depthTestReadWrite() {
        this.setDepthTest(515, true);
    }

    public void depthTestDisable() {
        this.setDepthTest(0, false);
    }

    public void setDepthTest(int func, boolean mask) {
        if (this.instance != null) {
            int n = this.instance.materials.size;
            for (int i = 0; i < n; ++i) {
                DepthTestAttribute dta;
                Material mat = (Material)this.instance.materials.get(i);
                if (mat.has(DepthTestAttribute.Type)) {
                    dta = (DepthTestAttribute)mat.get(DepthTestAttribute.Type);
                } else {
                    dta = new DepthTestAttribute();
                    mat.set((Attribute)dta);
                }
                assert (dta != null);
                dta.depthFunc = func;
                dta.depthMask = mask;
            }
        }
    }

    public void setTransparency(float alpha) {
        switch (this.blendMode) {
            case ALPHA: {
                this.setTransparency(alpha, 770, 771, true);
                break;
            }
            case COLOR: {
                this.setTransparency(alpha, 1, 769, true);
                break;
            }
            case ADDITIVE: {
                this.setTransparency(alpha, 1, 1, true);
                break;
            }
            case NONE: {
                this.setTransparency(alpha, 1, 1, false);
            }
        }
    }

    public void setTransparencyColor(float alpha) {
        if (this.instance != null) {
            int n = this.instance.materials.size;
            for (int i = 0; i < n; ++i) {
                ((ColorAttribute)Objects.requireNonNull(((Material)this.instance.materials.get((int)i)).get((int)ColorAttribute.Diffuse))).color.a = alpha;
            }
        }
    }

    public void setFloatExtAttribute(int attrib, float value) {
        if (this.instance != null) {
            int n = this.instance.materials.size;
            for (int i = 0; i < n; ++i) {
                Material mat = (Material)this.instance.materials.get(i);
                this.setFloatAttribute(mat, attrib, value);
            }
        }
    }

    public void setIntAttribute(Material mat, int attribute, int value) {
        if (!mat.has(attribute)) {
            mat.set((Attribute)new IntAttribute(attribute, value));
        } else {
            ((IntAttribute)Objects.requireNonNull(mat.get((int)attribute))).value = value;
        }
    }

    public void setFloatAttribute(Material mat, int attribute, float value) {
        if (!mat.has(attribute)) {
            mat.set((Attribute)new FloatAttribute(attribute, value));
        } else {
            ((FloatAttribute)Objects.requireNonNull(mat.get((int)attribute))).value = value;
        }
    }

    public void setVector3Attribute(Material mat, int attribute, Vector3 value) {
        if (!mat.has(attribute)) {
            mat.set((Attribute)new Vector3Attribute(attribute, value));
        } else {
            ((Vector3Attribute)Objects.requireNonNull(mat.get((int)attribute))).value.set(value);
        }
    }

    public void setColorAttribute(int attrib, float[] rgba) {
        if (this.instance != null) {
            int n = this.instance.materials.size;
            for (int i = 0; i < n; ++i) {
                Material mat = (Material)this.instance.materials.get(i);
                if (!mat.has(attrib)) {
                    mat.set((Attribute)new ColorAttribute(attrib, new Color(rgba[0], rgba[1], rgba[2], rgba[3])));
                    continue;
                }
                ((ColorAttribute)Objects.requireNonNull(mat.get((int)attrib))).color.set(rgba[0], rgba[1], rgba[2], rgba[3]);
            }
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMaterial(MaterialComponent mtc) {
        this.mtc = mtc;
    }

    public void setModel(String model) {
        this.modelFile = model;
    }

    public void setStaticlight(String staticLight) {
        this.setStaticLight(staticLight);
    }

    public void setStaticlight(Boolean staticLight) {
        this.setStaticLight(staticLight);
    }

    public void setStaticlight(Double lightLevel) {
        this.setStaticLight(lightLevel);
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    public void setScale(Long scale) {
        this.scale = scale.longValue();
    }

    public void setCulling(String culling) {
        try {
            this.culling = Boolean.parseBoolean(culling);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCulling(Boolean culling) {
        this.culling = culling;
    }

    public void setUsecolor(String usecolor) {
        this.setUseColor(usecolor);
    }

    public void setUseColor(String useColor) {
        try {
            this.useColor = Boolean.parseBoolean(useColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUsecolor(Boolean usecolor) {
        this.setUseColor(usecolor);
    }

    public void setUseColor(Boolean useColor) {
        try {
            this.useColor = useColor;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public void setBlendMode(BlendMode blendMode) {
        if (blendMode != null) {
            this.blendMode = blendMode;
        }
    }

    public void setBlendMode(String blendModeString) {
        if (blendModeString != null && !blendModeString.isBlank()) {
            this.blendMode = BlendMode.valueOf(blendModeString.trim().toUpperCase(Locale.ROOT));
        }
    }

    public void setBlending(String blendModeString) {
        this.setBlendMode(blendModeString);
    }

    public void updateEclipsingBodyUniforms(Entity entity) {
        Base parentBase;
        Base base;
        if (!Settings.settings.scene.renderer.eclipses.active) {
            return;
        }
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        if (graph == null) {
            return;
        }
        Entity eclipsingBody = null;
        if (graph.children != null && !graph.children.isEmpty()) {
            for (Entity child : graph.children) {
                Base base2 = (Base)Mapper.base.get(child);
                if (!base2.hasCt(ComponentTypes.ComponentType.Moons)) continue;
                eclipsingBody = child;
                break;
            }
        }
        if (eclipsingBody == null && (base = (Base)Mapper.base.get(entity)).hasCt(ComponentTypes.ComponentType.Moons) && graph.parent != null && (parentBase = (Base)Mapper.base.get(graph.parent)).hasCt(ComponentTypes.ComponentType.Planets)) {
            eclipsingBody = graph.parent;
        }
        if (eclipsingBody != null) {
            for (Material mat : this.instance.materials) {
                this.updateEclipsingBodyUniforms(mat, eclipsingBody);
            }
        }
    }

    private void updateEclipsingBodyUniforms(Material mat, Entity eclipsingBody) {
        Body body = (Body)Mapper.body.get(eclipsingBody);
        GraphNode graph = (GraphNode)Mapper.graph.get(eclipsingBody);
        this.setVector3Attribute(mat, Vector3Attribute.EclipsingBodyPos, graph.translation.put(this.aux));
        this.setFloatAttribute(mat, FloatAttribute.EclipsingBodyRadius, (float)((double)body.size * 0.5));
        if (Settings.settings.scene.renderer.eclipses.outlines) {
            this.setIntAttribute(mat, IntAttribute.EclipseOutlines, 1);
        } else {
            mat.remove(IntAttribute.EclipseOutlines);
        }
    }

    private void removeEclipsingBodyUniforms() {
        if (this.instance == null) {
            return;
        }
        for (Material mat : this.instance.materials) {
            mat.remove(Vector3Attribute.EclipsingBodyPos);
            mat.remove(FloatAttribute.EclipsingBodyRadius);
            mat.remove(IntAttribute.EclipseOutlines);
        }
    }

    public void updateRelativisticEffects(ICamera camera) {
        this.updateRelativisticEffects(camera, -1.0f);
    }

    public void updateRelativisticEffects(ICamera camera, float vc) {
        for (Material mat : this.instance.materials) {
            this.updateRelativisticEffects(mat, camera, vc);
        }
    }

    public void updateRelativisticEffects(Material mat, ICamera camera) {
        this.updateRelativisticEffects(mat, camera, -1.0f);
    }

    public void updateRelativisticEffects(Material mat, ICamera camera, float vc) {
        if (Settings.settings.runtime.relativisticAberration) {
            this.rec.updateRelativisticEffectsMaterial(mat, camera, vc);
        } else if (this.rec.hasRelativisticEffects(mat)) {
            this.rec.removeRelativisticEffectsMaterial(mat);
        }
        if (Settings.settings.runtime.gravitationalWaves) {
            this.rec.updateGravitationalWavesMaterial(mat);
        } else if (this.rec.hasGravitationalWaves(mat)) {
            this.rec.removeGravitationalWavesMaterial(mat);
        }
    }

    public void addReflectionCubemapAttribute(Array<Material> materials) {
        for (Material mat : materials) {
            if (!mat.has(ColorAttribute.Metallic) && !mat.has(TextureAttribute.Metallic)) continue;
            MaterialComponent.reflectionCubemap.prepareCubemap(this.manager);
            mat.set((Attribute)new CubemapAttribute(CubemapAttribute.ReflectionCubemap, MaterialComponent.reflectionCubemap.cubemap));
        }
    }

    public void removeReflectionCubemapAttribute(Array<Material> materials) {
        for (Material mat : materials) {
            if (!mat.has(ColorAttribute.Metallic) && !mat.has(TextureAttribute.Metallic)) continue;
            mat.remove(CubemapAttribute.ReflectionCubemap);
        }
    }

    public boolean hasHeight() {
        return this.mtc != null && this.mtc.hasHeight();
    }

    public boolean isTessellated() {
        return this.tessellated && this.hasHeight();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        boolean active;
        if (event == Event.ECLIPSES_CMD && !(active = ((Boolean)data[0]).booleanValue())) {
            this.removeEclipsingBodyUniforms();
        }
    }

    public boolean isModelInitialised() {
        return this.modelInitialised;
    }

    public boolean isModelLoading() {
        return this.modelLoading;
    }

    public boolean isStaticLight() {
        return this.staticLight;
    }

    public void setStaticLight(String staticLight) {
        this.setStaticlight(Boolean.valueOf(staticLight));
    }

    public void setStaticLight(Boolean staticLight) {
        this.staticLight = staticLight;
        if (staticLight.booleanValue()) {
            this.setStaticLight(0.6);
        }
    }

    public void setStaticLight(Double lightLevel) {
        this.staticLight = true;
        this.ambientColor[0] = lightLevel.floatValue();
        this.ambientColor[1] = lightLevel.floatValue();
        this.ambientColor[2] = lightLevel.floatValue();
        this.ambientColor[3] = 1.0f;
    }

    public void setAmbientColor(double[] color) {
        this.ambientColor[0] = (float)color[0];
        this.ambientColor[1] = (float)color[1];
        this.ambientColor[2] = (float)color[2];
        this.ambientColor[3] = color.length > 3 ? (float)color[3] : 1.0f;
    }

    public void setAmbientLevel(Double level) {
        this.setAmbientColor(level);
    }

    public void setAmbientColor(Double level) {
        if (level >= 0.0) {
            this.ambientColor[0] = level.floatValue();
            this.ambientColor[1] = level.floatValue();
            this.ambientColor[2] = level.floatValue();
            this.ambientColor[3] = 1.0f;
        }
    }

    public void setPrimitiveType(int primitiveType) {
        this.primitiveType = primitiveType;
    }

    public void setPrimitiveType(String primitiveType) {
        this.primitiveType = PrimitiveComboBoxBean.Primitive.valueOf(primitiveType.toUpperCase(Locale.ROOT)).equals((Object)PrimitiveComboBoxBean.Primitive.LINES) ? 1 : 4;
    }

    public String toString() {
        return Objects.requireNonNullElseGet(this.modelFile, () -> "{" + this.type + ", params: " + (this.params != null ? this.params.toString() : "null") + "}");
    }

    public void randomizeAll(long seed, double size) {
        this.setType("sphere");
        this.setParams(this.createModelParameters(1000L, 1.0, false));
        MaterialComponent mtc = new MaterialComponent();
        Random rnd = new Random(seed);
        switch (rnd.nextInt(5)) {
            case 0: {
                mtc.randomizeAll(seed);
                break;
            }
            case 1: {
                mtc.randomizeEarthLike(seed);
                break;
            }
            case 2: {
                mtc.randomizeColdPlanet(seed);
                break;
            }
            case 3: {
                mtc.randomizeRockyPlanet(seed);
                break;
            }
            case 4: {
                mtc.randomizeGasGiant(seed);
            }
        }
        this.setMaterial(mtc);
    }

    public void print(Logger.Log log) {
        if (this.mtc != null) {
            this.mtc.print(log);
        }
    }

    @Override
    public void updateWith(ModelComponent object) {
        if (object.mtc != null) {
            if (this.mtc == null) {
                this.setMaterial(object.mtc);
            } else {
                this.mtc.updateWith(object.mtc);
            }
        }
    }

    public void updateCamPos(Vector3 cameraPos) {
        int n = this.instance.materials.size;
        for (int i = 0; i < n; ++i) {
            Material mat = (Material)this.instance.materials.get(i);
            if (mat.has(Vector3Attribute.CameraPos)) {
                ((Vector3Attribute)Objects.requireNonNull(mat.get((int)Vector3Attribute.CameraPos))).value.set(cameraPos);
                continue;
            }
            mat.set((Attribute)new Vector3Attribute(Vector3Attribute.CameraPos, new Vector3(cameraPos)));
        }
    }

    public void updateTimes(double sessionTime, double simuTime) {
        this.updateSessionTime(sessionTime);
        this.updateSimuTime(simuTime);
    }

    public void updateSessionTime(double t) {
        int n = this.instance.materials.size;
        for (int i = 0; i < n; ++i) {
            Material mat = (Material)this.instance.materials.get(i);
            if (mat.has(FloatAttribute.Time)) {
                ((FloatAttribute)Objects.requireNonNull(mat.get((int)FloatAttribute.Time))).value = (float)t;
                continue;
            }
            mat.set((Attribute)new FloatAttribute(FloatAttribute.Time, (float)t));
        }
    }

    public void updateSimuTime(double t) {
        int n = this.instance.materials.size;
        for (int i = 0; i < n; ++i) {
            Material mat = (Material)this.instance.materials.get(i);
            if (mat.has(FloatAttribute.SimuTime)) {
                ((FloatAttribute)Objects.requireNonNull(mat.get((int)FloatAttribute.SimuTime))).value = (float)t;
                continue;
            }
            mat.set((Attribute)new FloatAttribute(FloatAttribute.SimuTime, (float)t));
        }
    }

    static {
        Observer observer = new Observer(){

            @Override
            public void notify(Event event, Object source, Object ... data) {
                if (event == Event.AMBIENT_LIGHT_CMD) {
                    ModelComponent.setGlobalAmbientLight(((Float)data[0]).floatValue());
                }
            }
        };
        EventManager.instance.subscribe((IObserver)observer, Event.AMBIENT_LIGHT_CMD);
    }
}

