/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.utils.Disposable;
import gaiasky.scene.record.AtmosphereComponent;
import gaiasky.scene.record.CloudComponent;
import gaiasky.scene.record.IComponent;
import gaiasky.scene.record.MaterialComponent;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.record.NoiseComponent;
import gaiasky.scene.record.VirtualTextureComponent;
import gaiasky.util.math.MathUtilsDouble;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.jafama.FastMath;

public abstract sealed class NamedComponent
implements IComponent,
Disposable
permits AtmosphereComponent, CloudComponent, MaterialComponent, ModelComponent, NoiseComponent, VirtualTextureComponent {
    protected String name;

    @Override
    public void initialize(String name) {
        if (name != null) {
            this.name = name.toLowerCase(Locale.ROOT).replaceAll("\\s+", "_");
        }
    }

    protected Map<String, Object> createModelParameters(long quality, double diameter, boolean flip) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("quality", quality);
        params.put("diameter", diameter);
        params.put("flip", flip);
        return params;
    }

    protected double gaussian(Random rand, double mean, double sigma) {
        return rand.nextGaussian() * sigma + mean;
    }

    protected double gaussian(Random rand, double mean, double sigma, double min) {
        return FastMath.max((double)min, (double)(rand.nextGaussian() * sigma + mean));
    }

    protected double gaussian(Random rand, double mean, double sigma, double min, double max) {
        return MathUtilsDouble.clamp(rand.nextGaussian() * sigma + mean, min, max);
    }
}

