/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.postprocess.effects.Noise;
import gaiasky.render.postprocess.effects.SurfaceGen;
import gaiasky.render.postprocess.filters.NoiseFilter;
import gaiasky.scene.record.NamedComponent;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import net.jafama.FastMath;

public final class NoiseComponent
extends NamedComponent {
    public double[] scale = new double[]{1.0, 1.0, 1.0};
    public double power = 1.0;
    public int octaves = 4;
    public double amplitude = 1.0;
    public double persistence = 0.5;
    public double frequency = 2.34;
    public double lacunarity = 2.0;
    public double[] range = new double[]{0.0, 1.0};
    public NoiseFilter.NoiseType type = NoiseFilter.NoiseType.SIMPLEX;
    public float seed = 0.0f;
    public boolean turbulence = true;
    public boolean ridge = true;
    public int numTerraces = 0;
    public float terracesExp = 17.0f;
    public boolean genEmissiveMap = false;
    public FrameBuffer fbNoise;
    public FrameBuffer fbBiome;
    public FrameBuffer fbSurface;
    private static boolean DEBUG_UI_VIEW = false;

    private FrameBuffer createFrameBuffer(int N, int M, int numColorTargets) {
        GLFrameBuffer.FrameBufferBuilder builder = new GLFrameBuffer.FrameBufferBuilder(N, M);
        for (int i = 0; i < numColorTargets; ++i) {
            builder.addBasicColorTextureAttachment(Pixmap.Format.RGBA8888);
        }
        return builder.build();
    }

    private float toFloatSeed(long seed) {
        String s = Long.toString(seed);
        return (float)((double)seed / FastMath.pow((double)10.0, (double)s.length()));
    }

    private Noise getNoiseEffect(int N, int M, int channels, int targets) {
        Noise noise = new Noise(N, M, targets);
        noise.setScale(this.scale);
        noise.setType(this.type);
        noise.setSeed(this.seed);
        noise.setOctaves(this.octaves);
        noise.setAmplitude(this.amplitude);
        noise.setPersistence(this.persistence);
        noise.setFrequency(this.frequency);
        noise.setLacunarity(this.lacunarity);
        noise.setPower(this.power);
        noise.setRange((float)this.range[0], (float)this.range[1]);
        noise.setTurbulence(this.turbulence);
        noise.setRidge(this.ridge);
        noise.setNumTerraces(this.numTerraces);
        noise.setTerraceExp(this.terracesExp);
        noise.setChannels(channels);
        return noise;
    }

    public FrameBuffer generateNoise(int N, int M, int channels, int targets, float[] color) {
        this.fbNoise = this.fbNoise != null ? this.fbNoise : this.createFrameBuffer(N, M, targets);
        Noise noise = this.getNoiseEffect(N, M, channels, targets);
        noise.setColor(color);
        this.fbNoise.begin();
        noise.render(null, this.fbNoise);
        this.fbNoise.end();
        return this.fbNoise;
    }

    public synchronized FrameBuffer generateBiome(int N, int M) {
        this.fbBiome = this.fbBiome != null ? this.fbBiome : this.createFrameBuffer(N, M, this.genEmissiveMap ? 2 : 1);
        Noise biomeNoise = this.getNoiseEffect(N, M, 2, this.genEmissiveMap ? 2 : 1);
        this.fbBiome.begin();
        biomeNoise.render(null, this.fbBiome);
        this.fbBiome.end();
        return this.fbBiome;
    }

    public synchronized FrameBuffer generateSurface(int N, int M, String biomeLut, float biomeHueShift, float biomeSaturation, boolean generateNormalMap) {
        Texture lut = new Texture(Settings.settings.data.dataFileHandle(biomeLut));
        lut.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        this.fbSurface = this.fbSurface != null ? this.fbSurface : this.createFrameBuffer(N, M, generateNormalMap ? 3 : 2);
        SurfaceGen surfaceGen = new SurfaceGen(generateNormalMap, this.genEmissiveMap);
        surfaceGen.setLutTexture(lut);
        surfaceGen.setLutHueShift(biomeHueShift);
        surfaceGen.setLutSaturation(biomeSaturation);
        if (this.genEmissiveMap) {
            surfaceGen.setEmissiveTexture((Texture)this.fbBiome.getTextureAttachments().get(1));
        }
        this.fbSurface.begin();
        surfaceGen.render(this.fbBiome, this.fbSurface, null);
        this.fbSurface.end();
        if (DEBUG_UI_VIEW) {
            EventManager.publish(Event.SHOW_TEXTURE_WINDOW_ACTION, this, "Biome", this.fbBiome.getColorBufferTexture(), Float.valueOf(1.0f));
            EventManager.publish(Event.SHOW_TEXTURE_WINDOW_ACTION, this, "Diffuse", this.fbSurface.getColorBufferTexture(), Float.valueOf(1.0f));
            EventManager.publish(Event.SHOW_TEXTURE_WINDOW_ACTION, this, "Specular", this.fbSurface.getTextureAttachments().get(1), Float.valueOf(1.0f));
            if (generateNormalMap) {
                EventManager.publish(Event.SHOW_TEXTURE_WINDOW_ACTION, this, "Normal", this.fbSurface.getTextureAttachments().get(2), Float.valueOf(1.0f));
            }
            DEBUG_UI_VIEW = false;
        }
        return this.fbSurface;
    }

    public void setType(String noiseType) {
        try {
            this.type = NoiseFilter.NoiseType.valueOf(noiseType.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            this.type = NoiseFilter.NoiseType.SIMPLEX;
        }
    }

    public void setFractalType(String ignoredFractalType) {
    }

    public void setFractaltype(String fractalType) {
        this.setFractalType(fractalType);
    }

    public void setScale(Double scale) {
        this.scale[0] = scale;
        this.scale[1] = scale;
        this.scale[2] = scale;
    }

    public void setScale(double[] noiseScale) {
        this.scale = noiseScale;
    }

    public void setOctaves(Long octaves) {
        this.octaves = FastMath.min((int)9, (int)octaves.intValue());
    }

    public void setAmplitude(Double amplitude) {
        this.amplitude = amplitude;
    }

    public void setPersistence(Double persistence) {
        this.persistence = persistence;
    }

    public void setFrequency(Double frequency) {
        this.frequency = frequency;
    }

    public void setLacunarity(Double lacunarity) {
        this.lacunarity = lacunarity;
    }

    public void setPower(Double power) {
        this.power = power;
    }

    public void setNumTerraces(Long numTerraces) {
        this.numTerraces = numTerraces.intValue();
    }

    public void setTerracesExp(Double terracesExp) {
        this.terracesExp = terracesExp.floatValue();
    }

    public void setTerraceSmoothness(Double terracesExp) {
        this.setTerracesExp(terracesExp);
    }

    public void setRange(double[] range) {
        this.range = range;
    }

    public void setSeed(Long seed) {
        this.seed = this.toFloatSeed(seed);
    }

    public void setSeed(Double seed) {
        this.seed = seed.floatValue();
    }

    public void setTurbulence(Boolean t) {
        this.turbulence = t;
    }

    public void setRidge(Boolean t) {
        this.ridge = t;
    }

    public void copyFrom(NoiseComponent other) {
        this.seed = other.seed;
        this.scale = Arrays.copyOf(other.scale, other.scale.length);
        this.type = other.type;
        this.amplitude = other.amplitude;
        this.persistence = other.persistence;
        this.frequency = other.frequency;
        this.lacunarity = other.lacunarity;
        this.octaves = other.octaves;
        this.numTerraces = other.numTerraces;
        this.terracesExp = other.terracesExp;
        this.range = Arrays.copyOf(other.range, other.range.length);
        this.power = other.power;
        this.turbulence = other.turbulence;
        this.ridge = other.ridge;
        this.genEmissiveMap = other.genEmissiveMap;
    }

    public void randomizeAll(Random rand) {
        this.randomizeAll(rand, false);
    }

    public void randomizeAll(Random rand, boolean clouds) {
        this.setSeed(rand.nextDouble(2.0));
        if (clouds) {
            d = rand.nextInt(3);
            d = d == 2 ? 3 : d;
            this.setType(NoiseFilter.NoiseType.values()[d].name());
        } else {
            d = rand.nextInt(3);
            this.setType(NoiseFilter.NoiseType.values()[d].name());
        }
        double scaleFac = this.type == NoiseFilter.NoiseType.CURL ? 2.5 : 1.0;
        double baseSize = FastMath.abs((double)this.gaussian(rand, 4.0, 1.0, 0.5));
        if (clouds) {
            double xyScale = this.gaussian(rand, 5.0, 4.0, 3.0);
            this.setScale(new double[]{FastMath.abs((double)xyScale), FastMath.abs((double)xyScale), FastMath.abs((double)this.gaussian(rand, 11.0, 2.0, xyScale + 2.0))});
        } else if (rand.nextBoolean()) {
            this.setScale(baseSize);
        } else {
            this.setScale(new double[]{baseSize + rand.nextDouble() * 0.5, baseSize + rand.nextDouble() * 0.5, baseSize + 0.4 * rand.nextDouble()});
        }
        this.scale[0] = this.scale[0] * scaleFac;
        this.scale[1] = this.scale[1] * scaleFac;
        this.scale[2] = this.scale[2] * scaleFac;
        this.setAmplitude(this.gaussian(rand, 1.0, 0.3, 0.8, 1.2));
        this.setPersistence(this.gaussian(rand, 0.5, 0.07, 0.3));
        if (clouds) {
            this.setFrequency(this.gaussian(rand, 1.0, 2.0, 0.6));
        } else {
            this.setFrequency(this.gaussian(rand, 0.5, 2.0, 0.01));
        }
        this.setLacunarity(this.gaussian(rand, 2.0, 2.0, 1.5));
        if (this.type == NoiseFilter.NoiseType.VORONOI) {
            this.setOctaves(Long.valueOf(rand.nextInt(1, 3)));
        } else if (clouds) {
            this.setOctaves(rand.nextLong(4L, 9L));
        } else {
            this.setOctaves(rand.nextLong(1L, 9L));
        }
        if (!clouds && rand.nextBoolean()) {
            this.setNumTerraces(rand.nextLong(3L, 7L));
            this.setTerracesExp((double)rand.nextLong(1L, 13L) * 2.0 - 1.0);
        } else {
            this.setNumTerraces(0L);
        }
        if (clouds) {
            minRange = this.gaussian(rand, 0.0, 0.2, -0.2);
            double maxRange = FastMath.abs((double)rand.nextDouble(0.7, 1.7));
            this.setRange(new double[]{minRange, maxRange});
        } else {
            minRange = this.gaussian(rand, 0.0, 0.3);
            double maxRange = 0.5 + FastMath.abs((double)rand.nextDouble());
            this.setRange(new double[]{minRange, maxRange});
        }
        if (clouds) {
            this.setPower(this.gaussian(rand, 1.0, 1.0, 0.5));
        } else {
            this.setPower(this.gaussian(rand, 2.0, 2.0, 0.2));
        }
        this.setTurbulence(rand.nextInt(4) == 3);
        this.setRidge(this.turbulence ? rand.nextBoolean() : false);
        this.genEmissiveMap = rand.nextInt(10) == 9;
    }

    public void randomizeRockyPlanet(Random rand) {
        this.setSeed(rand.nextDouble(2.0));
        this.setType(NoiseFilter.NoiseType.values()[rand.nextInt(4)].name());
        double scale = rand.nextDouble(8.0, 15.0);
        this.setScale(new double[]{scale, scale, scale});
        this.setAmplitude(this.gaussian(rand, 1.0, 0.3, 0.8, 1.2));
        this.setPersistence(rand.nextDouble(0.4, 0.6));
        this.setFrequency(rand.nextDouble(0.01, 0.6));
        this.setLacunarity(rand.nextDouble(3.0, 5.0));
        this.setOctaves(Long.valueOf(rand.nextInt(4, 9)));
        if (rand.nextBoolean()) {
            this.setNumTerraces(rand.nextLong(3L, 7L));
            this.setTerracesExp((double)rand.nextLong(1L, 13L) * 2.0 - 1.0);
        } else {
            this.setNumTerraces(0L);
        }
        this.setRange(new double[]{rand.nextDouble(0.1, 0.3), rand.nextDouble(0.7, 2.0)});
        this.setPower(rand.nextDouble(0.5, 1.1));
        this.setTurbulence(rand.nextInt(4) == 3);
        this.setRidge(this.turbulence ? rand.nextInt(3) < 2 : false);
        this.genEmissiveMap = rand.nextInt(20) == 19;
    }

    public void randomizeEarthLike(Random rand) {
        this.setSeed(rand.nextDouble(2.0));
        this.setType(NoiseFilter.NoiseType.values()[rand.nextInt(4)].name());
        double scale = rand.nextDouble(3.0, 8.0);
        this.setScale(new double[]{scale, scale, scale});
        this.setAmplitude(this.gaussian(rand, 1.0, 0.3, 0.8, 1.0));
        this.setPersistence(rand.nextDouble(0.2, 0.5));
        this.setFrequency(rand.nextDouble(0.01, 0.35));
        this.setLacunarity(rand.nextDouble(3.0, 5.0));
        this.setOctaves(Long.valueOf(rand.nextInt(5, 9)));
        if (rand.nextBoolean()) {
            this.setNumTerraces(rand.nextLong(3L, 7L));
            this.setTerracesExp((double)rand.nextLong(1L, 13L) * 2.0 - 1.0);
        } else {
            this.setNumTerraces(0L);
        }
        this.setRange(new double[]{rand.nextDouble(-0.5, 0.0), rand.nextDouble(0.8, 1.5)});
        this.setPower(rand.nextDouble(0.5, 1.6));
        this.setTurbulence(rand.nextInt(4) == 3);
        this.setRidge(this.turbulence ? rand.nextInt(4) < 3 : false);
        this.genEmissiveMap = rand.nextInt(4) == 3;
    }

    public void randomizeSnowPlanet(Random rand) {
        this.setSeed(rand.nextDouble(2.0));
        this.setType(NoiseFilter.NoiseType.values()[rand.nextInt(4)].name());
        double scale = rand.nextDouble(4.0, 8.0);
        this.setScale(new double[]{scale, scale, scale});
        this.setAmplitude(this.gaussian(rand, 1.0, 0.3, 0.8, 1.0));
        this.setPersistence(rand.nextDouble(0.2, 0.5));
        this.setFrequency(rand.nextDouble(0.2, 0.65));
        this.setLacunarity(rand.nextDouble(2.0, 5.0));
        this.setOctaves(Long.valueOf(rand.nextInt(3, 8)));
        if (rand.nextInt(5) == 4) {
            this.setNumTerraces(rand.nextLong(3L, 7L));
            this.setTerracesExp((double)rand.nextLong(1L, 13L) * 2.0 - 1.0);
        } else {
            this.setNumTerraces(0L);
        }
        this.setRange(new double[]{rand.nextDouble(-0.4, 0.0), rand.nextDouble(1.0, 1.5)});
        this.setPower(rand.nextDouble(0.5, 1.8));
        this.setTurbulence(rand.nextInt(4) == 3);
        this.setRidge(this.turbulence ? rand.nextInt(4) < 3 : false);
        this.genEmissiveMap = rand.nextInt(15) == 14;
    }

    public void randomizeGasGiant(Random rand) {
        this.setSeed(rand.nextDouble(2.0));
        if (rand.nextInt(20) < 17) {
            int d = rand.nextInt(3);
            d = d == 2 ? 3 : d;
            this.setType(NoiseFilter.NoiseType.values()[d].name());
        } else {
            this.setType(NoiseFilter.NoiseType.VORONOI.name());
        }
        double scaleFac = this.type == NoiseFilter.NoiseType.CURL ? 2.5 : 1.0;
        this.setScale(new double[]{FastMath.abs((double)this.gaussian(rand, 1.0, 1.0, 0.2)), FastMath.abs((double)this.gaussian(rand, 1.0, 1.0, 0.2)), FastMath.abs((double)this.gaussian(rand, 7.0, 2.0, 5.0))});
        this.scale[0] = this.scale[0] * scaleFac;
        this.scale[1] = this.scale[1] * scaleFac;
        this.scale[2] = this.scale[2] * scaleFac;
        this.setAmplitude(this.gaussian(rand, 1.0, 0.3, 0.8, 1.2));
        this.setPersistence(rand.nextDouble(0.4, 0.6));
        this.setFrequency(rand.nextDouble(0.5, 3.0));
        this.setLacunarity(rand.nextDouble(0.1, 3.0));
        this.setOctaves(Long.valueOf(rand.nextInt(1, 4)));
        this.setNumTerraces(0L);
        this.setRange(new double[]{0.4, rand.nextDouble(0.9, 1.3)});
        this.setPower(0.1);
        this.setTurbulence(rand.nextInt(4) == 3);
        this.setRidge(this.turbulence ? rand.nextBoolean() : false);
        this.genEmissiveMap = rand.nextInt(10) == 9;
    }

    public void print(Logger.Log log) {
        log.debug("Seed: " + this.seed);
        log.debug("Scale: " + Arrays.toString(this.scale));
        log.debug("Noise type: " + String.valueOf((Object)this.type));
        log.debug("Amplitude: " + this.amplitude);
        log.debug("Persistence: " + this.persistence);
        log.debug("Frequency: " + this.frequency);
        log.debug("Lacunarity: " + this.lacunarity);
        log.debug("Octaves: " + this.octaves);
        log.debug("Terraces: " + this.numTerraces);
        log.debug("Terraces exponent: " + this.terracesExp);
        log.debug("Range: " + Arrays.toString(this.range));
        log.debug("Power: " + this.power);
        log.debug("Turbulence: " + this.turbulence);
        log.debug("Ridge: " + this.ridge);
        log.debug("Emission: " + this.genEmissiveMap);
    }

    public void dispose() {
        if (this.fbSurface != null) {
            this.fbSurface.dispose();
            this.fbSurface = null;
        }
        if (this.fbBiome != null) {
            this.fbBiome.dispose();
            this.fbBiome = null;
        }
        if (this.fbNoise != null) {
            this.fbNoise.dispose();
            this.fbNoise = null;
        }
    }
}

