/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.math.Matrix3D;
import gaiasky.util.math.Vector3D;
import java.time.Instant;
import java.util.Objects;
import net.jafama.FastMath;

public class OrbitComponent {
    protected static final Logger.Log logger = Logger.getLogger(OrbitComponent.class);
    public String source;
    public double period;
    public double epoch;
    public double semiMajorAxis;
    public double e;
    public double i;
    public double ascendingNode;
    public double argOfPericenter;
    public double meanAnomaly;
    public double mu = 1.32712440041E11;
    private boolean externalMu = false;
    private final Matrix3D Rx = new Matrix3D();
    private final Vector3D vAux = new Vector3D();

    public void setSource(String source) {
        this.source = source;
    }

    public void setPeriod(Double period) {
        this.period = period;
    }

    public void setEpoch(Double epoch) {
        this.epoch = epoch;
    }

    public void setSemiMajorAxis(Double semiMajorAxis) {
        this.semiMajorAxis = semiMajorAxis;
    }

    public void setSemimajoraxis(Double setmiMajorAxis) {
        this.setSemiMajorAxis(setmiMajorAxis);
    }

    public void setEccentricity(Double e) {
        this.e = e;
    }

    public void setInclination(Double i) {
        this.i = i;
    }

    public void setAscendingNode(Double ascendingNode) {
        this.ascendingNode = ascendingNode;
    }

    public void setAscendingnode(Double ascendingNode) {
        this.setAscendingNode(ascendingNode);
    }

    public void setArgOfPericenter(Double argOfPericenter) {
        this.argOfPericenter = argOfPericenter;
    }

    public void setArgofpericenter(Double argOfPericenter) {
        this.setArgOfPericenter(argOfPericenter);
    }

    public void setMeanAnomaly(Double meanAnomaly) {
        this.meanAnomaly = meanAnomaly;
    }

    public void setMeananomaly(Double meanAnomaly) {
        this.setMeanAnomaly(meanAnomaly);
    }

    public void computeMu(boolean km3s2) {
        if (this.period > 0.0 && this.semiMajorAxis > 0.0 && !this.externalMu) {
            double a = this.semiMajorAxis;
            double T = this.period * 86400.0;
            this.mu = 39.47841760435743 * a * a * a / (T * T);
            if (!km3s2) {
                this.mu *= 1.0E9;
            }
        }
    }

    public void setMu(Double mu) {
        this.mu = mu;
        this.externalMu = true;
    }

    public void loadDataPoint(Vector3D out, Instant t) {
        double tjd = AstroUtils.getJulianDate(t);
        this.keplerianToCartesianTime(out, tjd - this.epoch);
    }

    public void loadDataPoint(Vector3D out, double dtDays) {
        this.keplerianToCartesianTime(out, dtDays);
    }

    public double getMeanAnomalyAt(double dtDays) {
        double n = Math.PI * 2 / this.period;
        double M0 = FastMath.toRadians((double)this.meanAnomaly);
        double M = (M0 + n * dtDays) % (Math.PI * 2);
        if (M < 0.0) {
            M += Math.PI * 2;
        }
        return M;
    }

    public double getTrueAnomaly(double E) {
        return 2.0 * FastMath.atan2((double)(FastMath.sqrt((double)(1.0 + this.e)) * FastMath.sin((double)(E / 2.0))), (double)(FastMath.sqrt((double)(1.0 - this.e)) * FastMath.cos((double)(E / 2.0))));
    }

    public double solveKepler(double M, double e) {
        double E = e < 0.8 ? M : Math.PI;
        for (int i = 0; i < 100; ++i) {
            double f = E - e * FastMath.sin((double)E) - M;
            double fPrime = 1.0 - e * FastMath.cos((double)E);
            double dE = -f / fPrime;
            E += dE;
            if (FastMath.abs((double)dE) < 1.0E-10) break;
        }
        return E;
    }

    public double trueAnomalyToTime(double nuRad) {
        double n = Math.PI * 2 / this.period;
        double tanHalfNu = FastMath.tan((double)(nuRad / 2.0));
        double sqrtFactor = FastMath.sqrt((double)((1.0 - this.e) / (1.0 + this.e)));
        double E = 2.0 * FastMath.atan2((double)(tanHalfNu * sqrtFactor), (double)1.0);
        E = (E + Math.PI * 2) % (Math.PI * 2);
        double M = E - this.e * FastMath.sin((double)E);
        double M0 = FastMath.toRadians((double)this.meanAnomaly);
        return (M - M0) / n;
    }

    public double timeToTrueAnomaly(double dtDays) {
        double M = this.getMeanAnomalyAt(dtDays);
        double E = this.solveKepler(M, this.e);
        return this.getTrueAnomaly(E);
    }

    public void keplerianToCartesianTime(Vector3D out, double dtDays) {
        this.computeMu(true);
        double inc = FastMath.toRadians((double)this.i);
        double ascNode = FastMath.toRadians((double)this.ascendingNode);
        double argP = FastMath.toRadians((double)this.argOfPericenter);
        double M = this.getMeanAnomalyAt(dtDays);
        double E = this.solveKepler(M, this.e);
        double nu = this.getTrueAnomaly(E);
        double r = this.semiMajorAxis * (1.0 - this.e * FastMath.cos((double)E));
        double xPf = r * FastMath.cos((double)nu);
        double yPf = r * FastMath.sin((double)nu);
        double zPf = 0.0;
        double cosO = FastMath.cos((double)ascNode);
        double sinO = FastMath.sin((double)ascNode);
        double cosI = FastMath.cos((double)inc);
        double sinI = FastMath.sin((double)inc);
        double cosW = FastMath.cos((double)argP);
        double sinW = FastMath.sin((double)argP);
        this.Rx.val[0] = cosO * cosW - sinO * sinW * cosI;
        this.Rx.val[3] = -cosO * sinW - sinO * cosW * cosI;
        this.Rx.val[6] = sinO * sinI;
        this.Rx.val[1] = sinO * cosW + cosO * sinW * cosI;
        this.Rx.val[4] = -sinO * sinW + cosO * cosW * cosI;
        this.Rx.val[7] = -cosO * sinI;
        this.Rx.val[2] = sinW * sinI;
        this.Rx.val[5] = cosW * sinI;
        this.Rx.val[8] = cosI;
        this.vAux.set(xPf, yPf, zPf);
        this.vAux.mul(this.Rx);
        out.set(this.vAux.y, this.vAux.z, this.vAux.x).scl(Constants.KM_TO_U);
    }

    public void keplerianToCartesianNu(Vector3D out, double nu) {
        this.computeMu(true);
        double inc = FastMath.toRadians((double)this.i);
        double ascNode = FastMath.toRadians((double)this.ascendingNode);
        double argP = FastMath.toRadians((double)this.argOfPericenter);
        double r = this.semiMajorAxis * (1.0 - this.e * this.e) / (1.0 + this.e * FastMath.cos((double)nu));
        double xPf = r * FastMath.cos((double)nu);
        double yPf = r * FastMath.sin((double)nu);
        double zPf = 0.0;
        double cosO = FastMath.cos((double)ascNode);
        double sinO = FastMath.sin((double)ascNode);
        double cosI = FastMath.cos((double)inc);
        double sinI = FastMath.sin((double)inc);
        double cosW = FastMath.cos((double)argP);
        double sinW = FastMath.sin((double)argP);
        this.Rx.val[0] = cosO * cosW - sinO * sinW * cosI;
        this.Rx.val[3] = -cosO * sinW - sinO * cosW * cosI;
        this.Rx.val[6] = sinO * sinI;
        this.Rx.val[1] = sinO * cosW + cosO * sinW * cosI;
        this.Rx.val[4] = -sinO * sinW + cosO * cosW * cosI;
        this.Rx.val[7] = -cosO * sinI;
        this.Rx.val[2] = sinW * sinI;
        this.Rx.val[5] = cosW * sinI;
        this.Rx.val[8] = cosI;
        this.vAux.set(xPf, yPf, zPf);
        this.vAux.mul(this.Rx);
        out.set(this.vAux.y, this.vAux.z, this.vAux.x).scl(Constants.KM_TO_U);
    }

    public void loadDataPointNu(Vector3D out, double nu) {
        this.keplerianToCartesianNu(out, nu);
    }

    @Deprecated
    public void loadDataPointReneSchwarz(Vector3D out, double dtDays) {
        double M;
        this.computeMu(false);
        double a = this.semiMajorAxis * 1000.0;
        double M0 = this.meanAnomaly * (Math.PI / 180);
        double omega_lan = this.ascendingNode * (Math.PI / 180);
        double omega_ap = this.argOfPericenter * (Math.PI / 180);
        double ic = this.i * (Math.PI / 180);
        double dt = dtDays * 86400.0;
        double E = M = M0 + dt * FastMath.sqrt((double)(this.mu / FastMath.pow((double)a, (double)3.0)));
        for (int j = 0; j < 2; ++j) {
            E -= (E - this.e * FastMath.sin((double)E) - M) / (1.0 - this.e * FastMath.cos((double)E));
        }
        double E_t = E;
        double nu_t = 2.0 * FastMath.atan2((double)(FastMath.sqrt((double)(1.0 + this.e)) * FastMath.sin((double)(E_t / 2.0))), (double)(FastMath.sqrt((double)(1.0 - this.e)) * FastMath.cos((double)(E_t / 2.0))));
        double rc_t = a * (1.0 - this.e * FastMath.cos((double)E_t));
        double ox = rc_t * FastMath.cos((double)nu_t);
        double oy = rc_t * FastMath.sin((double)nu_t);
        double sinomega = FastMath.sin((double)omega_ap);
        double cosomega = FastMath.cos((double)omega_ap);
        double sinOMEGA = FastMath.sin((double)omega_lan);
        double cosOMEGA = FastMath.cos((double)omega_lan);
        double cosi = FastMath.cos((double)ic);
        double sini = FastMath.sin((double)ic);
        double x = ox * (cosomega * cosOMEGA - sinomega * cosi * sinOMEGA) - oy * (sinomega * cosOMEGA + cosomega * cosi * sinOMEGA);
        double y = ox * (cosomega * sinOMEGA + sinomega * cosi * cosOMEGA) + oy * (cosomega * cosi * cosOMEGA - sinomega * sinOMEGA);
        double z = ox * (sinomega * sini) + oy * (cosomega * sini);
        out.set(y *= Constants.M_TO_U, z *= Constants.M_TO_U, x *= Constants.M_TO_U);
    }

    public String toString() {
        String desc = Objects.requireNonNullElseGet(this.source, () -> "{epoch: " + this.epoch + ", period: " + this.period + ", e: " + this.e + ", i: " + this.i + ", sma: " + this.semiMajorAxis + "}");
        return desc;
    }
}

