/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.record.ParticleType;
import gaiasky.util.Constants;
import gaiasky.util.TLV3D;
import gaiasky.util.TextUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Vector3D;
import gaiasky.util.ucd.UCD;
import net.jafama.FastMath;

public record Particle(long id, String[] names, double x, double y, double z, ObjectMap<UCD, Object> extra) implements IParticleRecord
{
    private static final TLV3D aux3d1 = new TLV3D();
    private static final TLV3D aux3d2 = new TLV3D();

    public Particle(long id, String[] names, double x, double y, double z) {
        this(id, names, x, y, z, null);
    }

    @Override
    public ParticleType getType() {
        return ParticleType.PARTICLE;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public int nVari() {
        return -1;
    }

    @Override
    public double period() {
        return -1.0;
    }

    @Override
    public float[] variMags() {
        return new float[0];
    }

    @Override
    public double[] variTimes() {
        return new double[0];
    }

    @Override
    public Vector3D pos(Vector3D aux) {
        return aux.set(this.x(), this.y(), this.z());
    }

    @Override
    public boolean hasProperMotion() {
        return false;
    }

    @Override
    public float vx() {
        return Float.NaN;
    }

    @Override
    public float vy() {
        return Float.NaN;
    }

    @Override
    public float vz() {
        return Float.NaN;
    }

    @Override
    public String namesConcat() {
        return TextUtils.concatenate("|", this.names);
    }

    @Override
    public boolean hasName(String candidate) {
        return this.hasName(candidate, false);
    }

    @Override
    public boolean hasName(String candidate, boolean matchCase) {
        if (this.names == null) {
            return false;
        }
        for (String name : this.names) {
            if (!(matchCase ? name.equals(candidate) : name.equalsIgnoreCase(candidate))) continue;
            return true;
        }
        return false;
    }

    @Override
    public double distance() {
        return FastMath.sqrt((double)(this.x() * this.x() + this.y() * this.y() + this.z() * this.z()));
    }

    @Override
    public double parallax() {
        return 1000.0 / (this.distance() * Constants.U_TO_PC);
    }

    @Override
    public double ra() {
        Vector3D cartPos = this.pos((Vector3D)aux3d1.get());
        Vector3D sphPos = Coordinates.cartesianToSpherical(cartPos, (Vector3D)aux3d2.get());
        return 57.29577951308232 * sphPos.x;
    }

    @Override
    public double dec() {
        Vector3D cartPos = this.pos((Vector3D)aux3d1.get());
        Vector3D sphPos = Coordinates.cartesianToSpherical(cartPos, (Vector3D)aux3d2.get());
        return 57.29577951308232 * sphPos.y;
    }

    @Override
    public double lambda() {
        Vector3D cartEclPos = this.pos((Vector3D)aux3d1.get()).mul(Coordinates.eqToEcl());
        Vector3D sphPos = Coordinates.cartesianToSpherical(cartEclPos, (Vector3D)aux3d2.get());
        return 57.29577951308232 * sphPos.x;
    }

    @Override
    public double beta() {
        Vector3D cartEclPos = this.pos((Vector3D)aux3d1.get()).mul(Coordinates.eqToEcl());
        Vector3D sphPos = Coordinates.cartesianToSpherical(cartEclPos, (Vector3D)aux3d2.get());
        return 57.29577951308232 * sphPos.y;
    }

    @Override
    public double l() {
        Vector3D cartEclPos = this.pos((Vector3D)aux3d1.get()).mul(Coordinates.eqToGal());
        Vector3D sphPos = Coordinates.cartesianToSpherical(cartEclPos, (Vector3D)aux3d2.get());
        return 57.29577951308232 * sphPos.x;
    }

    @Override
    public double b() {
        Vector3D cartEclPos = this.pos((Vector3D)aux3d1.get()).mul(Coordinates.eqToGal());
        Vector3D sphPos = Coordinates.cartesianToSpherical(cartEclPos, (Vector3D)aux3d2.get());
        return 57.29577951308232 * sphPos.y;
    }

    @Override
    public void setExtraAttributes(ObjectMap<UCD, Object> e) {
        this.extra.clear();
        this.extra.putAll(e);
    }

    @Override
    public boolean hasExtra() {
        return this.extra != null;
    }

    @Override
    public boolean hasExtra(String name) {
        if (this.extra != null) {
            ObjectMap.Keys ucds = this.extra.keys();
            for (UCD ucd : ucds) {
                if ((ucd.originalUCD == null || !ucd.originalUCD.equals(name)) && (ucd.colName == null || !ucd.colName.equals(name))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasExtra(UCD ucd) {
        return this.extra != null && this.extra.containsKey((Object)ucd);
    }

    @Override
    public ObjectMap<UCD, Object> getExtra() {
        return this.extra;
    }

    @Override
    public Object getExtra(String name) {
        if (this.extra != null) {
            ObjectMap.Keys ucds = this.extra.keys();
            for (UCD ucd : ucds) {
                if ((ucd.originalUCD == null || !ucd.originalUCD.equals(name)) && (ucd.colName == null || !ucd.colName.equals(name))) continue;
                return this.extra.get((Object)ucd);
            }
        }
        return null;
    }

    @Override
    public Object getExtra(UCD ucd) {
        if (this.hasExtra(ucd)) {
            return this.extra.get((Object)ucd);
        }
        return null;
    }

    @Override
    public double getExtraNumber(String name) {
        Object value = this.getExtra(name);
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        return Double.NaN;
    }

    @Override
    public double getExtraNumber(UCD ucd) {
        Object value = this.getExtra(ucd);
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        return Double.NaN;
    }

    @Override
    public ObjectMap.Keys<UCD> extraKeys() {
        return this.extra.keys();
    }

    @Override
    public float appMag() {
        return Float.NaN;
    }

    @Override
    public float absMag() {
        return Float.NaN;
    }

    @Override
    public boolean hasColor() {
        return false;
    }

    @Override
    public float color() {
        return Float.NaN;
    }

    @Override
    public double[] rgb() {
        return new double[0];
    }

    @Override
    public boolean hasSize() {
        return false;
    }

    @Override
    public float size() {
        return Float.NaN;
    }

    @Override
    public double radius() {
        return Double.NaN;
    }

    @Override
    public int hip() {
        return -1;
    }

    @Override
    public float muAlpha() {
        return Float.NaN;
    }

    @Override
    public float muDelta() {
        return Float.NaN;
    }

    @Override
    public float radVel() {
        return Float.NaN;
    }

    @Override
    public float tEff() {
        return Float.NaN;
    }
}

