/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import gaiasky.scene.record.ITransform;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;

public class QuaternionTransform
implements ITransform {
    QuaternionDouble quaternion;
    Quaternion quatFloat;

    @Override
    public void apply(Matrix4 mat) {
        if (this.quaternion != null) {
            if (this.quatFloat == null) {
                this.quatFloat = new Quaternion();
            }
            this.quatFloat.set((float)this.quaternion.x, (float)this.quaternion.y, (float)this.quaternion.z, (float)this.quaternion.w);
            mat.rotate(this.quatFloat);
        }
    }

    @Override
    public void apply(Matrix4D mat) {
        if (this.quaternion != null) {
            mat.rotate(this.quaternion);
        }
    }

    public void setQuaternion(QuaternionDouble quaternion) {
        this.quaternion = new QuaternionDouble(quaternion);
    }

    public void setQuaternion(Vector3D axis, double angle) {
        this.quaternion = new QuaternionDouble(axis, angle);
    }

    public void setQuaternion(double axisX, double axisY, double axisZ, double angle) {
        this.quaternion = new QuaternionDouble(new Vector3D(axisX, axisY, axisZ), angle);
    }

    public void setQuaternion(double[] xyzw) {
        this.quaternion = new QuaternionDouble(xyzw[0], xyzw[1], xyzw[2], xyzw[3]);
    }

    @Override
    public ITransform copy() {
        QuaternionTransform c = new QuaternionTransform();
        if (this.quaternion != null) {
            c.quaternion = new QuaternionDouble(this.quaternion);
        }
        if (this.quatFloat != null) {
            c.quatFloat = new Quaternion(this.quatFloat);
        }
        return c;
    }
}

