/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.Matrix3Attribute;
import gaiasky.util.gdx.shader.attribute.Vector3Attribute;
import gaiasky.util.gdx.shader.attribute.Vector4Attribute;
import gaiasky.util.gravwaves.RelativisticEffectsManager;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RelativisticEffectsComponent {
    public void doneLoading(Map<String, Material> materials) {
        Set<String> keys = materials.keySet();
        for (String key : keys) {
            Material mat = materials.get(key);
            this.setUpRelativisticEffectsMaterial(mat);
            this.setUpGravitationalWavesMaterial(mat);
        }
    }

    public void doneLoading(Material mat) {
        this.setUpRelativisticEffectsMaterial(mat);
        this.setUpGravitationalWavesMaterial(mat);
    }

    public void setUpRelativisticEffectsMaterial(Array<Material> materials) {
        for (Material material : materials) {
            this.setUpRelativisticEffectsMaterial(material);
        }
    }

    public void setUpRelativisticEffectsMaterial(Material mat) {
        mat.set((Attribute)new FloatAttribute(FloatAttribute.Vc, 0.0f));
        mat.set((Attribute)new Vector3Attribute(Vector3Attribute.VelDir, new Vector3()));
    }

    public void removeRelativisticEffectsMaterial(Array<Material> materials) {
        for (Material material : materials) {
            this.removeRelativisticEffectsMaterial(material);
        }
    }

    public void removeRelativisticEffectsMaterial(Material mat) {
        mat.remove(FloatAttribute.Vc);
        mat.remove(Vector3Attribute.VelDir);
    }

    public void setUpGravitationalWavesMaterial(Array<Material> materials) {
        for (Material material : materials) {
            this.setUpGravitationalWavesMaterial(material);
        }
    }

    public void setUpGravitationalWavesMaterial(Material mat) {
    }

    public void removeGravitationalWavesMaterial(Array<Material> materials) {
        for (Material material : materials) {
            this.removeGravitationalWavesMaterial(material);
        }
    }

    public void removeGravitationalWavesMaterial(Material mat) {
    }

    public void updateRelativisticEffectsMaterial(Material material, ICamera camera) {
        this.updateRelativisticEffectsMaterial(material, camera, -1.0f);
    }

    public void updateRelativisticEffectsMaterial(Material material, ICamera camera, float vc) {
        if (material.get(FloatAttribute.Vc) == null) {
            this.setUpRelativisticEffectsMaterial(material);
        }
        RelativisticEffectsManager rem = RelativisticEffectsManager.getInstance();
        ((FloatAttribute)Objects.requireNonNull(material.get((int)FloatAttribute.Vc))).value = vc != -1.0f ? vc : rem.vc;
        ((Vector3Attribute)Objects.requireNonNull(material.get((int)Vector3Attribute.VelDir))).value.set(rem.velDir);
    }

    public void updateGravitationalWavesMaterial(Material material) {
        if (material.get(Vector4Attribute.Hterms) == null) {
            this.setUpGravitationalWavesMaterial(material);
        }
        RelativisticEffectsManager rem = RelativisticEffectsManager.getInstance();
        ((Vector4Attribute)Objects.requireNonNull(material.get((int)Vector4Attribute.Hterms))).value = rem.hterms;
        ((Vector3Attribute)Objects.requireNonNull(material.get((int)Vector3Attribute.Gw))).value.set(rem.gw);
        ((Matrix3Attribute)Objects.requireNonNull(material.get((int)Matrix3Attribute.Gwmat3))).value.set(rem.gwmat3);
        ((FloatAttribute)Objects.requireNonNull(material.get((int)FloatAttribute.Ts))).value = rem.gwtime;
        ((FloatAttribute)Objects.requireNonNull(material.get((int)FloatAttribute.Omgw))).value = rem.omgw;
    }

    public boolean hasGravitationalWaves(Material mat) {
        return false;
    }

    public boolean hasRelativisticEffects(Material mat) {
        return mat.get(Vector3Attribute.VelDir) != null;
    }
}

