/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import gaiasky.scene.api.IUpdatable;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.time.ITimeFrameProvider;

public class RotationComponent
implements IUpdatable<RotationComponent> {
    public double angularVelocity = 0.0;
    public double angle = 0.0;
    public double period;
    public double axialTilt;
    public double inclination;
    public double ascendingNode;
    public double meridianAngle;

    public void setPeriod(Double rotationPeriod) {
        this.period = rotationPeriod;
        this.angularVelocity = 360.0 / rotationPeriod;
    }

    public void update(ITimeFrameProvider time) {
        double prevAngle = this.angle;
        long t = time.getTime().toEpochMilli() - AstroUtils.J2000_MS;
        this.angle = (this.meridianAngle + this.angularVelocity * (double)t * 2.7777777777777776E-7) % 360.0;
    }

    public void setAxialTilt(Double f) {
        this.axialTilt = f;
    }

    public void setAxialtilt(Double f) {
        this.setAxialTilt(f);
    }

    public void setAngle(Double angle) {
        this.angle = angle;
    }

    public void setInclination(Double i) {
        this.inclination = i;
    }

    public void setInclination(Long i) {
        this.inclination = i.longValue();
    }

    public void setAscendingNode(Double an) {
        this.ascendingNode = an;
    }

    public void setAscendingnode(Double an) {
        this.setAscendingNode(an);
    }

    public void setMeridianAngle(Double ma) {
        this.meridianAngle = ma;
    }

    public void setMeridianangle(Double ma) {
        this.setMeridianAngle(ma);
    }

    public String toString() {
        return "{angVel=" + this.angularVelocity + ", angle=" + this.angle + ", period=" + this.period + ", axialTilt=" + this.axialTilt + ", inclination=" + this.inclination + ", ascendingNode=" + this.ascendingNode + ", meridianAngle=" + this.meridianAngle + "}";
    }

    public void copyFrom(RotationComponent other) {
        if (other.period > 0.0) {
            this.period = other.period;
        }
        if (other.angularVelocity > 0.0) {
            this.angularVelocity = other.angularVelocity;
        }
        if (other.axialTilt > 0.0) {
            this.axialTilt = other.axialTilt;
        }
        if (other.inclination > 0.0) {
            this.inclination = other.inclination;
        }
        if (other.ascendingNode > 0.0) {
            this.ascendingNode = other.ascendingNode;
        }
        if (other.meridianAngle > 0.0) {
            this.meridianAngle = other.meridianAngle;
        }
    }

    @Override
    public void updateWith(RotationComponent object) {
        this.copyFrom(object);
    }

    public RotationComponent copy() {
        RotationComponent clone = new RotationComponent();
        clone.angularVelocity = this.angularVelocity;
        clone.angle = this.angle;
        clone.axialTilt = this.axialTilt;
        clone.ascendingNode = this.ascendingNode;
        clone.inclination = this.inclination;
        clone.meridianAngle = this.meridianAngle;
        clone.period = this.period;
        return clone;
    }
}

