/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.record;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Texture;
import gaiasky.scene.record.IMaterialProvider;
import gaiasky.scene.record.MaterialComponent;
import gaiasky.scene.record.NamedComponent;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gdx.graphics.FloatTextureDataExt;
import gaiasky.util.gdx.graphics.TextureExt;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import gaiasky.util.gdx.shader.attribute.Vector2Attribute;
import gaiasky.util.svt.SVTQuadtree;
import gaiasky.util.svt.SVTQuadtreeBuilder;
import java.nio.file.Path;
import net.jafama.FastMath;

public final class VirtualTextureComponent
extends NamedComponent {
    public TextureExt indirectionBuffer;
    public int id;
    public String location;
    public String locationUnpacked;
    public int tileSize;
    public SVTQuadtree<Path> tree;
    private IMaterialProvider materialProvider;
    private int indirectionAttributeId;

    public void initialize(String name, IMaterialProvider materialProvider, int indirectionAttributeId) {
        super.initialize(name);
        this.materialProvider = materialProvider;
        this.indirectionAttributeId = indirectionAttributeId;
        this.buildTree();
    }

    public void doneLoading(AssetManager manager) {
        this.buildIndirectionBuffer();
    }

    public void buildIndirectionBuffer() {
        if (this.indirectionBuffer == null) {
            int indirectionSize = (int)FastMath.round((double)FastMath.pow((double)2.0, (double)this.tree.depth));
            FloatTextureDataExt indirectionData = new FloatTextureDataExt(indirectionSize * this.tree.root.length, indirectionSize, 34836, 6408, 5126, true, false);
            this.indirectionBuffer = new TextureExt(indirectionData);
            this.indirectionBuffer.setFilter(Texture.TextureFilter.MipMapNearestNearest, Texture.TextureFilter.Nearest);
        }
    }

    public void buildTree() {
        SVTQuadtreeBuilder builder = new SVTQuadtreeBuilder();
        this.locationUnpacked = Settings.settings.data.dataFile(this.location);
        this.tree = builder.build(this.name, Path.of(this.locationUnpacked, new String[0]), this.tileSize);
        this.tree.aux = this;
        int maxResolution = (int)FastMath.round((double)((double)this.tree.tileSize * FastMath.pow((double)2.0, (double)this.tree.depth)));
        Logger.getLogger(VirtualTextureComponent.class).info("SVT initialized with " + this.tree.root.length + " roots, " + this.tree.numTiles + " tiles (" + this.tree.tileSize + "x" + this.tree.tileSize + "), depth " + this.tree.depth + " and maximum resolution of " + maxResolution * this.tree.root.length + "x" + maxResolution);
    }

    public void setSVTAttributes(Texture cacheBufferTexture) {
        Material material;
        if (this.materialProvider != null && (material = this.materialProvider.getMaterial()) != null) {
            material.set((Attribute)new TextureAttribute(TextureAttribute.SvtCache, cacheBufferTexture));
            if (this.indirectionBuffer != null && !material.has(this.indirectionAttributeId)) {
                IMaterialProvider iMaterialProvider;
                this.materialProvider.getMaterial().set((Attribute)new TextureAttribute(this.indirectionAttributeId, this.indirectionBuffer));
                if (this.indirectionAttributeId == TextureAttribute.SvtIndirectionHeight && this.materialProvider != null && (iMaterialProvider = this.materialProvider) instanceof MaterialComponent) {
                    MaterialComponent mc = (MaterialComponent)iMaterialProvider;
                    int[] resolution = this.tree.getResolution();
                    mc.heightSize.set((float)resolution[0], (float)resolution[1]);
                    material.set((Attribute)new FloatAttribute(FloatAttribute.HeightScale, mc.heightScale.floatValue() * (float)Settings.settings.scene.renderer.elevation.multiplier));
                    material.set((Attribute)new Vector2Attribute(Vector2Attribute.HeightSize, mc.heightSize));
                    material.set((Attribute)new FloatAttribute(FloatAttribute.TessQuality, (float)Settings.settings.scene.renderer.elevation.quality));
                }
            }
        }
    }

    public boolean svtAttributesSet() {
        Material material;
        if (this.materialProvider != null && (material = this.materialProvider.getMaterial()) != null) {
            return material.has(this.indirectionAttributeId) && material.has(TextureAttribute.SvtCache);
        }
        return false;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setTileSize(Integer size) {
        assert (this.validTileSizeCheck(size)) : "Tile size must be a power of two, with a maximum of 1024.";
        this.tileSize = size;
    }

    private boolean validTileSizeCheck(int x) {
        return x == 4 || x == 8 || x == 16 || x == 32 || x == 64 || x == 128 || x == 256 || x == 512 || x == 1024;
    }

    public void setTileSize(Long size) {
        this.setTileSize(FastMath.toIntExact((long)size));
    }

    public void dispose() {
    }
}

