/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;

public abstract class ParallelSystem
extends EntitySystem {
    private final Family family;
    private final ForkJoinPool forkJoinPool;
    private ImmutableArray<Entity> entities;
    private List<Callable<Integer>> runnableTasks;

    protected ParallelSystem(Family family) {
        this(family, 0);
    }

    protected ParallelSystem(Family family, int priority) {
        super(priority);
        this.family = family;
        this.forkJoinPool = ForkJoinPool.commonPool();
    }

    public void addedToEngine(Engine engine) {
        this.entities = engine.getEntitiesFor(this.family);
        this.runnableTasks = new ArrayList<Callable<Integer>>(this.entities.size());
        for (Entity e : this.entities) {
            this.runnableTasks.add(() -> {
                this.processEntity(e, 0.0f);
                return 0;
            });
        }
    }

    public void removedFromEngine(Engine engine) {
        this.entities = null;
    }

    public void update(float deltaTime) {
        try {
            this.forkJoinPool.invokeAll(this.runnableTasks);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ImmutableArray<Entity> getEntities() {
        return this.entities;
    }

    public Family getFamily() {
        return this.family;
    }

    protected abstract void processEntity(Entity var1, float var2);
}

