/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import gaiasky.scene.system.initialize.EntityInitializer;
import gaiasky.util.Logger;

public abstract class AbstractInitSystem
extends IteratingSystem
implements EntityInitializer {
    protected Logger.Log logger;
    protected Engine engineBackup;
    private InitializerMode mode;

    protected AbstractInitSystem(boolean setUp, Family family, int priority) {
        super(family, priority);
        this.mode = setUp ? InitializerMode.SETUP : InitializerMode.INIT;
        this.logger = Logger.getLogger(this.getClass());
    }

    protected AbstractInitSystem(Family family, int priority) {
        this(false, family, priority);
    }

    public void setModeInit() {
        this.mode = InitializerMode.INIT;
    }

    public void setModeSetUp() {
        this.mode = InitializerMode.SETUP;
    }

    public boolean isModeInit() {
        return this.mode != null && this.mode == InitializerMode.INIT;
    }

    public boolean isModeSetUp() {
        return this.mode != null && this.mode == InitializerMode.SETUP;
    }

    protected void processEntity(Entity entity, float deltaTime) {
        switch (this.mode.ordinal()) {
            case 0: {
                this.initializeEntity(entity);
                break;
            }
            case 1: {
                this.setUpEntity(entity);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void addedToEngine(Engine engine) {
        super.addedToEngine(engine);
        this.engineBackup = engine;
    }

    private static enum InitializerMode {
        INIT,
        SETUP;

    }
}

