/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Axis;
import gaiasky.scene.component.Line;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.line.LineEntityRenderSystem;
import gaiasky.util.Logger;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;

public class AxesInitializer
extends AbstractInitSystem {
    public AxesInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Axis axis = (Axis)Mapper.axis.get(entity);
        Line line = (Line)Mapper.line.get(entity);
        line.lineWidth = 1.0f;
        line.renderConsumer = LineEntityRenderSystem::renderAxes;
        axis.b0 = new Vector3D(1.0, 0.0, 0.0);
        axis.b1 = new Vector3D(0.0, 1.0, 0.0);
        axis.b2 = new Vector3D(0.0, 0.0, 1.0);
        axis.o = new Vector3D();
        axis.x = new Vector3D();
        axis.y = new Vector3D();
        axis.z = new Vector3D();
    }

    @Override
    public void setUpEntity(Entity entity) {
        Axis axis = (Axis)Mapper.axis.get(entity);
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        if (transform.transformName != null) {
            Class<Coordinates> c = Coordinates.class;
            try {
                Method m = ClassReflection.getMethod(c, (String)transform.transformName, (Class[])new Class[0]);
                transform.matrix = (Matrix4D)m.invoke(null, new Object[0]);
            }
            catch (ReflectionException e) {
                Logger.getLogger(this.getClass()).error("Error getting/invoking method Coordinates." + transform.transformName + "()");
            }
            axis.b0.mul(transform.matrix);
            axis.b1.mul(transform.matrix);
            axis.b2.mul(transform.matrix);
        }
        if (axis.axesColors == null) {
            axis.axesColors = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        }
    }
}

