/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import gaiasky.data.AssetBean;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.GridUV;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.component.RenderType;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.math.Matrix4D;

public class BackgroundModelInitializer
extends AbstractInitSystem {
    public BackgroundModelInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        RenderType renderType = (RenderType)Mapper.renderType.get(entity);
        body.size *= (float)Constants.DISTANCE_SCALE_FACTOR;
        model.renderConsumer = ModelEntityRenderSystem::renderGenericModel;
        model.model.forceInit = true;
        model.model.initialize(null);
        model.model.env.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, body.color[0], body.color[1], body.color[2], 1.0f));
        if (renderType.renderGroup == null) {
            renderType.renderGroup = RenderGroup.SKYBOX;
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        this.setUpBackgroundModel(entity, body, graph, model);
        if (Mapper.grid.has(entity)) {
            this.setUpUVGrid(entity, body);
        }
    }

    private void setUpBackgroundModel(Entity entity, Body body, GraphNode graph, Model model) {
        Label label = (Label)Mapper.label.get(entity);
        this.updateLocalTransform(entity, body, graph);
        model.model.doneLoading(AssetBean.manager(), graph.localTransform, body.color);
        model.model.setDepthTest(515, false);
    }

    private void updateLocalTransform(Entity entity, Body body, GraphNode graph) {
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        graph.localTransform.idt();
        graph.localTransform.scl(body.size);
        if (transform.transformName != null) {
            Class<Coordinates> c = Coordinates.class;
            try {
                Method m = ClassReflection.getMethod(c, (String)transform.transformName, (Class[])new Class[0]);
                Matrix4D trf = (Matrix4D)m.invoke(null, new Object[0]);
                Matrix4 aux = trf.putIn(new Matrix4());
                graph.localTransform.mul(aux);
            }
            catch (ReflectionException e) {
                Logger.getLogger(this.getClass()).error("Error getting/invoking method Coordinates." + transform.transformName + "()");
            }
        }
        if (model.model != null && model.model.type.equalsIgnoreCase("sphere")) {
            graph.localTransform.rotate(0.0f, 1.0f, 0.0f, 90.0f);
        }
    }

    private void setUpUVGrid(Entity entity, Body body) {
        GridUV grid = (GridUV)Mapper.grid.get(entity);
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        grid.annotTransform.scl(body.size);
        if (transform.transformName != null) {
            Class<Coordinates> c = Coordinates.class;
            try {
                Method m = ClassReflection.getMethod(c, (String)transform.transformName, (Class[])new Class[0]);
                Matrix4D trf = (Matrix4D)m.invoke(null, new Object[0]);
                Matrix4 aux = new Matrix4();
                trf.putIn(aux);
                grid.annotTransform.mul(aux);
            }
            catch (ReflectionException e) {
                Logger.getLogger(this.getClass()).error("Error getting/invoking method Coordinates." + transform.transformName + "()");
            }
        }
        label.label = true;
        label.textScale = 0.2f;
        label.labelMax = (float)(5.0E-4 / Constants.DISTANCE_SCALE_FACTOR);
        label.labelFactor = 1.0f;
        label.renderConsumer = LabelEntityRenderSystem::renderGridAnnotations;
        label.renderFunction = LabelView::renderTextGridRec;
    }
}

