/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Matrix4;
import gaiasky.GaiaSky;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Coordinates;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.util.math.Vector3Q;

public class BaseInitializer
extends AbstractInitSystem {
    private final Scene scene;

    public BaseInitializer(Scene scene, boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
        this.scene = scene;
    }

    @Override
    public void initializeEntity(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Render render = (Render)Mapper.render.get(entity);
        if (base.ct == null) {
            base.ct = new ComponentTypes(ComponentTypes.ComponentType.Others.ordinal());
        }
        if (graph != null) {
            graph.localTransform = new Matrix4();
            graph.translation = new Vector3Q();
        }
        if (render != null) {
            render.entity = entity;
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
        if (Mapper.coordinates.has(entity)) {
            Coordinates coord = (Coordinates)Mapper.coordinates.get(entity);
            if (coord.coordinates != null) {
                Body body = (Body)Mapper.body.get(entity);
                coord.coordinates.doneLoading(this.scene, entity);
                coord.coordinates.getEquatorialCartesianCoordinates(GaiaSky.instance.time.getTime(), body.pos);
            }
        }
    }
}

