/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.data.group.PointDataProvider;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.component.BillboardSet;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Coordinates;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.record.BillboardDataset;
import gaiasky.scene.record.ParticleVector;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.util.List;

public class BillboardSetInitializer
extends AbstractInitSystem {
    private final Vector3D D31 = new Vector3D();

    public BillboardSetInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Label label = (Label)Mapper.label.get(entity);
        label.label = true;
        label.textScale = 3.0f;
        label.labelMax = (float)(0.002 / Constants.DISTANCE_SCALE_FACTOR);
        label.labelFactor = 0.6f;
        label.renderConsumer = LabelEntityRenderSystem::renderBillboardSet;
        label.renderFunction = LabelView::renderTextBase;
        label.depthBufferConsumer = LabelView::noTextDepthBuffer;
        this.reloadData(entity);
    }

    @Override
    public void setUpEntity(Entity entity) {
        this.transformData(entity);
    }

    public void reloadData(Entity entity) {
        try {
            BillboardSet billboard = (BillboardSet)Mapper.billboardSet.get(entity);
            PointDataProvider provider = new PointDataProvider();
            boolean reload = false;
            for (BillboardDataset dataset : billboard.datasets) {
                boolean reloadNeeded = dataset.initialize(provider, reload);
                reload = reload || reloadNeeded;
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error(e);
        }
    }

    public void transformData(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        Coordinates coord = (Coordinates)Mapper.coordinates.get(entity);
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        BillboardSet set = (BillboardSet)Mapper.billboardSet.get(entity);
        coord.coordinates.getEquatorialCartesianCoordinates(null, body.pos);
        Vector3D aux = this.D31;
        Vector3Q pos3b = body.pos;
        for (BillboardDataset bd : set.datasets) {
            List<IParticleRecord> a = bd.data;
            if (a == null) continue;
            for (IParticleRecord iParticleRecord : a) {
                ParticleVector pr = (ParticleVector)iParticleRecord;
                aux.set((float)pr.x(), (float)pr.z(), (float)pr.y());
                aux.scl(body.size).rotate(-90.0, 0.0, 1.0, 0.0).mul(transform.matrix).add(pos3b);
                double[] dat = pr.data();
                dat[0] = aux.x;
                dat[1] = aux.y;
                dat[2] = aux.z;
            }
        }
    }
}

