/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.math.Matrix4;
import gaiasky.render.BlendMode;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Billboard;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Cluster;
import gaiasky.scene.component.Focus;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.entity.FocusActive;
import gaiasky.scene.entity.FocusHit;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.billboard.BillboardEntityRenderSystem;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Bits;
import gaiasky.util.Constants;
import gaiasky.util.ModelCache;
import gaiasky.util.Settings;
import gaiasky.util.gdx.IntMeshPartBuilder;
import gaiasky.util.gdx.IntModelBuilder;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import net.jafama.FastMath;

public class ClusterInitializer
extends AbstractInitSystem {
    public ClusterInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        Cluster cluster = (Cluster)Mapper.cluster.get(entity);
        SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        Focus focus = (Focus)Mapper.focus.get(entity);
        focus.activeFunction = FocusActive::isFocusActiveCtOpacity;
        focus.hitCoordinatesConsumer = FocusHit::addHitCoordinateCluster;
        focus.hitRayConsumer = FocusHit::addHitRayCluster;
        sa.thresholdQuad = FastMath.toRadians((double)2.0);
        sa.thresholdLabel = sa.thresholdPoint = FastMath.toRadians((double)1.5);
        base.ct = new ComponentTypes(ComponentTypes.ComponentType.Clusters.ordinal());
        body.size = (float)(Math.tan(Math.toRadians(cluster.radiusDeg)) * cluster.dist);
        label.label = true;
        label.textScale = 0.2f;
        label.labelMax = (float)(5.0E-4 / Constants.DISTANCE_SCALE_FACTOR);
        label.labelFactor = 1.0f;
        label.renderConsumer = LabelEntityRenderSystem::renderCluster;
        label.renderFunction = LabelView::renderTextEssential;
    }

    @Override
    public void setUpEntity(Entity entity) {
        this.initModel(entity);
    }

    private void initModel(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        Cluster cluster = (Cluster)Mapper.cluster.get(entity);
        Billboard bb = (Billboard)Mapper.billboard.get(entity);
        if (cluster.clusterTex == null) {
            cluster.clusterTex = new Texture(Settings.settings.data.dataFileHandle("$data/tex/base/cluster-tex.png"), true);
            cluster.clusterTex.setFilter(Texture.TextureFilter.MipMapLinearNearest, Texture.TextureFilter.Linear);
        }
        if (cluster.model == null) {
            Material mat = new Material(new BlendingAttribute(1, 1), new ColorAttribute(ColorAttribute.Diffuse, body.color[0], body.color[1], body.color[2], body.color[3]));
            IntModelBuilder modelBuilder = ModelCache.cache.mb;
            modelBuilder.begin();
            IntMeshPartBuilder bPartBuilder = modelBuilder.part("sph", 1, Bits.indices(1), mat);
            bPartBuilder.icosphere(1.0f, 3, false, true);
            cluster.model = modelBuilder.end();
            cluster.modelTransform = new Matrix4();
        }
        bb.renderConsumer = BillboardEntityRenderSystem::renderBillboardCluster;
        model.renderConsumer = ModelEntityRenderSystem::renderStarClusterModel;
        model.model = new ModelComponent(false);
        model.model.setBlendMode(BlendMode.ADDITIVE);
        model.model.initialize(null);
        DirectionalLight dLight = new DirectionalLight();
        dLight.set(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        model.model.env = new Environment();
        model.model.env.add(dLight);
        model.model.env.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 1.0f, 1.0f, 1.0f, 1.0f));
        model.model.env.set((Attribute)new FloatAttribute(FloatAttribute.Shininess, 0.2f));
        model.model.instance = new IntModelInstance(cluster.model, cluster.modelTransform);
        if (Settings.settings.runtime.relativisticAberration) {
            model.model.rec.setUpRelativisticEffectsMaterial(model.model.instance.materials);
        }
        if (Settings.settings.runtime.gravitationalWaves) {
            model.model.rec.setUpGravitationalWavesMaterial(model.model.instance.materials);
        }
    }
}

