/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.utils.IntMap;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Constel;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Line;
import gaiasky.scene.entity.ConstellationRadio;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.line.LineEntityRenderSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.tree.IPosition;

public class ConstellationInitializer
extends AbstractInitSystem {
    private final Scene scene;

    public ConstellationInitializer(Scene scene, boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
        this.scene = scene;
    }

    @Override
    public void initializeEntity(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        Constel constel = (Constel)Mapper.constel.get(entity);
        Line line = (Line)Mapper.line.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        constel.posd = new Vector3D();
        constel.alpha = 0.4f;
        if (body.color == null) {
            body.color = new float[]{0.5f, 1.0f, 0.5f, constel.alpha};
            body.labelColor = new float[]{0.5f, 1.0f, 0.5f, constel.alpha};
        }
        label.label = true;
        label.renderConsumer = LabelEntityRenderSystem::renderConstellation;
        label.renderFunction = LabelView::renderTextBase;
        label.labelPosition = new Vector3Q();
        line.lineWidth = 1.5f;
        line.renderConsumer = LineEntityRenderSystem::renderConstellation;
        EventManager.instance.subscribe((IObserver)new ConstellationRadio(entity), Event.CONSTELLATION_UPDATE_CMD);
    }

    @Override
    public void setUpEntity(Entity entity) {
        Constel constel = (Constel)Mapper.constel.get(entity);
        if (!constel.allLoaded) {
            int nPairs = constel.ids.size;
            if (constel.lines == null) {
                constel.lines = new IPosition[nPairs][];
            }
            IntMap<IPosition> hipMap = this.scene.index().getHipMap();
            constel.allLoaded = true;
            for (int i = 0; i < nPairs; ++i) {
                int[] pair = (int[])constel.ids.get(i);
                IPosition s1 = (IPosition)hipMap.get(pair[0]);
                IPosition s2 = (IPosition)hipMap.get(pair[1]);
                if (constel.lines[i] == null && s1 != null && s2 != null) {
                    constel.lines[i] = new IPosition[]{s1, s2};
                    continue;
                }
                constel.allLoaded = false;
            }
        }
    }
}

