/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.main.WelcomeGui;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.view.FocusView;
import gaiasky.util.CatalogInfo;
import gaiasky.util.Settings;
import gaiasky.util.datadesc.DataDescriptor;
import gaiasky.util.datadesc.DatasetDesc;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class DatasetDescriptionInitializer
extends AbstractInitSystem {
    private final FocusView view = new FocusView();

    public DatasetDescriptionInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
    }

    @Override
    public void setUpEntity(Entity entity) {
        DataDescriptor local;
        DatasetDesc dataset;
        Base base = (Base)Mapper.base.get(entity);
        DatasetDescription datasetDesc = (DatasetDescription)Mapper.datasetDescription.get(entity);
        if (datasetDesc.catalogInfo == null && WelcomeGui.getLocalDatasets().get() != null && (dataset = (local = WelcomeGui.getLocalDatasets().get()).findDatasetByName(base.getName())) != null) {
            datasetDesc.catalogInfo = this.fromDatasetDesc(dataset, entity);
        }
        this.initializeCatalogInfo(entity, datasetDesc, true, base.getName(), datasetDesc.description);
    }

    private CatalogInfo fromDatasetDesc(DatasetDesc dd, Entity entity) {
        CatalogInfo result = new CatalogInfo(dd.name, dd.description, this.view.getDataFile(), CatalogInfo.CatalogInfoSource.INTERNAL, 1.0f, entity);
        result.nParticles = dd.nObjects;
        result.sizeBytes = dd.sizeBytes;
        return result;
    }

    protected void initializeCatalogInfo(Entity entity, DatasetDescription dd, boolean create, String name, String description) {
        this.view.setEntity(entity);
        String dataFile = this.view.getDataFile();
        if (create && dd.catalogInfo == null) {
            dd.catalogInfo = new CatalogInfo(name, description, dataFile, CatalogInfo.CatalogInfoSource.INTERNAL, 1.0f, entity);
        }
        if (dd.catalogInfo != null && dd.addDataset) {
            if (dd.catalogInfo.nParticles <= 0L) {
                dd.catalogInfo.nParticles = this.view.getNumParticles();
            }
            if (dd.catalogInfo.sizeBytes <= 0L && dataFile != null && !dataFile.isBlank()) {
                Path df = Path.of(dataFile, new String[0]);
                if (!Files.isRegularFile(df, new LinkOption[0]) || !Files.exists(df, new LinkOption[0])) {
                    df = Path.of(Settings.settings.data.dataFile(dataFile), new String[0]);
                }
                long l = dd.catalogInfo.sizeBytes = Files.exists(df, new LinkOption[0]) && Files.isRegularFile(df, new LinkOption[0]) ? df.toFile().length() : -1L;
            }
            if (dd.catalogInfo.entity == null) {
                dd.catalogInfo.entity = entity;
            }
            EventManager.publish(Event.CATALOG_ADD, entity, dd.catalogInfo, false);
        }
    }
}

