/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.utils.Array;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.OrbitElementsSet;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.tag.TagSetElement;
import gaiasky.scene.entity.ElementsSetRadio;
import gaiasky.scene.system.initialize.AbstractInitSystem;

public class ElementsSetInitializer
extends AbstractInitSystem {
    public ElementsSetInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
    }

    @Override
    public void setUpEntity(Entity entity) {
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        OrbitElementsSet set = (OrbitElementsSet)Mapper.orbitElementsSet.get(entity);
        this.initializeObjectsWithOrbit(graph, set);
        EventManager.instance.subscribe((IObserver)new ElementsSetRadio(entity, this), Event.GPU_DISPOSE_ORBITAL_ELEMENTS);
    }

    public void initializeObjectsWithOrbit(GraphNode graph, OrbitElementsSet set) {
        if (set.alwaysUpdate == null) {
            set.alwaysUpdate = new Array();
        } else {
            set.alwaysUpdate.clear();
        }
        if (graph.children != null && graph.children.size > 0) {
            for (Entity e : graph.children) {
                e.add((Component)new TagSetElement());
                if (Mapper.trajectory.has(e)) {
                    Trajectory trajectory = (Trajectory)Mapper.trajectory.get(e);
                    if (!trajectory.bodyRepresentation.isOrbit()) continue;
                    set.alwaysUpdate.add((Object)e);
                    continue;
                }
                set.alwaysUpdate.add((Object)e);
            }
        }
    }
}

