/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.scene.Index;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Fade;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.util.math.Vector2D;

public class FadeNodeInitializer
extends AbstractInitSystem {
    private final Index index;

    public FadeNodeInitializer(Index index, boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
        this.index = index;
    }

    @Override
    public void initializeEntity(Entity entity) {
        Fade fade = (Fade)Mapper.fade.get(entity);
        if (fade.fadeIn != null && fade.fadeInMap == null) {
            fade.fadeInMap = new Vector2D(0.0, 1.0);
        }
        if (fade.fadeOut != null && fade.fadeOutMap == null) {
            fade.fadeOutMap = new Vector2D(1.0, 0.0);
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
        Fade fade = (Fade)Mapper.fade.get(entity);
        if (fade.fadePositionObjectName != null) {
            fade.fadePositionObject = this.index.getEntity(fade.fadePositionObjectName);
        }
    }
}

