/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Fade;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.GridRecursive;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Line;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.entity.GridRecursiveRadio;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.line.LineEntityRenderSystem;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Constants;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.util.ArrayList;
import java.util.HashMap;

public class GridRecInitializer
extends AbstractInitSystem {
    public GridRecInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        GridRecursive gr = (GridRecursive)Mapper.gridRec.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        Line line = (Line)Mapper.line.get(entity);
        label.textScale = 1.0f;
        label.labelFactor = 0.002f;
        label.labelMax = 1.0f;
        label.label = true;
        label.labelPosition = new Vector3Q();
        label.renderConsumer = LabelEntityRenderSystem::renderRecursiveGrid;
        label.renderFunction = LabelView::renderTextGridRec;
        line.lineWidth = 0.5f;
        line.renderConsumer = LineEntityRenderSystem::renderGridRec;
        transform.floatVersion = true;
        transform.setTransformName(Settings.settings.scene.visibility.get(ComponentTypes.ComponentType.Galactic.toString()) != false ? "galacticToEquatorial" : (Settings.settings.scene.visibility.get(ComponentTypes.ComponentType.Ecliptic.toString()) != false ? "eclipticToEquatorial" : null));
        gr.scalingFading = new Pair<Double, Double>(0.0, 0.0);
        body.color = Settings.settings.scene.visibility.get(ComponentTypes.ComponentType.Galactic.toString()) != false ? gr.ccGal : (Settings.settings.scene.visibility.get(ComponentTypes.ComponentType.Ecliptic.toString()) != false ? gr.ccEcl : gr.ccEq);
        body.labelColor = body.color;
        gr.p01 = new Vector3D();
        gr.p02 = new Vector3D();
        gr.d01 = -1.0;
        gr.d02 = -1.0;
        gr.a = new Vector3D();
        gr.b = new Vector3D();
        gr.c = new Vector3D();
        gr.d = new Vector3D();
        model.renderConsumer = ModelEntityRenderSystem::renderRecursiveGridModel;
        model.model = new ModelComponent();
        model.model.setType("twofacedbillboard");
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("diameter", 1.0);
        model.model.setParams(p);
        model.model.forceInit = true;
        model.model.initialize(null);
        model.model.env.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, body.color[0], body.color[1], body.color[2], body.color[3]));
        model.model.setDepthTest(515, false);
        this.initAnnotations(gr);
    }

    private void initAnnotations(GridRecursive gr) {
        gr.annotations = new ArrayList<Pair<Double, String>>();
        this.annotation(gr, 1.0 * Constants.M_TO_U, "1 " + I18n.msg("gui.unit.m"));
        this.annotation(gr, 50.0 * Constants.M_TO_U, "50 " + I18n.msg("gui.unit.m"));
        this.annotation(gr, 100.0 * Constants.M_TO_U, "100 " + I18n.msg("gui.unit.m"));
        this.annotation(gr, 200.0 * Constants.M_TO_U, "200 " + I18n.msg("gui.unit.m"));
        this.annotation(gr, 500.0 * Constants.M_TO_U, "500 " + I18n.msg("gui.unit.m"));
        this.annotation(gr, 1.0 * Constants.KM_TO_U, "1 " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 10.0 * Constants.KM_TO_U, "10 " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 100.0 * Constants.KM_TO_U, "100 " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 250.0 * Constants.KM_TO_U, "250 " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 500.0 * Constants.KM_TO_U, "500 " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 1000.0 * Constants.KM_TO_U, "1000 " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 2500.0 * Constants.KM_TO_U, "2500 " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 5000.0 * Constants.KM_TO_U, "5000 " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 10000.0 * Constants.KM_TO_U, "10000 " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 75000.0 * Constants.KM_TO_U, "75000 " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 370000.0 * Constants.KM_TO_U, "370000 " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 1500000.0 * Constants.KM_TO_U, "1.5M " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 5000000.0 * Constants.KM_TO_U, "5M " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 1.0E7 * Constants.KM_TO_U, "10M " + I18n.msg("gui.unit.km"));
        this.annotation(gr, 0.1 * Constants.AU_TO_U, "0.1 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 0.5 * Constants.AU_TO_U, "0.5 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 1.0 * Constants.AU_TO_U, "1 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 2.0 * Constants.AU_TO_U, "2 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 5.0 * Constants.AU_TO_U, "5 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 10.0 * Constants.AU_TO_U, "10 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 50.0 * Constants.AU_TO_U, "50 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 100.0 * Constants.AU_TO_U, "100 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 500.0 * Constants.AU_TO_U, "500 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 1000.0 * Constants.AU_TO_U, "1000 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 5000.0 * Constants.AU_TO_U, "5000 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 10000.0 * Constants.AU_TO_U, "10000 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 50000.0 * Constants.AU_TO_U, "50000 " + I18n.msg("gui.unit.au"));
        this.annotation(gr, 1.0 * Constants.LY_TO_U, "1 " + I18n.msg("gui.unit.ly"));
        this.annotation(gr, 2.0 * Constants.LY_TO_U, "2 " + I18n.msg("gui.unit.ly"));
        this.annotation(gr, 1.0 * Constants.PC_TO_U, "1 " + I18n.msg("gui.unit.pc"));
        this.annotation(gr, 2.5 * Constants.PC_TO_U, "2.5 " + I18n.msg("gui.unit.pc"));
        this.annotation(gr, 5.0 * Constants.PC_TO_U, "5 " + I18n.msg("gui.unit.pc"));
        this.annotation(gr, 10.0 * Constants.PC_TO_U, "10 " + I18n.msg("gui.unit.pc"));
        this.annotation(gr, 25.0 * Constants.PC_TO_U, "25 " + I18n.msg("gui.unit.pc"));
        this.annotation(gr, 50.0 * Constants.PC_TO_U, "50 " + I18n.msg("gui.unit.pc"));
        this.annotation(gr, 100.0 * Constants.PC_TO_U, "100 " + I18n.msg("gui.unit.pc"));
        this.annotation(gr, 250.0 * Constants.PC_TO_U, "250 " + I18n.msg("gui.unit.pc"));
        this.annotation(gr, 500.0 * Constants.PC_TO_U, "500 " + I18n.msg("gui.unit.pc"));
        this.annotation(gr, 1000.0 * Constants.PC_TO_U, "1 " + I18n.msg("gui.unit.kpc"));
        this.annotation(gr, 2500.0 * Constants.PC_TO_U, "2.5 " + I18n.msg("gui.unit.kpc"));
        this.annotation(gr, 5000.0 * Constants.PC_TO_U, "5 " + I18n.msg("gui.unit.kpc"));
        this.annotation(gr, 10000.0 * Constants.PC_TO_U, "10 " + I18n.msg("gui.unit.kpc"));
        this.annotation(gr, 25000.0 * Constants.PC_TO_U, "25 " + I18n.msg("gui.unit.kpc"));
        this.annotation(gr, 50000.0 * Constants.PC_TO_U, "50 " + I18n.msg("gui.unit.kpc"));
        this.annotation(gr, 100000.0 * Constants.PC_TO_U, "100 " + I18n.msg("gui.unit.kpc"));
        this.annotation(gr, 250000.0 * Constants.PC_TO_U, "250 " + I18n.msg("gui.unit.kpc"));
        this.annotation(gr, 500000.0 * Constants.PC_TO_U, "500 " + I18n.msg("gui.unit.kpc"));
        this.annotation(gr, 1000000.0 * Constants.PC_TO_U, "1 " + I18n.msg("gui.unit.mpc"));
        this.annotation(gr, 2500000.0 * Constants.PC_TO_U, "2.5 " + I18n.msg("gui.unit.mpc"));
        this.annotation(gr, 5000000.0 * Constants.PC_TO_U, "5 " + I18n.msg("gui.unit.mpc"));
        this.annotation(gr, 1.0E7 * Constants.PC_TO_U, "10 " + I18n.msg("gui.unit.mpc"));
        this.annotation(gr, 2.5E7 * Constants.PC_TO_U, "25 " + I18n.msg("gui.unit.mpc"));
        this.annotation(gr, 5.0E7 * Constants.PC_TO_U, "50 " + I18n.msg("gui.unit.mpc"));
        this.annotation(gr, 1.0E8 * Constants.PC_TO_U, "100 " + I18n.msg("gui.unit.mpc"));
        this.annotation(gr, 5.0E8 * Constants.PC_TO_U, "500 " + I18n.msg("gui.unit.mpc"));
        this.annotation(gr, 1.0E9 * Constants.PC_TO_U, "1 " + I18n.msg("gui.unit.gpc"));
        this.annotation(gr, 2.5E9 * Constants.PC_TO_U, "2.5 " + I18n.msg("gui.unit.gpc"));
        this.annotation(gr, 5.0E9 * Constants.PC_TO_U, "5 " + I18n.msg("gui.unit.gpc"));
        this.annotation(gr, 1.0E10 * Constants.PC_TO_U, "10 " + I18n.msg("gui.unit.gpc"));
        this.annotation(gr, 5.0E10 * Constants.PC_TO_U, "50 " + I18n.msg("gui.unit.gpc"));
        this.annotation(gr, 1.0E11 * Constants.PC_TO_U, "100 " + I18n.msg("gui.unit.gpc"));
    }

    private void annotation(GridRecursive gr, double dist, String text) {
        gr.annotations.add(new Pair<Double, String>(dist, text));
    }

    @Override
    public void setUpEntity(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        model.model.doneLoading(GaiaSky.instance.assetManager, graph.localTransform, body.color);
        model.model.setColorAttribute(ColorAttribute.Emissive, ColorUtils.getRgbaComplimentary(body.color));
        EventManager.instance.subscribe((IObserver)new GridRecursiveRadio(entity), Event.TOGGLE_VISIBILITY_CMD);
        if (Settings.settings.runtime.openXr) {
            Fade fade = (Fade)Mapper.fade.get(entity);
            fade.setFadeOut(new double[]{5000000.0, 5.0E7});
            fade.fadeOutMap = new Vector2D(1.0, 0.0);
        }
    }
}

