/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.scene.Index;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Octant;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.view.OctreeObjectView;
import gaiasky.util.tree.OctreeNode;

public class IndexInitializer
extends AbstractInitSystem {
    private final Index index;

    public IndexInitializer(Index index, Family family, int priority) {
        super(false, family, priority);
        this.index = index;
    }

    @Override
    public void initializeEntity(Entity entity) {
        this.index.addToIndex(entity);
        if (Mapper.octree.has(entity)) {
            Octant octant = (Octant)Mapper.octant.get(entity);
            this.initializeOctant(octant.octant);
        }
        this.index.addToHipMap(entity);
    }

    private void initializeOctant(OctreeNode octant) {
        if (octant != null) {
            if (octant.objects != null) {
                octant.objects.forEach(object -> {
                    if (object instanceof OctreeObjectView) {
                        this.index.addToIndex(((OctreeObjectView)object).getEntity());
                    }
                });
            }
            if (octant.children != null) {
                for (OctreeNode child : octant.children) {
                    if (child == null) continue;
                    this.initializeOctant(child);
                }
            }
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
    }
}

