/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Focus;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.entity.FocusActive;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Constants;
import gaiasky.util.Settings;

public class InvisibleInitializer
extends AbstractInitSystem {
    public InvisibleInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Focus focus = (Focus)Mapper.focus.get(entity);
        focus.activeFunction = FocusActive::isFocusActiveTrue;
        if (graph.parentName == null) {
            graph.parentName = "Universe";
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
        Label label = (Label)Mapper.label.get(entity);
        SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
        sa.thresholdLabel = Math.toRadians(1.0E-6) * Constants.DISTANCE_SCALE_FACTOR / (double)Settings.settings.scene.label.number * 60.0;
        label.textScale = 0.2f;
        label.labelMax = 1.8f;
        if (label.labelFactor == 0.0f) {
            label.labelFactor = 5.0E-4f;
        }
        label.renderConsumer = LabelEntityRenderSystem::renderCelestial;
        label.renderFunction = LabelView::renderTextBase;
    }
}

