/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.utils.Array;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Keyframes;
import gaiasky.scene.component.Label;
import gaiasky.scene.entity.KeyframeUtils;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;
import gaiasky.util.color.ColorUtils;

public class KeyframeInitializer
extends AbstractInitSystem {
    private final KeyframeUtils utils;
    private final Scene scene;

    public KeyframeInitializer(Scene scene, boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
        this.scene = scene;
        this.utils = new KeyframeUtils(scene);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        Keyframes kf = (Keyframes)Mapper.keyframes.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        label.label = false;
        label.labelFactor = 1.0f;
        label.labelMax = 5.0E-4f;
        label.textScale = 0.3f;
        label.renderConsumer = LabelEntityRenderSystem::renderKeyframe;
        label.renderFunction = LabelView::renderTextKeyframe;
        label.depthBufferConsumer = LabelView::noTextDepthBuffer;
        kf.orientations = new Array();
        kf.path = this.utils.newVerts(this.scene, "keyframes.path", base.ct, "gaiasky.scenegraph.Polyline", ColorUtils.gGreen, RenderGroup.LINE, false, 0.5f * kf.ss);
        kf.segments = this.utils.newVerts(this.scene, "keyframes.segments", base.ct, "gaiasky.scenegraph.Polyline", ColorUtils.gYellow, RenderGroup.LINE, false, 0.6f * kf.ss);
        kf.knots = this.utils.newVerts(this.scene, "keyframes.knots", base.ct, "gaiasky.scenegraph.VertsObject", ColorUtils.gGreen, RenderGroup.POINT, false, 8.0f * kf.ss);
        kf.knotsSeam = this.utils.newVerts(this.scene, "keyframes.knots.seam", base.ct, "gaiasky.scenegraph.VertsObject", ColorUtils.gRed, RenderGroup.POINT, false, 8.0f * kf.ss, false, true);
        kf.selectedKnot = this.utils.newVerts(this.scene, "keyframes.selknot", base.ct, "gaiasky.scenegraph.VertsObject", ColorUtils.gPink, RenderGroup.POINT, false, 12.0f * kf.ss, false, false);
        kf.highlightedKnot = this.utils.newVerts(this.scene, "keyframes.highknot", base.ct, "gaiasky.scenegraph.VertsObject", ColorUtils.gYellow, RenderGroup.POINT, false, 12.0f * kf.ss, false, false);
        kf.objects = new Array();
        kf.objects.add((Object)kf.path);
        kf.objects.add((Object)kf.segments);
        kf.objects.add((Object)kf.knots);
        kf.objects.add((Object)kf.knotsSeam);
        kf.objects.add((Object)kf.selectedKnot);
        kf.objects.add((Object)kf.highlightedKnot);
        kf.scene = this.scene;
    }

    @Override
    public void setUpEntity(Entity entity) {
    }
}

