/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Vector3;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.LocationMark;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.system.update.GraphUpdater;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Constants;
import gaiasky.util.math.Vector3Q;

public class LocInitializer
extends AbstractInitSystem {
    public LocInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        LocationMark loc = (LocationMark)Mapper.loc.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        graph.mustUpdateFunction = GraphUpdater::mustUpdateLoc;
        graph.positionUpdaterConsumer = GraphUpdater::updatePositionLocationMark;
        label.label = true;
        label.labelMax = 1.0f;
        label.textScale = 1.0E-7f;
        label.labelFactor = 0.15f;
        label.renderConsumer = LabelEntityRenderSystem::renderLocation;
        label.depthBufferConsumer = LabelView::noTextDepthBuffer;
        label.renderFunction = LabelView::renderTextLocation;
        label.labelPosition = new Vector3Q();
        if (body.color == null) {
            body.color = new float[]{0.7f, 0.6f, 0.0f, 0.4f};
        }
        body.size *= (float)Constants.KM_TO_U;
        loc.location3d = new Vector3();
        loc.sizeKm = (float)((double)body.size * Constants.U_TO_KM);
        loc.displayName = "  " + base.getLocalizedName();
    }

    @Override
    public void setUpEntity(Entity entity) {
        Entity papa;
        LocationMark loc = (LocationMark)Mapper.loc.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        if ((loc.locationType == null || loc.locationType.isEmpty()) && (papa = graph.parent) != null) {
            Base pBase = (Base)Mapper.base.get(papa);
            loc.locationType = pBase.getLocalizedName();
        }
    }
}

