/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.math.Matrix4;
import gaiasky.data.AssetBean;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Mesh;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.record.RotateTransform;
import gaiasky.scene.record.ScaleTransform;
import gaiasky.scene.record.TranslateTransform;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;

public class MeshInitializer
extends AbstractInitSystem {
    public MeshInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Model model = (Model)Mapper.model.get(entity);
        model.renderConsumer = ModelEntityRenderSystem::renderMeshModel;
        ModelComponent mc = model.model;
        if (mc != null) {
            mc.initialize(true);
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        Mesh mesh = (Mesh)Mapper.mesh.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        ModelComponent mc = model.model;
        label.label = true;
        label.textScale = 0.2f;
        label.labelFactor = 8.0E-4f;
        label.labelMax = 1.0f;
        label.renderConsumer = LabelEntityRenderSystem::renderMesh;
        label.renderFunction = LabelView::renderTextEssential;
        AssetManager manager = AssetBean.manager();
        if (mc != null) {
            try {
                mc.doneLoading(manager, graph.localTransform, body.color, true);
                if (mesh.shading == Mesh.MeshShading.ADDITIVE) {
                    mc.setDepthTest(0, false);
                }
            }
            catch (Exception e) {
                mc = null;
            }
        }
        this.recomputePositioning(entity, mc, mesh);
    }

    private void recomputePositioning(Entity entity, ModelComponent mc, Mesh mesh) {
        if (mc != null) {
            if (mesh.coordinateSystem == null) {
                mesh.coordinateSystem = new Matrix4();
            }
            MeshInitializer.initializeCoordinateSystem(entity, mesh);
        }
    }

    public static void initializeCoordinateSystem(Entity entity, Mesh mesh) {
        mesh.coordinateSystem.idt();
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        if (transform.matrix != null) {
            Matrix4 m = new Matrix4();
            transform.matrix.putIn(m);
            mesh.coordinateSystem.mul(m);
        }
        Body body = (Body)Mapper.body.get(entity);
        AffineTransformations affine = (AffineTransformations)Mapper.affine.get(entity);
        if (affine != null) {
            RotateTransform rotate = affine.getRotateTransform();
            ScaleTransform scale = affine.getScaleTransform();
            TranslateTransform translate = affine.getTranslateTransform();
            if (rotate != null) {
                rotate.apply(mesh.coordinateSystem);
            }
            if (translate != null) {
                body.pos.set(translate.getVector());
                translate.apply(mesh.coordinateSystem);
            }
            if (scale != null) {
                scale.apply(mesh.coordinateSystem);
            }
        }
    }
}

