/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.data.AssetBean;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Atmosphere;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Billboard;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Celestial;
import gaiasky.scene.component.Cloud;
import gaiasky.scene.component.Coordinates;
import gaiasky.scene.component.Fade;
import gaiasky.scene.component.Focus;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.component.MotorEngine;
import gaiasky.scene.component.Orientation;
import gaiasky.scene.component.ParentOrientation;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.entity.FocusActive;
import gaiasky.scene.entity.FocusHit;
import gaiasky.scene.entity.SpacecraftRadio;
import gaiasky.scene.record.AtmosphereComponent;
import gaiasky.scene.record.CloudComponent;
import gaiasky.scene.record.MachineDefinition;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.billboard.BillboardEntityRenderSystem;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.system.update.GraphUpdater;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.coord.SpacecraftCoordinates;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.DepthTestAttribute;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class ModelInitializer
extends AbstractInitSystem {
    private static final Logger.Log logger = Logger.getLogger(ModelInitializer.class);
    private SpacecraftRadio radio;

    public ModelInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    public static void initializeModelSize(Model model) {
        if (model.model != null && model.model.params != null) {
            if (model.model.params.containsKey("diameter")) {
                model.modelSize = (Double)model.model.params.get("diameter");
            } else if (model.model.params.containsKey("size")) {
                model.modelSize = (Double)model.model.params.get("size");
            } else if (model.model.params.containsKey("width")) {
                model.modelSize = (Double)model.model.params.get("width");
            } else if (model.model.params.containsKey("height")) {
                model.modelSize = (Double)model.model.params.get("height");
            } else if (model.model.params.containsKey("depth")) {
                model.modelSize = (Double)model.model.params.get("depth");
            } else if (model.model.params.containsKey("side")) {
                model.modelSize = (Double)model.model.params.get("side");
            }
        }
    }

    @Override
    public void initializeEntity(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Celestial celestial = (Celestial)Mapper.celestial.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
        SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        Atmosphere atmosphere = (Atmosphere)Mapper.atmosphere.get(entity);
        Cloud cloud = (Cloud)Mapper.cloud.get(entity);
        Orientation orientation = (Orientation)Mapper.orientation.get(entity);
        MotorEngine engine = (MotorEngine)Mapper.engine.get(entity);
        Fade fade = (Fade)Mapper.fade.get(entity);
        Focus focus = (Focus)Mapper.focus.get(entity);
        Billboard bb = (Billboard)Mapper.billboard.get(entity);
        boolean isPlanet = atmosphere != null || cloud != null;
        boolean isSatellite = base.ct.isEnabled(ComponentTypes.ComponentType.Satellites);
        boolean isSpacecraft = engine != null;
        boolean isBillboard = fade != null;
        boolean isBillboardGal = Mapper.tagBillboardGalaxy.has(entity);
        focus.hitCoordinatesConsumer = FocusHit::addHitCoordinateModel;
        focus.hitRayConsumer = FocusHit::addHitRayModel;
        label.label = true;
        label.renderConsumer = LabelEntityRenderSystem::renderCelestial;
        label.renderFunction = LabelView::renderTextCelestial;
        body.size = engine != null ? (float)((double)body.size * Constants.KM_TO_U) : (float)((double)body.size * (body.sizeIsRadiusFlag ? 2.0 : 1.0) * (body.sizeInUnitsFlag ? 1.0 : Constants.KM_TO_U));
        if (isSpacecraft) {
            this.initializeSpacecraft(entity, base, body, graph, model, scaffolding, engine, label);
        }
        this.initializeModel(entity, base, body, model, celestial, bb, sa, label, scaffolding, graph, focus, isBillboardGal);
        if (isBillboard) {
            this.initializeBillboard(scaffolding, sa, label, isBillboardGal);
        }
        if (isSatellite) {
            this.initializeSatellite(scaffolding, sa, label);
        }
        if (isPlanet) {
            this.initializePlanet(base, body, model, scaffolding, sa, label, atmosphere, cloud);
        }
        if (orientation != null) {
            this.initializeOrientation(orientation);
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        Atmosphere atmosphere = (Atmosphere)Mapper.atmosphere.get(entity);
        Cloud cloud = (Cloud)Mapper.cloud.get(entity);
        Orientation orientation = (Orientation)Mapper.orientation.get(entity);
        ParentOrientation parentOrientation = (ParentOrientation)Mapper.parentOrientation.get(entity);
        MotorEngine engine = (MotorEngine)Mapper.engine.get(entity);
        Fade fade = (Fade)Mapper.fade.get(entity);
        AssetManager manager = AssetBean.manager();
        if (model != null && model.model != null) {
            model.model.doneLoading(manager, graph.localTransform, body.color);
            boolean bl = model.model.tessellated = Settings.settings.scene.renderer.elevation.type.isTessellation() && (double)body.size > 500.0 * Constants.KM_TO_U;
        }
        if (atmosphere != null && model != null) {
            this.initializeAtmosphere(manager, atmosphere.atmosphere, model.model, body.size);
        }
        if (cloud != null) {
            this.initializeClouds(manager, cloud.cloud);
        }
        if (parentOrientation != null) {
            if (parentOrientation.parentOrientation) {
                parentOrientation.setRigidRotation(((Orientation)graph.parent.getComponent(Orientation.class)).rotationComponent);
            }
            parentOrientation.orientationf = new Matrix4();
        }
        if (orientation != null) {
            orientation.setUp(manager);
        }
        if (engine != null) {
            EventManager.publish(Event.SPACECRAFT_LOADED, this, entity);
            if (this.radio != null) {
                EventManager.instance.unsubscribe((IObserver)this.radio, Event.CAMERA_MODE_CMD);
                this.radio = null;
            }
            EventManager.instance.subscribe((IObserver)new SpacecraftRadio(entity), Event.CAMERA_MODE_CMD, Event.SPACECRAFT_STABILISE_CMD, Event.SPACECRAFT_STOP_CMD, Event.SPACECRAFT_THRUST_DECREASE_CMD, Event.SPACECRAFT_THRUST_INCREASE_CMD, Event.SPACECRAFT_THRUST_SET_CMD, Event.SPACECRAFT_MACHINE_SELECTION_CMD);
        }
        if (fade != null && model != null && model.model != null && model.model.instance != null) {
            Array<Material> mats = model.model.instance.materials;
            for (Material mat : mats) {
                mat.set((Attribute)new DepthTestAttribute(false));
            }
        }
    }

    private void initializeSpacecraft(Entity entity, Base base, Body body, GraphNode graph, Model model, ModelScaffolding scaffolding, MotorEngine engine, Label label) {
        model.renderConsumer = ModelEntityRenderSystem::renderSpacecraft;
        graph.positionUpdaterConsumer = GraphUpdater::updateSpacecraft;
        base.ct = new ComponentTypes(ComponentTypes.ComponentType.Satellites);
        engine.rotationMatrix = new Matrix4();
        this.radio = new SpacecraftRadio(entity);
        EventManager.instance.subscribe((IObserver)this.radio, Event.CAMERA_MODE_CMD);
        engine.force = new Vector3D();
        engine.accel = new Vector3D();
        engine.vel = new Vector3D();
        body.pos.set(1.0E7 * Constants.KM_TO_U, 0.0, 1.0E8 * Constants.KM_TO_U);
        engine.direction = new Vector3D(1.0, 0.0, 0.0);
        engine.up = new Vector3D(0.0, 1.0, 0.0);
        engine.dirup = new Pair<Vector3D, Vector3D>(engine.direction, engine.up);
        engine.posf = new Vector3();
        engine.directionf = new Vector3(1.0f, 0.0f, 0.0f);
        engine.upf = new Vector3(0.0f, 1.0f, 0.0f);
        engine.thrust = new Vector3D(engine.direction).scl(engine.thrustMagnitude);
        engine.currentEnginePower = 0.0;
        engine.leveling = false;
        engine.qf = new Quaternion();
        this.setToMachine(engine.machines[engine.currentMachine], false, body, model, scaffolding, engine);
        SpacecraftCoordinates scc = new SpacecraftCoordinates();
        scc.setSpacecraft(engine);
        Coordinates coord = (Coordinates)Mapper.coordinates.get(entity);
        coord.coordinates = scc;
        label.label = false;
        label.labelMax = 0.0f;
        label.renderConsumer = null;
        label.labelFactor = 0.0f;
    }

    private void initializeModel(Entity entity, Base base, Body body, Model model, Celestial celestial, Billboard bb, SolidAngle sa, Label label, ModelScaffolding scaffolding, GraphNode graph, Focus focus, boolean isBillboardGal) {
        bb.renderConsumer = isBillboardGal ? BillboardEntityRenderSystem::renderBillboardGalaxy : BillboardEntityRenderSystem::renderBillboardCelestial;
        focus.activeFunction = FocusActive::isFocusActiveTrue;
        if (model.renderConsumer == null) {
            model.renderConsumer = ModelEntityRenderSystem::renderGenericModel;
        }
        ModelInitializer.initializeModelSize(model);
        celestial.innerRad = 0.2f;
        graph.orientation = new Matrix4D();
        scaffolding.billboardSizeFactor = 2.0f;
        scaffolding.locThresholdLabel = 1000.0f;
        scaffolding.locVaMultiplier = 2.8f;
        sa.thresholdPoint = FastMath.toRadians((double)0.3);
        sa.thresholdLabel = Math.toRadians(1.0E-6) / (double)Settings.settings.scene.label.number * (base.ct.get(ComponentTypes.ComponentType.Moons.ordinal()) ? 3000.0 : 25.0);
        if (isBillboardGal) {
            sa.thresholdQuad = FastMath.toRadians((double)0.3);
        }
        label.labelMax = (float)(5.0E-5 / Constants.DISTANCE_SCALE_FACTOR);
        if (label.labelFactor == 0.0f) {
            label.labelFactor = 1.0f;
        }
        if (this.isRandomizeSurface(scaffolding)) {
            model.model = new ModelComponent(true);
            model.model.randomizeAll(scaffolding.getSeed("model"), body.size);
            if (Settings.settings.program.debugInfo) {
                logger.debug("::" + base.getName() + "::");
                logger.debug("============MODEL===========");
                model.model.print(logger);
            }
        }
        if (Mapper.cloud.has(entity)) {
            Cloud cloud = (Cloud)Mapper.cloud.get(entity);
            if (model.model != null && model.model.mtc != null && cloud.cloud != null) {
                if (cloud.cloud.diffuseSvt != null && cloud.cloud.svtParams != null) {
                    cloud.cloud.diffuse = null;
                    cloud.cloud.diffuseCubemap = null;
                } else if (cloud.cloud.diffuse != null && !cloud.cloud.diffuse.endsWith("generate")) {
                    model.model.mtc.ao = cloud.cloud.diffuse;
                    model.model.mtc.setOcclusionClouds(true);
                } else if (cloud.cloud.diffuseCubemap != null) {
                    model.model.mtc.setAmbientOcclusionCubemap(cloud.cloud.diffuseCubemap.location);
                    model.model.mtc.setOcclusionClouds(true);
                }
            }
        }
        if (model.model != null) {
            model.model.initialize(base.getName());
        }
    }

    private void initializeBillboard(ModelScaffolding scaffolding, SolidAngle sa, Label label, boolean isBillboardGalaxy) {
        double baseThreshold = FastMath.toRadians((double)0.3);
        sa.thresholdLabel = FastMath.toRadians((double)0.2);
        sa.thresholdNone = 0.002;
        sa.thresholdPoint = baseThreshold / 1.0E9;
        if (!isBillboardGalaxy) {
            sa.thresholdQuad = baseThreshold / 8.0;
        }
        label.textScale = 0.3f;
        label.solidAnglePow = 1.0f;
        label.labelFactor = (float)(10.0 * Constants.DISTANCE_SCALE_FACTOR);
        scaffolding.billboardSizeFactor = 6.0E-4f;
    }

    private void initializePlanet(Base base, Body body, Model model, ModelScaffolding scaffolding, SolidAngle sa, Label label, Atmosphere atmosphere, Cloud cloud) {
        model.renderConsumer = ModelEntityRenderSystem::renderPlanet;
        double thPoint = sa.thresholdPoint;
        sa.thresholdNone = thPoint / 1000000.0;
        sa.thresholdPoint = thPoint / 30000.0;
        sa.thresholdQuad = thPoint / 2.0;
        label.labelFactor = (float)(15.0 * Constants.DISTANCE_SCALE_FACTOR);
        if (this.isRandomizeCloud(scaffolding)) {
            cloud.cloud = new CloudComponent();
            cloud.cloud.randomizeAll(scaffolding.getSeed("cloud"), body.size);
            logger.debug("============CLOUD===========");
            cloud.cloud.print(logger);
        }
        if (this.isRandomizeAtmosphere(scaffolding)) {
            atmosphere.atmosphere = new AtmosphereComponent();
            atmosphere.atmosphere.randomizeAll(scaffolding.getSeed("atmosphere"), (double)body.size / 2.0);
            logger.debug("============ATM===========");
            atmosphere.atmosphere.print(logger);
        }
        if (cloud.cloud != null) {
            cloud.cloud.materialComponent = model.model.mtc;
            cloud.cloud.initialize(base.getName(), false);
        }
    }

    public void initializeSatellite(ModelScaffolding scaffolding, SolidAngle sa, Label label) {
        double thPoint = sa.thresholdPoint;
        sa.thresholdNone = thPoint / 1.0E18;
        sa.thresholdPoint = thPoint / 3.3E10;
        sa.thresholdQuad = thPoint / 8.0;
        sa.thresholdLabel = Math.toRadians(1.0E-7) / (double)Settings.settings.scene.label.number;
        label.labelFactor = (float)(5.0 * Constants.DISTANCE_SCALE_FACTOR);
        label.labelMax *= 2.0f;
        scaffolding.billboardSizeFactor = 10.0f;
    }

    public void initializeOrientation(Orientation orientation) {
        orientation.initialize(AssetBean.manager());
    }

    public boolean isRandomizeSurface(ModelScaffolding scaffolding) {
        return scaffolding.randomize != null && (scaffolding.randomize.contains("surface") || scaffolding.randomize.contains("model"));
    }

    protected boolean isRandomizeAtmosphere(ModelScaffolding scaffolding) {
        return scaffolding.randomize != null && scaffolding.randomize.contains("atmosphere");
    }

    protected boolean isRandomizeCloud(ModelScaffolding scaffolding) {
        return scaffolding.randomize != null && scaffolding.randomize.contains("cloud");
    }

    private void setToMachine(MachineDefinition machine, boolean initialize, Body body, Model model, ModelScaffolding scaffolding, MotorEngine engine) {
        model.model = machine.getModel();
        engine.thrustMagnitude = machine.getPower() * 1.0E12;
        engine.fullPowerTime = machine.getFullpowertime();
        engine.mass = machine.getMass();
        scaffolding.selfShadow = machine.isSelfShadow();
        engine.drag = machine.getDrag();
        engine.responsiveness = MathUtilsDouble.lint(machine.getResponsiveness(), 0.0, 1.0, 500000.0, 5000000.0);
        engine.machineName = machine.getName();
        body.setSize(machine.getSize() * Constants.KM_TO_U);
        if (initialize && !model.model.isModelLoading() && !model.model.isModelInitialised()) {
            model.model.initialize(null);
        }
    }

    private void initializeAtmosphere(AssetManager manager, AtmosphereComponent atmosphereComponent, ModelComponent modelComponent, float size) {
        if (atmosphereComponent != null) {
            atmosphereComponent.doneLoading((Material)modelComponent.instance.materials.first(), size);
        }
    }

    private void initializeClouds(AssetManager manager, CloudComponent cloudComponent) {
        if (cloudComponent != null) {
            cloudComponent.doneLoading(manager);
        }
    }
}

