/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.data.AssetBean;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Billboard;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Celestial;
import gaiasky.scene.component.Distance;
import gaiasky.scene.component.Focus;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Hip;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Magnitude;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.ParticleExtra;
import gaiasky.scene.component.ProperMotion;
import gaiasky.scene.component.RenderType;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.entity.FocusActive;
import gaiasky.scene.entity.FocusHit;
import gaiasky.scene.entity.ParticleUtils;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.billboard.BillboardEntityRenderSystem;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.FocusView;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import net.jafama.FastMath;

public class ParticleInitializer
extends AbstractInitSystem
implements IObserver {
    private final ParticleUtils utils = new ParticleUtils();
    private final double discFactor = 1.5;
    private final FocusView view;
    private final Vector3Q B31 = new Vector3Q();
    private final Vector3D D31 = new Vector3D();

    public ParticleInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
        this.view = new FocusView();
        EventManager.instance.subscribe((IObserver)this, Event.STAR_POINT_SIZE_CMD);
    }

    @Override
    public void initializeEntity(Entity entity) {
        this.view.setEntity(entity);
        Base base = this.view.base;
        Celestial celestial = (Celestial)Mapper.celestial.get(entity);
        ProperMotion pm = (ProperMotion)Mapper.pm.get(entity);
        ParticleExtra extra = (ParticleExtra)Mapper.extra.get(entity);
        SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        RenderType render = (RenderType)Mapper.renderType.get(entity);
        Hip hip = (Hip)Mapper.hip.get(entity);
        Focus focus = (Focus)Mapper.focus.get(entity);
        Billboard bb = (Billboard)Mapper.billboard.get(entity);
        focus.activeFunction = FocusActive::isFocusActiveTrue;
        bb.renderConsumer = BillboardEntityRenderSystem::renderBillboardCelestial;
        if (hip != null) {
            this.initializeStar(base, celestial, pm, extra, sa, label, render, focus);
        } else {
            this.initializeParticle(base, celestial, pm, extra, sa, label, render, focus);
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
        this.view.setEntity(entity);
        Body body = this.view.body;
        Celestial celestial = (Celestial)Mapper.celestial.get(entity);
        Magnitude mag = this.view.getMag();
        ParticleExtra extra = (ParticleExtra)Mapper.extra.get(entity);
        gaiasky.scene.component.Coordinates coordinates = (gaiasky.scene.component.Coordinates)Mapper.coordinates.get(entity);
        if (Mapper.hip.has(entity)) {
            Distance dist = (Distance)Mapper.distance.get(entity);
            this.setUpStar(entity, body, celestial, mag, extra, dist, coordinates);
            Model model = (Model)Mapper.model.get(entity);
            model.renderConsumer = ModelEntityRenderSystem::renderParticleStarModel;
            this.utils.initModel(AssetBean.manager(), model);
        } else {
            this.setUpParticle(entity, body, celestial, mag, extra, coordinates);
        }
    }

    private void baseInitialization(ProperMotion pm, ParticleExtra extra, Celestial celestial, SolidAngle sa, RenderType render) {
        if (pm.pm == null) {
            pm.pm = new Vector3();
            pm.pmSph = new Vector3();
            pm.hasPm = false;
        } else {
            if (pm.pm.len2() == 0.0f && pm.pmSph.len2() != 0.0f) {
                Coordinates.cartesianToSpherical(this.view.body.pos, this.D31);
                if (this.view.body.posSph == null) {
                    this.view.body.posSph = new Vector2D();
                }
                this.view.body.posSph.set((float)(57.29577951308232 * this.D31.x), (float)(57.29577951308232 * this.D31.y));
                double distPc = this.view.getPos().lenDouble() * Constants.U_TO_PC;
                Vector3D pmv = Coordinates.properMotionsToCartesian(pm.pmSph.x, pm.pmSph.y, pm.pmSph.z, FastMath.toRadians((double)this.view.getAlpha()), FastMath.toRadians((double)this.view.getDelta()), distPc, new Vector3D());
                pmv.put(pm.pm);
            }
            pm.hasPm = pm.pm.len2() != 0.0f;
        }
        sa.thresholdNone = Settings.settings.scene.star.threshold.none;
        sa.thresholdPoint = Settings.settings.scene.star.threshold.point;
        sa.thresholdQuad = Settings.settings.scene.star.threshold.quad;
        if (render.renderGroup == null) {
            render.renderGroup = RenderGroup.BILLBOARD_STAR;
        }
        if (extra.primitiveRenderScale <= 0.0) {
            extra.primitiveRenderScale = 1.0;
        }
        float pSize = Settings.settings.scene.star.pointSize < 0.0f ? 8.0f : Settings.settings.scene.star.pointSize;
        celestial.innerRad = (0.006000000284984708 + (double)(pSize * 0.008f)) * 1.5;
    }

    private void initializeParticle(Base base, Celestial celestial, ProperMotion pm, ParticleExtra extra, SolidAngle sa, Label label, RenderType render, Focus focus) {
        this.baseInitialization(pm, extra, celestial, sa, render);
        sa.thresholdLabel = sa.thresholdPoint * (double)0.01f / (double)Settings.settings.scene.label.number;
        label.textScale = 0.1f;
        label.labelFactor = 0.13f;
        label.labelMax = 0.005f;
        label.renderConsumer = LabelEntityRenderSystem::renderCelestial;
        label.renderFunction = LabelView::renderTextParticle;
        if (base.ct == null) {
            base.ct = new ComponentTypes(ComponentTypes.ComponentType.Galaxies);
        }
        focus.hitCoordinatesConsumer = FocusHit::addHitCoordinateCelestial;
        focus.hitRayConsumer = FocusHit::addHitRayCelestial;
    }

    private void setUpParticle(Entity entity, Body body, Celestial celestial, Magnitude mag, ParticleExtra extra, gaiasky.scene.component.Coordinates coordinates) {
        this.setDerivedAttributes(entity, body, celestial, mag, coordinates, extra, false);
        extra.radius = (double)body.size * 1.31526E-6;
    }

    private void initializeStar(Base base, Celestial celestial, ProperMotion pm, ParticleExtra extra, SolidAngle sa, Label label, RenderType render, Focus focus) {
        this.baseInitialization(pm, extra, celestial, sa, render);
        sa.thresholdLabel = sa.thresholdPoint / (double)Settings.settings.scene.label.number;
        label.label = true;
        label.textScale = 0.2f;
        label.labelFactor = 0.13f;
        label.labelMax = 0.01f;
        label.renderConsumer = LabelEntityRenderSystem::renderCelestial;
        label.renderFunction = LabelView::renderTextParticle;
        if (base.ct == null) {
            base.ct = new ComponentTypes(ComponentTypes.ComponentType.Stars);
        }
        focus.hitCoordinatesConsumer = FocusHit::addHitCoordinateStar;
        focus.hitRayConsumer = FocusHit::addHitRayCelestial;
    }

    private void setUpStar(Entity entity, Body body, Celestial celestial, Magnitude mag, ParticleExtra extra, Distance dist, gaiasky.scene.component.Coordinates coordinates) {
        this.setDerivedAttributes(entity, body, celestial, mag, coordinates, extra, true);
        extra.radius = (double)body.size * 1.31526E-6;
        dist.distance = 17200.4643429 * extra.radius;
    }

    private void setDerivedAttributes(Entity entity, Body body, Celestial celestial, Magnitude mag, gaiasky.scene.component.Coordinates coordinates, ParticleExtra extra, boolean isStar) {
        double distPc;
        if (coordinates.coordinates != null) {
            GraphNode graph = (GraphNode)Mapper.graph.get(entity);
            distPc = coordinates.coordinates.getEquatorialCartesianCoordinates(GaiaSky.instance.time.getTime(), this.B31).lenDouble() * Constants.U_TO_PC;
            if (graph.parent != null) {
                distPc += EntityUtils.getAbsolutePosition(graph.parent, this.B31).lenDouble() * Constants.U_TO_PC;
            }
        } else {
            distPc = EntityUtils.getAbsolutePosition(entity, this.B31).lenDouble() * Constants.U_TO_PC;
        }
        boolean finiteApparent = Float.isFinite(mag.appMag);
        boolean finiteAbsolute = Float.isFinite(mag.absMag);
        if (!finiteApparent && !finiteAbsolute) {
            mag.appMag = isStar ? 10.0f : -5.0f;
            mag.absMag = (float)AstroUtils.apparentToAbsoluteMagnitude(distPc, mag.appMag);
        } else if (!finiteApparent) {
            mag.appMag = (float)AstroUtils.absoluteToApparentMagnitude(distPc, mag.absMag);
        } else if (!finiteAbsolute) {
            mag.absMag = (float)AstroUtils.apparentToAbsoluteMagnitude(distPc, mag.appMag);
        }
        this.setRGB(body, celestial);
        if (body.size <= 0.0f) {
            double flux = FastMath.pow((double)10.0, (double)(-mag.absMag / 2.5f));
            body.size = isStar ? (float)(Math.min(Math.pow(flux, 0.5) * Constants.PC_TO_U * (double)0.22f, 1.0E9) / 1.5) : (float)(Math.log(Math.pow(flux, 10.0)) * Constants.PC_TO_U);
        }
        extra.computedSize = 0.0;
    }

    private void setRGB(Body body, Celestial celestial) {
        if (body.color == null) {
            body.color = ColorUtils.BVtoRGB(celestial.colorBv);
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        GaiaSky.postRunnable(() -> {
            if (this.engineBackup != null) {
                ImmutableArray entities = this.engineBackup.getEntitiesFor(this.getFamily());
                if (event == Event.STAR_POINT_SIZE_CMD) {
                    for (Entity entity : entities) {
                        ((Celestial)Mapper.celestial.get((Entity)entity)).innerRad = (float)((0.006000000284984708 + (double)(((Float)data[0]).floatValue() * 0.008f)) * 1.5);
                    }
                }
            }
        });
    }
}

