/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.TextureArray;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.IntSet;
import gaiasky.GaiaSky;
import gaiasky.data.AssetBean;
import gaiasky.data.api.IParticleGroupDataProvider;
import gaiasky.data.api.IStarGroupDataProvider;
import gaiasky.data.group.STILDataProvider;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Billboard;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Focus;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Line;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.entity.FocusHit;
import gaiasky.scene.entity.ParticleUtils;
import gaiasky.scene.record.ParticleType;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.billboard.BillboardEntityRenderSystem;
import gaiasky.scene.system.render.draw.line.LineEntityRenderSystem;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.task.ParticleSetUpdaterTask;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.camera.Proximity;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.gdx.TextureArrayLoader;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3Q;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.jafama.FastMath;
import org.apache.commons.io.FileUtils;

public class ParticleSetInitializer
extends AbstractInitSystem {
    private static final Logger.Log logger = Logger.getLogger(ParticleSetInitializer.class);
    private final ParticleUtils utils = new ParticleUtils();

    public ParticleSetInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        ParticleSet particleSet = (ParticleSet)Mapper.particleSet.get(entity);
        StarSet starSet = (StarSet)Mapper.starSet.get(entity);
        Focus focus = (Focus)Mapper.focus.get(entity);
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        focus.hitCoordinatesConsumer = FocusHit::addHitCoordinateParticleSet;
        focus.hitRayConsumer = FocusHit::addHitRayParticleSet;
        if (starSet == null) {
            this.initializeCommon(entity, base, particleSet, label);
            this.initializeParticleSet(entity, particleSet, label, transform);
        } else {
            this.initializeCommon(entity, base, starSet, label);
            this.initializeStarSet(entity, starSet, label, transform);
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
        StarSet starSet;
        Base base = (Base)Mapper.base.get(entity);
        ParticleSet particleSet = (ParticleSet)Mapper.particleSet.get(entity);
        AssetManager manager = AssetBean.manager();
        if (manager.contains(base.getName() + " Textures")) {
            particleSet.textureArray = (TextureArray)manager.get(base.getName() + " Textures");
        }
        if ((starSet = (StarSet)Mapper.starSet.get(entity)) != null) {
            starSet.variableStars = !starSet.pointData.isEmpty() && ((IParticleRecord)starSet.pointData.getFirst()).isVariable();
            this.initSortingData(entity, starSet);
            Model model = (Model)Mapper.model.get(entity);
            model.renderConsumer = ModelEntityRenderSystem::renderParticleStarSetModel;
            GaiaSky.postRunnable(() -> this.utils.initModel(AssetBean.manager(), model));
        } else {
            if (particleSet.numLabels > 0) {
                this.initSortingData(entity, particleSet);
            }
            if (particleSet.modelFile != null && manager.isLoaded(Settings.settings.data.dataFile(particleSet.modelFile))) {
                particleSet.model = (IntModel)manager.get(Settings.settings.data.dataFile(particleSet.modelFile), IntModel.class);
            }
        }
    }

    private void initializeCommon(Entity entity, Base base, ParticleSet set, Label label) {
        if (base.id < 0L) {
            base.id = ParticleSet.getNextSequence();
        }
        if (set.factor == null) {
            set.factor = 1.0;
        }
        set.lastSortTime = -1.0;
        set.cPosD = new Vector3Q();
        set.lastSortCameraPos = new Vector3Q(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        set.proximity = new Proximity(3);
        set.focusPosition = new Vector3Q();
        set.focusPositionSph = new Vector2D();
        set.entity = entity;
        if (set.epochJd <= 0.0) {
            set.epochJd = AstroUtils.JD_J2015_5;
        }
        set.forceLabel = new IntSet();
        set.labelColors = new IntMap();
        label.label = true;
        label.textScale = 0.3f;
        label.renderFunction = LabelView::renderTextBase;
        AssetManager manager = AssetBean.manager();
        if (set.textureFiles != null) {
            Array actualFilePaths = new Array();
            for (String textureFile : set.textureFiles) {
                String unpackedFile = Settings.settings.data.dataFile(textureFile);
                Path galLocationPath = Path.of(unpackedFile, new String[0]);
                if (!Files.exists(galLocationPath, new LinkOption[0])) continue;
                if (Files.isDirectory(galLocationPath, new LinkOption[0])) {
                    Collection galaxyFiles = FileUtils.listFiles((File)galLocationPath.toFile(), (String[])new String[]{"png", "jpeg", "jpg"}, (boolean)true);
                    if (galaxyFiles.isEmpty()) continue;
                    for (File f : galaxyFiles) {
                        actualFilePaths.add((Object)f.getAbsolutePath());
                    }
                    continue;
                }
                actualFilePaths.add((Object)galLocationPath.toAbsolutePath().toString());
            }
            actualFilePaths.sort();
            if (!actualFilePaths.isEmpty()) {
                manager.load(base.getName() + " Textures", TextureArray.class, (AssetLoaderParameters)new TextureArrayLoader.TextureArrayParameter((Array<String>)actualFilePaths));
            }
        }
        if (set.proximityDescriptorsLocation != null && !set.proximityDescriptorsLocation.isEmpty()) {
            set.proximityLoadingFlag = true;
            set.proximityDescriptorsPath = Settings.settings.data.dataPath(set.proximityDescriptorsLocation);
            set.proximityLoaded = new IntSet(10);
            set.proximityMissing = new IntSet(10);
        } else {
            set.proximityThreshold = -1.0;
        }
    }

    private void initializeParticleSet(Entity entity, ParticleSet set, Label label, RefSysTransform transform) {
        boolean initializeData;
        set.isStars = false;
        boolean bl = initializeData = set.pointData == null;
        if (initializeData && set.provider != null) {
            try {
                Class<?> clazz = Class.forName(set.provider);
                IParticleGroupDataProvider provider = (IParticleGroupDataProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (set.providerParams != null) {
                    provider.setProviderParams(set.providerParams);
                } else {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("type", "PARTICLES");
                    provider.setProviderParams(params);
                }
                provider.setTransformMatrix(transform.matrix);
                set.setData(provider.loadData(set.datafile, (double)set.factor));
                boolean bl2 = set.isExtended = !set.data().isEmpty() && set.data().getFirst().getType() == ParticleType.PARTICLE_EXT;
                if (provider instanceof STILDataProvider) {
                    STILDataProvider stil = (STILDataProvider)provider;
                    set.setColumnInfoList(stil.getColumnInfoList());
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error(e);
                set.pointData = null;
            }
        }
        this.computeMinMeanMaxDistances(set);
        this.computeMeanPosition(entity, set);
        this.setLabelPosition(entity);
        label.labelMax = 1.0f;
        label.labelFactor = 0.001f;
        label.renderConsumer = LabelEntityRenderSystem::renderParticleSet;
        int n = set.numLabels = set.numLabels >= 0 ? set.numLabels : Settings.settings.scene.particleGroups.numLabels;
        if (set.modelFile != null && !set.modelFile.isBlank()) {
            AssetBean.addAsset(Settings.settings.data.dataFile(set.modelFile), IntModel.class);
        }
    }

    public void initializeStarSet(Entity entity, StarSet set, Label label, RefSysTransform transform) {
        boolean initializeData;
        set.isStars = true;
        set.isExtended = false;
        boolean bl = initializeData = set.pointData == null;
        if (initializeData && set.provider != null) {
            try {
                Class<?> clazz = Class.forName(set.provider);
                IStarGroupDataProvider provider = (IStarGroupDataProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                provider.setProviderParams(set.providerParams);
                provider.setTransformMatrix(transform.matrix);
                List<IParticleRecord> l = provider.loadData(set.datafile, (double)set.factor);
                set.setData(l, true);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error(e);
                set.pointData = null;
            }
        }
        this.computeMeanPosition(entity, set);
        this.setLabelPosition(entity);
        if (set.variabilityEpochJd <= 0.0) {
            set.variabilityEpochJd = AstroUtils.JD_J2010;
        }
        label.renderConsumer = LabelEntityRenderSystem::renderStarSet;
        label.renderFunction = LabelView::renderTextBase;
        set.numLabels = set.numLabels >= 0 ? set.numLabels : Settings.settings.scene.star.group.numLabels;
        Line line = (Line)Mapper.line.get(entity);
        line.lineWidth = 1.0f;
        line.renderConsumer = LineEntityRenderSystem::renderStarSet;
        Billboard bb = (Billboard)Mapper.billboard.get(entity);
        bb.renderConsumer = BillboardEntityRenderSystem::renderBillboardStarSet;
        set.numBillboards = set.numBillboards > 0 ? set.numBillboards : Settings.settings.scene.star.group.numBillboard;
    }

    public void computeMinMeanMaxDistances(ParticleSet set) {
        set.meanDistance = 0.0;
        set.maxDistance = Double.MIN_VALUE;
        set.minDistance = Double.MAX_VALUE;
        ArrayList<Double> distances = new ArrayList<Double>();
        for (IParticleRecord point : set.data()) {
            double dist = this.len(point.x(), point.y(), point.z());
            if (!Double.isFinite(dist)) continue;
            distances.add(dist);
            set.maxDistance = FastMath.max((double)set.maxDistance, (double)dist);
            set.minDistance = FastMath.min((double)set.minDistance, (double)dist);
        }
        distances.sort(Double::compare);
        int idx = (int)FastMath.ceil((double)(0.9 * (double)distances.size()));
        set.meanDistance = (Double)distances.get(idx - 1) / 2.0;
    }

    public void computeMeanPosition(Entity entity, ParticleSet set) {
        Body body = (Body)Mapper.body.get(entity);
        if (set.meanPosition != null) {
            body.pos.set(set.meanPosition);
        } else if (set.data() == null || set.data().isEmpty()) {
            body.pos.set(0.0f, 0.0f, 0.0f);
        } else {
            for (IParticleRecord point : set.data()) {
                body.pos.add(point.x(), point.y(), point.z());
            }
            body.pos.scl(1.0 / (double)set.data().size());
        }
    }

    public void setLabelPosition(Entity entity) {
        if (Mapper.label.has(entity) && Mapper.body.has(entity)) {
            Label label = (Label)Mapper.label.get(entity);
            Body body = (Body)Mapper.body.get(entity);
            if (label.labelPosition == null) {
                label.labelPosition = new Vector3Q(body.pos);
            }
        } else {
            Base base = (Base)entity.getComponent(Base.class);
            logger.warn("Particle set entity does not have label or body (or both): " + base.getName());
        }
    }

    private double len(double x, double y, double z) {
        return FastMath.sqrt((double)(x * x + y * y + z * z));
    }

    private void initSortingData(Entity entity, ParticleSet particleSet) {
        List<IParticleRecord> pointData = particleSet.pointData;
        particleSet.metadata = new double[pointData.size()];
        int numFromGroupSettings = particleSet instanceof StarSet ? Settings.settings.scene.star.group.getMaxNumIndices() : Settings.settings.scene.particleGroups.numLabels;
        int K = FastMath.max((int)particleSet.numLabels, (int)numFromGroupSettings);
        K = FastMath.min((int)pointData.size(), (int)K);
        particleSet.indices = new int[K];
        for (int i = 0; i < K; ++i) {
            particleSet.indices[i] = -1;
        }
        particleSet.updaterTask = new ParticleSetUpdaterTask(entity, particleSet);
    }
}

