/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Line;
import gaiasky.scene.component.Perimeter;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.line.LineEntityRenderSystem;
import gaiasky.scene.system.update.GraphUpdater;

public class PerimeterInitializer
extends AbstractInitSystem {
    public PerimeterInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        Perimeter perimeter = (Perimeter)Mapper.perimeter.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Line line = (Line)Mapper.line.get(entity);
        line.lineWidth = 0.5f;
        line.renderConsumer = LineEntityRenderSystem::renderPerimeter;
        body.setColor(new float[]{0.8f, 0.8f, 0.0f, 1.0f});
        graph.localTransform = new Matrix4();
        graph.mustUpdateFunction = GraphUpdater::mustUpdatePerimeter;
        perimeter.maxlonlat = new Vector2(-1000.0f, -1000.0f);
        perimeter.minlonlat = new Vector2(1000.0f, 1000.0f);
        perimeter.cart0 = new Vector3();
        perimeter.loc3d = new float[perimeter.loc2d.length][][];
        for (int lineIndex = 0; lineIndex < perimeter.loc2d.length; ++lineIndex) {
            perimeter.loc3d[lineIndex] = new float[perimeter.loc2d[lineIndex].length][3];
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
    }
}

