/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.graphics.Texture;
import gaiasky.data.AssetBean;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Focus;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Raymarching;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.entity.FocusActive;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;
import gaiasky.util.GlobalResources;
import gaiasky.util.Settings;
import gaiasky.util.gdx.loader.OwnTextureLoader;
import gaiasky.util.i18n.I18n;

public class RaymarchingInitializer
extends AbstractInitSystem {
    public RaymarchingInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Focus focus = (Focus)Mapper.focus.get(entity);
        Raymarching rm = (Raymarching)Mapper.raymarching.get(entity);
        focus.activeFunction = FocusActive::isFocusActiveTrue;
        if (graph.parentName == null) {
            graph.parentName = "Universe";
        }
        if (body.size == 0.0f) {
            body.setSizeM(500.0);
        }
        if (base.ct == null || base.ct.allSetLike(new ComponentTypes(ComponentTypes.ComponentType.Others))) {
            base.ct = new ComponentTypes(ComponentTypes.ComponentType.Invisible);
        }
        if (rm.additionalTexture != null) {
            OwnTextureLoader.OwnTextureParameter tp = new OwnTextureLoader.OwnTextureParameter();
            tp.genMipMaps = false;
            tp.minFilter = Texture.TextureFilter.Linear;
            tp.magFilter = Texture.TextureFilter.Linear;
            tp.wrapU = Texture.TextureWrap.Repeat;
            tp.wrapV = Texture.TextureWrap.Repeat;
            rm.additionalTextureUnpacked = this.addToLoad(rm.additionalTexture, tp);
        } else {
            rm.additionalTextureUnpacked = null;
        }
    }

    private String addToLoad(String tex, OwnTextureLoader.OwnTextureParameter texParams) {
        if (tex == null) {
            return null;
        }
        tex = GlobalResources.unpackAssetPath(tex);
        this.logger.info(I18n.msg("notif.loading", tex));
        AssetBean.addAsset(tex, Texture.class, texParams);
        return tex;
    }

    @Override
    public void setUpEntity(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        Raymarching raymarching = (Raymarching)Mapper.raymarching.get(entity);
        if (raymarching != null) {
            if (raymarching.raymarchingShader != null && !raymarching.raymarchingShader.isBlank() && !Settings.settings.program.safeMode) {
                if (raymarching.additionalTextureUnpacked != null) {
                    if (AssetBean.manager().isLoaded(raymarching.additionalTextureUnpacked)) {
                        raymarching.additional = (Texture)AssetBean.manager().get(raymarching.additionalTextureUnpacked);
                        EventManager.publish(Event.RAYMARCHING_CMD, this, base.getName(), false, entity, raymarching.raymarchingShader, new float[]{1.0f, 0.0f, 0.0f, 0.0f}, raymarching.additional);
                    } else {
                        this.logger.warn("Could not load texture: " + raymarching.additionalTexture);
                        EventManager.publish(Event.RAYMARCHING_CMD, this, base.getName(), false, entity, raymarching.raymarchingShader, new float[]{1.0f, 0.0f, 0.0f, 0.0f});
                    }
                } else {
                    EventManager.publish(Event.RAYMARCHING_CMD, this, base.getName(), false, entity, raymarching.raymarchingShader, new float[]{1.0f, 0.0f, 0.0f, 0.0f});
                }
                Label label = (Label)Mapper.label.get(entity);
                SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
                sa.thresholdLabel = Math.toRadians(1.0E-6) / (double)Settings.settings.scene.label.number * 60.0;
                label.textScale = 0.2f;
                label.labelMax = 1.6f;
                if (label.labelFactor == 0.0f) {
                    label.labelFactor = 5.0E-4f;
                }
                label.renderConsumer = LabelEntityRenderSystem::renderCelestial;
                label.renderFunction = LabelView::renderTextBase;
            } else {
                raymarching.raymarchingShader = null;
            }
        }
    }
}

