/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Line;
import gaiasky.scene.entity.RulerRadio;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.line.LineEntityRenderSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;

public class RulerInitializer
extends AbstractInitSystem {
    public RulerInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Label label = (Label)Mapper.label.get(entity);
        Line line = (Line)Mapper.line.get(entity);
        label.label = true;
        label.textScale = 0.2f;
        label.labelFactor = 5.0E-4f;
        label.labelMax = 1.0f;
        label.renderConsumer = LabelEntityRenderSystem::renderRuler;
        label.renderFunction = LabelView::renderTextRuler;
        line.lineWidth = 1.0f;
        line.renderConsumer = LineEntityRenderSystem::renderRuler;
        EventManager.instance.subscribe((IObserver)new RulerRadio(entity), Event.RULER_ATTACH_0, Event.RULER_ATTACH_1, Event.RULER_CLEAR);
    }

    @Override
    public void setUpEntity(Entity entity) {
    }
}

