/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.scene.Index;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.util.i18n.I18n;

public class SceneGraphBuilderSystem
extends AbstractInitSystem {
    private final Index index;

    public SceneGraphBuilderSystem(Index index, Family family, int priority) {
        super(false, family, priority);
        this.index = index;
    }

    @Override
    public void initializeEntity(Entity entity) {
        GraphNode graph = (GraphNode)entity.getComponent(GraphNode.class);
        if (graph.parentName != null) {
            Entity parent = this.index.getEntity(graph.parentName);
            if (parent != null) {
                this.addChild(parent, entity, true);
            } else {
                this.logger.error(I18n.msg("error.parent.notfound", ((Base)Mapper.base.get(entity)).getName(), graph.parentName));
            }
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
    }

    public final void addChild(Entity parent, Entity child, boolean updateAncestorCount) {
        GraphNode graph = (GraphNode)Mapper.graph.get(child);
        GraphNode parentGraph = (GraphNode)Mapper.graph.get(parent);
        if (parentGraph.children == null) {
            parentGraph.initChildren(parentGraph.parent == null ? 100 : 1);
        }
        parentGraph.children.add((Object)child);
        graph.parent = parent;
        ++parentGraph.numChildren;
        if (updateAncestorCount) {
            Entity ancestor = parentGraph.parent;
            while (ancestor != null) {
                GraphNode ancestorGraph = (GraphNode)Mapper.graph.get(ancestor);
                ++ancestorGraph.numChildren;
                ancestor = ancestorGraph.parent;
            }
        }
    }

    public final void add(Entity parent, Entity ... children) {
        GraphNode parentGraph = (GraphNode)Mapper.graph.get(parent);
        if (parentGraph.children == null) {
            parentGraph.initChildren(parentGraph.parent == null || Mapper.octree.has(parent) ? 300000 : children.length * 5);
        }
        for (Entity child : children) {
            GraphNode graph = (GraphNode)Mapper.graph.get(child);
            parentGraph.children.add((Object)child);
            graph.parent = parent;
        }
        parentGraph.numChildren += children.length;
    }
}

