/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.math.Matrix4;
import gaiasky.data.AssetBean;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Focus;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Line;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.component.RenderType;
import gaiasky.scene.component.Shape;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.entity.FocusActive;
import gaiasky.scene.entity.FocusHit;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.initialize.ModelInitializer;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.system.update.GraphUpdater;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import net.jafama.FastMath;

public class ShapeInitializer
extends AbstractInitSystem {
    public ShapeInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Model modelComp = (Model)Mapper.model.get(entity);
        ModelComponent mc = modelComp.model;
        if (mc != null) {
            mc.initialize(base.getLocalizedName());
        }
        graph.positionUpdaterConsumer = GraphUpdater::updateShapeObject;
    }

    @Override
    public void setUpEntity(Entity entity) {
        Line line = (Line)Mapper.line.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        Shape shape = (Shape)Mapper.shape.get(entity);
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        Focus focus = (Focus)Mapper.focus.get(entity);
        if (transform.matrix != null) {
            transform.matrixf = transform.matrix.putIn(new Matrix4());
        }
        label.label = true;
        label.textScale = 0.2f;
        label.labelMax = 1.0f;
        if (label.labelFactor == 0.0f) {
            label.labelFactor = (float)((double)5.0E-4f * Constants.DISTANCE_SCALE_FACTOR);
        }
        label.renderConsumer = LabelEntityRenderSystem::renderShape;
        label.renderFunction = LabelView::renderTextEssential;
        line.lineWidth = 1.5f;
        if (focus.focusable) {
            focus.hitCoordinatesConsumer = FocusHit::addHitCoordinateModel;
            focus.hitRayConsumer = FocusHit::addHitRayModel;
            focus.activeFunction = FocusActive::isFocusActiveTrue;
        }
        SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
        double baseThreshold = FastMath.toRadians((double)2.0);
        sa.thresholdNone = 0.0;
        sa.thresholdPoint = baseThreshold / 10.0;
        sa.thresholdQuad = baseThreshold;
        sa.thresholdLabel = FastMath.toRadians((double)0.2);
        this.initModel(entity);
    }

    public void initModel(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Model modelComp = (Model)Mapper.model.get(entity);
        RenderType rt = (RenderType)Mapper.renderType.get(entity);
        modelComp.renderConsumer = ModelEntityRenderSystem::renderShape;
        ModelComponent mc = modelComp.model;
        graph.localTransform = new Matrix4();
        if (mc != null) {
            mc.doneLoading(AssetBean.manager(), graph.localTransform, body.color);
            if (mc.isStaticLight()) {
                DirectionalLight dLight = new DirectionalLight();
                dLight.set(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                mc.env = new Environment();
                mc.env.add(dLight);
                mc.env.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 0.4f, 0.4f, 0.4f, 1.0f));
            }
            if (Settings.settings.runtime.relativisticAberration) {
                mc.rec.setUpRelativisticEffectsMaterial(mc.instance.materials);
            }
            if (Settings.settings.runtime.gravitationalWaves) {
                mc.rec.setUpGravitationalWavesMaterial(mc.instance.materials);
            }
            ModelInitializer.initializeModelSize(modelComp);
        }
        if (rt.renderGroup == null) {
            rt.renderGroup = RenderGroup.MODEL_BG;
        }
    }
}

