/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Coordinates;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.TLESource;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.initialize.TrajectoryInitializer;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.coord.TLEParser;
import gaiasky.util.ds.GaiaSkyExecutorService;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;

public class TLEInitializer
extends AbstractInitSystem {
    private final Scene scene;

    public TLEInitializer(Scene scene, boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
        this.scene = scene;
    }

    @Override
    public void initializeEntity(Entity entity) {
    }

    @Override
    public void setUpEntity(Entity entity) {
        GaiaSkyExecutorService executorService = GaiaSky.instance.getExecutorService();
        executorService.execute(() -> {
            Base base = (Base)Mapper.base.get(entity);
            Instant now = Instant.now();
            TLESource tle = (TLESource)Mapper.tle.get(entity);
            String fileName = TextUtils.sanitizeFilename(tle.nameTLE + "-TLE.json");
            Path cacheDir = SysUtils.getDataCacheDir(Settings.settings.data.location);
            boolean ignored = cacheDir.toFile().mkdirs();
            Path filePath = cacheDir.resolve(fileName);
            boolean mustUpdate = false;
            if (Files.exists(filePath, new LinkOption[0])) {
                JsonReader jsonReader = new JsonReader();
                try {
                    JsonValue data = jsonReader.parse(new FileHandle(filePath.toFile()));
                    String lastUpdateStr = data.getString("lastUpdate");
                    Instant lastUpdate = Instant.parse(lastUpdateStr);
                    mustUpdate = (double)(now.getEpochSecond() - lastUpdate.getEpochSecond()) / 86400.0 > tle.updateIntervalTLE;
                }
                catch (Exception e) {
                    mustUpdate = true;
                }
            } else {
                mustUpdate = true;
            }
            TLEParser.OrbitalElements elements = null;
            if (mustUpdate) {
                this.logger.info("Fetching TLE data for " + base.getName());
                try {
                    TLEParser parser = new TLEParser();
                    elements = parser.getOrbitalElements(tle.urlTLE, tle.nameTLE);
                    if (Files.exists(filePath, new LinkOption[0])) {
                        try {
                            Files.delete(filePath);
                        }
                        catch (IOException lastUpdateStr) {
                            // empty catch block
                        }
                    }
                    this.writeElements(filePath, now, elements);
                }
                catch (Exception e) {
                    this.logger.error("Error fetching TLE data for " + base.getName(), e);
                }
            } else {
                this.logger.info("Using cached file: " + fileName);
            }
            if (elements == null) {
                JsonReader jsonReader = new JsonReader();
                try {
                    JsonValue data = jsonReader.parse(new FileHandle(filePath.toFile()));
                    JsonValue elem = data.get("elements");
                    elements = new TLEParser.OrbitalElements();
                    elements.epochJD = elem.getDouble("epoch");
                    elements.period = elem.getDouble("period");
                    elements.semiMajorAxis = elem.getDouble("semiMajorAxis");
                    elements.eccentricity = elem.getDouble("eccentricity");
                    elements.inclination = elem.getDouble("inclination");
                    elements.ascendingNode = elem.getDouble("ascendingNode");
                    elements.meanAnomaly = elem.getDouble("meanAnomaly");
                    elements.argOfPericenter = elem.getDouble("argOfPericenter");
                }
                catch (Exception e) {
                    this.logger.error(e);
                }
            }
            Trajectory trajectory = (Trajectory)Mapper.trajectory.get(entity);
            if (elements != null && trajectory.oc != null) {
                trajectory.oc.epoch = elements.epochJD;
                trajectory.oc.period = elements.period;
                trajectory.oc.i = elements.inclination;
                trajectory.oc.e = elements.eccentricity;
                trajectory.oc.semiMajorAxis = elements.semiMajorAxis;
                trajectory.oc.ascendingNode = elements.ascendingNode;
                trajectory.oc.argOfPericenter = elements.argOfPericenter;
                trajectory.oc.meanAnomaly = elements.meanAnomaly;
                GaiaSky.postRunnable(() -> {
                    Verts verts = (Verts)Mapper.verts.get(entity);
                    Render render = (Render)Mapper.render.get(entity);
                    TrajectoryInitializer.loadTrajectory(entity, base, trajectory, verts);
                    verts.markForUpdate(render);
                    Entity attachedEntity = trajectory.body;
                    if (attachedEntity != null) {
                        Coordinates coord = (Coordinates)Mapper.coordinates.get(attachedEntity);
                        if (coord.coordinates != null) {
                            coord.coordinates.doneLoading(this.scene, attachedEntity);
                        }
                    }
                });
            }
        });
    }

    private void writeElements(Path filePath, Instant now, TLEParser.OrbitalElements elements) throws IOException {
        FileHandle f = Gdx.files.absolute(filePath.toString());
        try (OutputStreamWriter writer = new OutputStreamWriter(f.write(false), StandardCharsets.UTF_8);){
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setOutputType(JsonWriter.OutputType.json);
            jsonWriter.object();
            jsonWriter.set("lastUpdate", (Object)now.toString());
            jsonWriter.object("elements");
            jsonWriter.set("period", (Object)elements.period);
            jsonWriter.set("epoch", (Object)elements.epochJD);
            jsonWriter.set("semiMajorAxis", (Object)elements.semiMajorAxis);
            jsonWriter.set("eccentricity", (Object)elements.eccentricity);
            jsonWriter.set("inclination", (Object)elements.inclination);
            jsonWriter.set("ascendingNode", (Object)elements.ascendingNode);
            jsonWriter.set("argOfPericenter", (Object)elements.argOfPericenter);
            jsonWriter.set("meanAnomaly", (Object)elements.meanAnomaly);
            jsonWriter.pop();
            jsonWriter.pop();
            jsonWriter.flush();
        }
        catch (Exception e) {
            this.logger.error("Error writing JSON: " + String.valueOf(filePath), e);
        }
    }
}

