/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import gaiasky.data.api.IOrbitDataProvider;
import gaiasky.data.util.OrbitDataLoader;
import gaiasky.data.util.PointCloudData;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Line;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.entity.TrajectoryUtils;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.line.LineEntityRenderSystem;
import gaiasky.util.Logger;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;

public class TrajectoryInitializer
extends AbstractInitSystem {
    private static final Logger.Log logger = Logger.getLogger(TrajectoryInitializer.class);
    private final TrajectoryUtils utils = new TrajectoryUtils();

    public TrajectoryInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
        TrajectoryUtils.initRefresher(this.utils);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        Trajectory trajectory = (Trajectory)Mapper.trajectory.get(entity);
        Verts verts = (Verts)Mapper.verts.get(entity);
        Line line = (Line)Mapper.line.get(entity);
        TrajectoryInitializer.loadTrajectory(entity, base, trajectory, verts);
        verts.glPrimitive = 3;
        verts.renderGroup = RenderGroup.LINE_GPU;
        line.renderConsumer = LineEntityRenderSystem::renderTrajectory;
        if (body.color == null) {
            body.color = new float[]{0.8f, 0.8f, 0.8f, 1.0f};
        }
        if (trajectory.bodyColor == null) {
            trajectory.bodyColor = new float[]{0.8f, 0.8f, 0.8f, 0.6f};
        }
    }

    public static void loadTrajectory(Entity entity, Base base, Trajectory trajectory, Verts verts) {
        if (trajectory.bodyRepresentation.isOrbit() && trajectory.provider != null) {
            try {
                trajectory.providerClass = ClassReflection.forName((String)trajectory.provider);
                try {
                    trajectory.providerInstance = (IOrbitDataProvider)ClassReflection.newInstance(trajectory.providerClass);
                    trajectory.providerInstance.initialize(entity, trajectory);
                    trajectory.providerInstance.load(trajectory.oc.source, new OrbitDataLoader.OrbitDataLoaderParameters(base.names[0], trajectory.providerClass, trajectory.oc, (double)trajectory.multiplier, trajectory.numSamples, trajectory.sampling), trajectory.newMethod);
                    verts.pointCloudData = trajectory.providerInstance.getData();
                    AffineTransformations affine = (AffineTransformations)Mapper.affine.get(entity);
                    if (affine != null && !affine.isEmpty()) {
                        PointCloudData data = verts.pointCloudData;
                        Vector3D v = new Vector3D();
                        Matrix4D mat = new Matrix4D();
                        affine.apply(mat);
                        for (int i = 0; i < data.getNumPoints(); ++i) {
                            data.loadPoint(v, i);
                            v.mul(mat);
                            data.setPoint(v, i);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(e);
                }
            }
            catch (ReflectionException e) {
                logger.error(e);
            }
        }
    }

    @Override
    public void setUpEntity(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        Trajectory trajectory = (Trajectory)Mapper.trajectory.get(entity);
        Verts verts = (Verts)Mapper.verts.get(entity);
        trajectory.alpha = body.color[3];
        this.utils.initOrbitMetadata(body, trajectory, verts);
        verts.primitiveSize = 1.1f;
        TrajectoryInitializer.initializeBodyConnection(entity, trajectory);
        this.utils.initializeTransformMatrix(trajectory, graph, transform);
        trajectory.isInOrbitalElementsGroup = graph.parent != null && Mapper.orbitElementsSet.has(graph.parent);
    }

    public static void initializeBodyConnection(Entity entity, Trajectory trajectory) {
        if (trajectory.body != null) {
            Base bodyBase = (Base)Mapper.base.get(trajectory.body);
            trajectory.params = new OrbitDataLoader.OrbitDataLoaderParameters(bodyBase.names[0], null, trajectory.oc.period, 600, trajectory.sampling);
            trajectory.params.entity = entity;
        }
    }
}

