/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Matrix4;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Line;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.VRDevice;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.line.LineEntityRenderSystem;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.util.Bits;
import gaiasky.util.Logger;
import gaiasky.util.ModelCache;
import gaiasky.util.Pair;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.math.Vector3D;
import java.util.HashMap;
import java.util.Map;

public class VRDeviceInitializer
extends AbstractInitSystem {
    private static final Logger.Log logger = Logger.getLogger(VRDeviceInitializer.class);

    public VRDeviceInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        if (Mapper.vr.has(entity)) {
            this.initializeVRDevice(entity);
        }
        if (Mapper.tagVRUI.has(entity)) {
            this.initializeVRUI(entity);
        }
    }

    private void initializeVRUI(Entity entity) {
    }

    private void initializeVRDevice(Entity entity) {
        VRDevice vr = (VRDevice)Mapper.vr.get(entity);
        vr.beamP0 = new Vector3D();
        vr.beamP1 = new Vector3D();
        vr.intersection = new Vector3D();
        Base base = (Base)Mapper.base.get(entity);
        base.setComponentType(ComponentTypes.ComponentType.Others);
        Body body = (Body)Mapper.body.get(entity);
        body.color = new float[]{1.0f, 0.0f, 0.0f};
        Line line = (Line)Mapper.line.get(entity);
        line.lineWidth = 2.0f;
        line.renderConsumer = LineEntityRenderSystem::renderVRDevice;
        Model model = (Model)Mapper.model.get(entity);
        if (vr.device != null) {
            model.model.instance = vr.device.getModelInstance();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("diameter", 1.0);
            params.put("quality", 20L);
            params.put("flip", false);
            Pair<IntModel, Map<String, Material>> pair = ModelCache.cache.getModel("sphere", params, Bits.indices(1, 8), 4);
            IntModel sphere = pair.getFirst();
            vr.intersectionModel = new IntModelInstance(sphere, new Matrix4());
            ((Material)vr.intersectionModel.materials.get(0)).set((Attribute)new ColorAttribute(ColorAttribute.Diffuse, ColorUtils.gRedC));
            ((Material)vr.intersectionModel.materials.get(0)).set((Attribute)new BlendingAttribute(true, 770, 771, 0.7f));
        } else {
            logger.error("VR device model has no attached device!");
        }
        if (model.renderConsumer == null) {
            model.renderConsumer = ModelEntityRenderSystem::renderVRDeviceModel;
        }
        EventManager.publish(Event.VR_CONTROLLER_INFO, this, vr);
    }

    @Override
    public void setUpEntity(Entity entity) {
    }
}

